/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.rendering;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import jds.bibliocraft.helpers.EnumShiftPosition;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.items.ItemClipboard;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.MapData;
import net.minecraftforge.client.model.Attributes;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import org.lwjgl.opengl.GL11;

public abstract class TileEntityBiblioRenderer
extends TileEntitySpecialRenderer {
    private static final ResourceLocation RES_MAP_BACKGROUND = new ResourceLocation("textures/map/map_background.png");
    Minecraft mc = Minecraft.func_71410_x();
    private EnumFacing angle = EnumFacing.NORTH;
    private EnumVertPosition vert = EnumVertPosition.FLOOR;
    private EnumShiftPosition shift = EnumShiftPosition.NO_SHIFT;
    public float xshift;
    public float zshift;
    public int degreeAngle;
    public double globalX;
    public double globalY;
    public double globalZ;
    public Tessellator tessellator;
    public BufferBuilder worldRenderer;
    private RenderItem itemRenderer;
    private RenderManager renderManager = Minecraft.func_71410_x().func_175598_ae();
    private final String[] itemsThatNeedRotating = new String[]{"swordpedestal", "Typewriter", "BiblioCraft:PaintingPress", "BiblioCraft:PrintingPress", "BiblioCraft:TypesettingTable", "Lantern", "Lamp", "item.tconstruct"};
    protected Function<ResourceLocation, TextureAtlasSprite> getModelTexture = new Function<ResourceLocation, TextureAtlasSprite>(){

        public TextureAtlasSprite apply(ResourceLocation location) {
            return Minecraft.func_71410_x().func_147117_R().func_110572_b(TileEntityBiblioRenderer.this.getTextureString(location));
        }
    };

    public void func_192841_a(TileEntity tileEntity, double x, double y, double z, float tick, int destroyStage, float what) {
        this.globalX = x;
        this.globalY = y;
        this.globalZ = z;
        BiblioTileEntity tile = (BiblioTileEntity)tileEntity;
        if (tile != null) {
            this.angle = tile.getAngle();
            this.vert = tile.getVertPosition();
            this.shift = tile.getShiftPosition();
        }
        this.xshift = 0.0f;
        this.zshift = 0.0f;
        if (this.itemRenderer == null || this.tessellator == null || this.worldRenderer == null) {
            this.itemRenderer = Minecraft.func_71410_x().func_175599_af();
            this.tessellator = Tessellator.func_178181_a();
            this.worldRenderer = this.tessellator.func_178180_c();
        }
        float halfShift = 0.25f;
        float fullShift = 0.5f;
        switch (this.angle) {
            case SOUTH: {
                this.degreeAngle = 270;
                this.xshift = 1.0f;
                this.zshift = 0.0f;
                if (this.shift == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += -fullShift;
                    this.zshift += 0.0f;
                }
                if (this.shift != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += -halfShift;
                this.zshift += 0.0f;
                break;
            }
            case WEST: {
                this.degreeAngle = 180;
                this.xshift = 1.0f;
                this.zshift = 1.0f;
                if (this.shift == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += 0.0f;
                    this.zshift += -fullShift;
                }
                if (this.shift != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += 0.0f;
                this.zshift += -halfShift;
                break;
            }
            case NORTH: {
                this.degreeAngle = 90;
                this.xshift = 0.0f;
                this.zshift = 1.0f;
                if (this.shift == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += fullShift;
                    this.zshift += 0.0f;
                }
                if (this.shift != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += halfShift;
                this.zshift += 0.0f;
                break;
            }
            case EAST: {
                this.degreeAngle = 0;
                this.xshift = 0.0f;
                this.zshift = 0.0f;
                if (this.shift == EnumShiftPosition.FULL_SHIFT) {
                    this.xshift += 0.0f;
                    this.zshift += fullShift;
                }
                if (this.shift != EnumShiftPosition.HALF_SHIFT) break;
                this.xshift += 0.0f;
                this.zshift += halfShift;
                break;
            }
        }
        this.render(tile, x, y, z, tick);
    }

    public abstract void render(BiblioTileEntity var1, double var2, double var4, double var6, float var8);

    public EnumFacing getAngle() {
        return this.angle;
    }

    public EnumVertPosition getVertPosition() {
        return this.vert;
    }

    public EnumShiftPosition getShiftPosition() {
        return this.shift;
    }

    public void renderSlotItem(ItemStack stack, double x, double y, double z, float scale) {
        if (stack != null && stack != ItemStack.field_190927_a) {
            switch (this.angle) {
                case SOUTH: {
                    double tx = x;
                    x = -z;
                    z = tx;
                    break;
                }
                case WEST: {
                    x *= -1.0;
                    z *= -1.0;
                    break;
                }
                case NORTH: {
                    double tx = x;
                    x = z;
                    z = -tx;
                    break;
                }
                case EAST: {
                    break;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)(this.globalX + x + (double)this.xshift), (double)(this.globalY + y + 0.05), (double)(this.globalZ + z + (double)this.zshift));
            GlStateManager.func_179114_b((float)((float)this.degreeAngle + 180.0f), (float)0.0f, (float)1.0f, (float)0.0f);
            this.additionalGLStuffForItemStack();
            Block testBlock = Block.func_149634_a((Item)stack.func_77973_b());
            if (this.isRotatedBlock(stack.func_77977_a())) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            if (stack.func_77973_b() instanceof ItemClipboard) {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GlStateManager.func_179137_b((double)0.4, (double)0.05, (double)0.0);
            }
            if (testBlock == null) {
                scale *= 0.7f;
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
            this.itemRenderer.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            GlStateManager.func_179121_F();
        }
    }

    private boolean isRotatedBlock(String name) {
        boolean value = false;
        for (int i = 0; i < this.itemsThatNeedRotating.length; ++i) {
            if (!name.contains(this.itemsThatNeedRotating[i])) continue;
            value = true;
        }
        return value;
    }

    public void additionalGLStuffForItemStack() {
    }

    public void renderItemMap(ItemStack stack, float x, float y, float z, float scale) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.globalX + (double)x), (double)(this.globalY + (double)y + (double)1.02f), (double)(this.globalZ + (double)z));
        GlStateManager.func_179114_b((float)90.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        scale = (float)((double)scale * 0.0063);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        this.mc.func_110434_K().func_110577_a(RES_MAP_BACKGROUND);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder worldrenderer = tessellator.func_178180_c();
        GL11.glNormal3f((float)0.0f, (float)0.0f, (float)-1.0f);
        worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        worldrenderer.func_181662_b(-7.0, 135.0, 0.0).func_187315_a(0.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b(135.0, 135.0, 0.0).func_187315_a(1.0, 1.0).func_181675_d();
        worldrenderer.func_181662_b(135.0, -7.0, 0.0).func_187315_a(1.0, 0.0).func_181675_d();
        worldrenderer.func_181662_b(-7.0, -7.0, 0.0).func_187315_a(0.0, 0.0).func_181675_d();
        tessellator.func_78381_a();
        MapData mapdata = Items.field_151098_aY.func_77873_a(stack, this.func_178459_a());
        if (mapdata != null) {
            this.mc.field_71460_t.func_147701_i().func_148250_a(mapdata, false);
        }
        GlStateManager.func_179121_F();
    }

    public IBakedModel initModel(List<String> parts, ResourceLocation modelResource) {
        IModel model = null;
        try {
            model = ModelLoaderRegistry.getModel((ResourceLocation)modelResource);
            model = model.process(ImmutableMap.of((Object)"flip-v", (Object)"true"));
        }
        catch (Exception e) {
            model = ModelLoaderRegistry.getMissingModel();
        }
        OBJModel.OBJState state = new OBJModel.OBJState(parts, true);
        return model.bake((IModelState)state, Attributes.DEFAULT_BAKED_FORMAT, this.getModelTexture);
    }

    public String getTextureString(ResourceLocation location) {
        return location.toString();
    }

    public void renderText(String text, double xAdjust, double yAdjust, double zAdjust) {
        FontRenderer fontRender = this.func_147498_b();
        float offsetx = 0.0f;
        float offsetz = 0.0f;
        switch (this.getAngle()) {
            case NORTH: {
                offsetx = 0.0116f;
                break;
            }
            case SOUTH: {
                offsetx = -0.0116f;
                break;
            }
            case WEST: {
                offsetz = -0.0116f;
                break;
            }
            case EAST: {
                offsetz = 0.0116f;
                break;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179137_b((double)(this.globalX + 0.5 + (double)offsetx), (double)this.globalY, (double)(this.globalZ + 0.5 + (double)offsetz));
        switch (this.getAngle()) {
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                break;
            }
        }
        GlStateManager.func_179137_b((double)(-0.5 + xAdjust), (double)yAdjust, (double)zAdjust);
        GlStateManager.func_179132_a((boolean)false);
        GlStateManager.func_179152_a((float)0.0045f, (float)0.0045f, (float)0.0045f);
        GlStateManager.func_179114_b((float)270.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        switch (this.shift) {
            case HALF_SHIFT: {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-95.0);
                break;
            }
            case FULL_SHIFT: {
                GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-205.0);
                break;
            }
        }
        this.additionalGLStuffForText();
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-0.010416667f);
        fontRender.func_78276_b(text, 0, 0, 0);
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179121_F();
    }

    public void additionalGLStuffForText() {
    }
}

