/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.items;

import java.util.List;
import jds.bibliocraft.Config;
import jds.bibliocraft.network.BiblioNetworking;
import jds.bibliocraft.network.packet.client.BiblioOpenBook;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemRecipeBook
extends Item {
    public static final String name = "RecipeBook";
    public static final ItemRecipeBook instance = new ItemRecipeBook();
    private int[] ingredientCounts = new int[9];
    private String[] ingredientNames = new String[9];
    private int ingredientsTest;
    public boolean showText = false;
    public boolean showTextChanged = false;
    public String showTextString = "";

    public ItemRecipeBook() {
        this.func_77655_b(name);
        this.func_77625_d(1);
        this.setRegistryName(name);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!world.field_72995_K && hand == EnumHand.MAIN_HAND) {
            BiblioNetworking.INSTANCE.sendTo((IMessage)new BiblioOpenBook(Config.enableRecipeBookCrafting), (EntityPlayerMP)player);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public boolean func_77636_d(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            return nbt.func_74767_n("signed");
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        this.compareingredients(stack);
        tooltip.add(I18n.func_74838_a((String)"book.ingredients"));
        for (int i = 0; i < this.ingredientCounts.length; ++i) {
            this.ingredientsTest = this.ingredientCounts[i];
            if (this.ingredientCounts[i] == 0 || this.ingredientNames[i].contains("Air")) continue;
            tooltip.add(this.ingredientCounts[i] + "x " + this.ingredientNames[i]);
        }
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public void updateFromPacket(String displayString) {
        this.showText = true;
        this.showTextChanged = true;
        this.showTextString = displayString;
    }

    public void compareingredients(ItemStack stack) {
        NBTTagCompound nbt;
        this.ingredientCounts = new int[9];
        this.ingredientNames = new String[9];
        if (stack.func_77973_b() instanceof ItemRecipeBook && (nbt = stack.func_77978_p()) != null) {
            NBTTagList tagList = nbt.func_150295_c("grid", 10);
            for (int i = 0; i < 9; ++i) {
                ItemStack nbtStack;
                NBTTagCompound tag = tagList.func_150305_b(i);
                byte slot = tag.func_74771_c("Slot");
                if (slot < 0 || slot >= 9 || (nbtStack = new ItemStack(tag)) == ItemStack.field_190927_a) continue;
                int n = 0;
                boolean complete = false;
                boolean havematch = false;
                for (int m = 0; m < this.ingredientNames.length; ++m) {
                    if (this.ingredientNames[m] == null || !this.ingredientNames[m].matches(nbtStack.func_82833_r())) continue;
                    n = m;
                    havematch = true;
                }
                if (havematch) {
                    int n2 = n;
                    this.ingredientCounts[n2] = this.ingredientCounts[n2] + 1;
                    continue;
                }
                while (!complete) {
                    if (this.ingredientCounts[n] == 0) {
                        int n3 = n;
                        this.ingredientCounts[n3] = this.ingredientCounts[n3] + 1;
                        this.ingredientNames[n] = nbtStack.func_82833_r();
                        complete = true;
                        continue;
                    }
                    if (n >= 8) continue;
                    ++n;
                }
            }
        }
    }
}

