/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import jds.bibliocraft.BiblioCraft;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityFramedChest;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;

public class BlockFramedChest
extends BiblioWoodBlock {
    public static final String name = "FramedChest";
    public static final BlockFramedChest instance = new BlockFramedChest();

    public BlockFramedChest() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (!world.field_72995_K && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityFramedChest) {
            TileEntityFramedChest chest2;
            TileEntityFramedChest chest = (TileEntityFramedChest)tile;
            if (chest.getIsDouble() && (chest2 = this.getAdjacentChest(chest, world)) != null) {
                chest.setAdjacentChest(chest2);
                chest2.setAdjacentChest(chest);
                chest2.addUsingPlayer(true);
            }
            chest.addUsingPlayer(true);
            player.openGui((Object)BiblioCraft.instance, 0, world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        }
        return true;
    }

    public TileEntityFramedChest getAdjacentChest(TileEntityFramedChest chest, World world) {
        TileEntityFramedChest chest2;
        TileEntity tile = null;
        int x = chest.func_174877_v().func_177958_n();
        int y = chest.func_174877_v().func_177956_o();
        int z = chest.func_174877_v().func_177952_p();
        switch (chest.getAngle()) {
            case SOUTH: {
                if (chest.getIsLeft()) {
                    ++z;
                    break;
                }
                --z;
                break;
            }
            case WEST: {
                if (chest.getIsLeft()) {
                    --x;
                    break;
                }
                ++x;
                break;
            }
            case NORTH: {
                if (chest.getIsLeft()) {
                    --z;
                    break;
                }
                ++z;
                break;
            }
            case EAST: {
                if (chest.getIsLeft()) {
                    ++x;
                    break;
                }
                --x;
                break;
            }
        }
        tile = world.func_175625_s(new BlockPos(x, y, z));
        if (tile != null && tile instanceof TileEntityFramedChest && (chest2 = (TileEntityFramedChest)tile).getIsDouble()) {
            return chest2;
        }
        return null;
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityFramedChest();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        TileEntityFramedChest chest;
        ArrayList<String> modelParts = new ArrayList<String>();
        modelParts.add("small_chest");
        if (tile instanceof TileEntityFramedChest && (chest = (TileEntityFramedChest)tile).getIsDouble()) {
            modelParts = new ArrayList();
            if (chest.getIsLeft()) {
                modelParts.add("large_chest_left");
            } else {
                modelParts.add("large_chest_right");
            }
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        return transform;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        TileEntityFramedChest chest;
        AxisAlignedBB output = this.getBlockBounds(0.054f, 0.0f, 0.054f, 0.946f, 0.866f, 0.946f);
        TileEntity tile = blockAccess.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityFramedChest && (chest = (TileEntityFramedChest)tile).getIsDouble()) {
            switch (chest.getAngle()) {
                case SOUTH: {
                    if (chest.getIsLeft()) {
                        output = this.getBlockBounds(0.054f, 0.0f, 0.054f, 0.946f, 0.866f, 1.0f);
                        break;
                    }
                    output = this.getBlockBounds(0.054f, 0.0f, 0.0f, 0.946f, 0.866f, 0.946f);
                    break;
                }
                case WEST: {
                    if (chest.getIsLeft()) {
                        output = this.getBlockBounds(0.0f, 0.0f, 0.054f, 0.946f, 0.866f, 0.946f);
                        break;
                    }
                    output = this.getBlockBounds(0.054f, 0.0f, 0.054f, 1.0f, 0.866f, 0.946f);
                    break;
                }
                case NORTH: {
                    if (chest.getIsLeft()) {
                        output = this.getBlockBounds(0.054f, 0.0f, 0.0f, 0.946f, 0.866f, 0.946f);
                        break;
                    }
                    output = this.getBlockBounds(0.054f, 0.0f, 0.054f, 0.946f, 0.866f, 1.0f);
                    break;
                }
                case EAST: {
                    if (chest.getIsLeft()) {
                        output = this.getBlockBounds(0.054f, 0.0f, 0.054f, 1.0f, 0.866f, 0.946f);
                        break;
                    }
                    output = this.getBlockBounds(0.0f, 0.0f, 0.054f, 0.946f, 0.866f, 0.946f);
                    break;
                }
            }
        }
        return output;
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        TileEntityFramedChest chest2;
        TileEntityFramedChest chest;
        this.dropItems(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityFramedChest && (chest = (TileEntityFramedChest)tile).getIsDouble() && (chest2 = this.getAdjacentChest(chest, world)) != null) {
            chest2.setIsDouble(false, true, null);
        }
        super.func_180663_b(world, pos, state);
    }
}

