/*
 * Decompiled with CFR 0.152.
 */
package jds.bibliocraft.blocks;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Vector3f;
import jds.bibliocraft.blocks.BiblioWoodBlock;
import jds.bibliocraft.gui.GuiClock;
import jds.bibliocraft.helpers.EnumShiftPosition;
import jds.bibliocraft.helpers.EnumVertPosition;
import jds.bibliocraft.tileentities.BiblioTileEntity;
import jds.bibliocraft.tileentities.TileEntityClock;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockClock
extends BiblioWoodBlock {
    public static final String name = "Clock";
    public static final BlockClock instance = new BlockClock();

    public BlockClock() {
        super(name, false);
    }

    @Override
    public boolean onBlockActivatedCustomCommands(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tile;
        if (world.field_72995_K && player.func_70093_af() && (tile = world.func_175625_s(pos)) != null && tile instanceof TileEntityClock) {
            TileEntityClock ctile = (TileEntityClock)tile;
            if (ctile.getVertPosition() == EnumVertPosition.FLOOR) {
                TileEntity upperTile = world.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
                if (upperTile != null && upperTile instanceof TileEntityClock) {
                    this.openGUI((TileEntityClock)upperTile, player);
                }
            } else {
                this.openGUI(ctile, player);
            }
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void openGUI(TileEntityClock clock, EntityPlayer player) {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiClock(clock, player));
    }

    @Override
    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityClock();
    }

    @Override
    public List<String> getModelParts(BiblioTileEntity tile) {
        ArrayList<String> modelParts = new ArrayList<String>();
        if (tile.getVertPosition() == EnumVertPosition.WALL) {
            modelParts.add("face");
            modelParts.add("smallClock");
            modelParts.add("smallHardware");
        } else if (tile.getVertPosition() == EnumVertPosition.CEILING) {
            modelParts.add("face");
            modelParts.add("largeClock");
            modelParts.add("largeHardware");
        }
        return modelParts;
    }

    @Override
    public void additionalPlacementCommands(BiblioTileEntity biblioTile, EntityLivingBase player) {
    }

    @Override
    public TRSRTransformation getAdditionalTransforms(TRSRTransformation transform, BiblioTileEntity tile) {
        transform = transform.compose(new TRSRTransformation(new Vector3f(0.17f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
        switch (tile.getShiftPosition()) {
            case HALF_SHIFT: {
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.1f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                break;
            }
            case FULL_SHIFT: {
                transform = transform.compose(new TRSRTransformation(new Vector3f(0.168f, 0.0f, 0.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f), new Vector3f(1.0f, 1.0f, 1.0f), new Quat4f(0.0f, 0.0f, 0.0f, 1.0f)));
                break;
            }
        }
        return transform;
    }

    @Override
    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess blockAccess, BlockPos pos) {
        AxisAlignedBB output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te != null && te instanceof TileEntityClock) {
            TileEntityClock tile = (TileEntityClock)te;
            EnumFacing angleGet = tile.getAngle();
            float shiftAmount = 0.0f;
            if (tile.getShiftPosition() == EnumShiftPosition.FULL_SHIFT) {
                shiftAmount = 0.675f;
            } else if (tile.getShiftPosition() == EnumShiftPosition.HALF_SHIFT) {
                shiftAmount = 0.3625f;
            }
            switch (angleGet) {
                case SOUTH: {
                    output = this.getBlockBounds(0.73f - shiftAmount, 0.0f, 0.3f, 1.0f - shiftAmount, 1.0f, 0.7f);
                    break;
                }
                case WEST: {
                    output = this.getBlockBounds(0.3f, 0.0f, 0.73f - shiftAmount, 0.7f, 1.0f, 1.0f - shiftAmount);
                    break;
                }
                case NORTH: {
                    output = this.getBlockBounds(0.0f + shiftAmount, 0.0f, 0.3f, 0.27f + shiftAmount, 1.0f, 0.7f);
                    break;
                }
                case EAST: {
                    output = this.getBlockBounds(0.3f, 0.0f, 0.0f + shiftAmount, 0.7f, 1.0f, 0.27f + shiftAmount);
                    break;
                }
                default: {
                    output = this.getBlockBounds(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f);
                }
            }
        }
        return output;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityClock) {
            TileEntityClock clock = (TileEntityClock)tile;
            if (clock.redstoneActive) {
                return 15;
            }
        }
        return 0;
    }

    public int func_176211_b(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return this.func_180656_a(state, world, pos, side);
    }

    @Override
    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.dropItems(world, pos);
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityClock) {
            TileEntityClock clock = (TileEntityClock)tile;
            if (clock.getVertPosition() == EnumVertPosition.FLOOR) {
                TileEntityClock topClock = (TileEntityClock)world.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()));
                topClock.setVertPosition(EnumVertPosition.WALL);
            } else if (clock.getVertPosition() == EnumVertPosition.CEILING) {
                TileEntityClock bottomClock = (TileEntityClock)world.func_175625_s(new BlockPos(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()));
                bottomClock.setVertPosition(EnumVertPosition.WALL);
            }
        }
        super.func_180663_b(world, pos, state);
    }
}

