/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.passive.mountable;

import com.gildedgames.the_aether.AetherConfig;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.entities.ai.swet.SwetAIConsume;
import com.gildedgames.the_aether.entities.ai.swet.SwetAIFaceRandom;
import com.gildedgames.the_aether.entities.ai.swet.SwetAIHop;
import com.gildedgames.the_aether.entities.ai.swet.SwetAIHunt;
import com.gildedgames.the_aether.entities.ai.swet.SwetMoveHelper;
import com.gildedgames.the_aether.entities.util.EntityMountable;
import com.gildedgames.the_aether.entities.util.EnumSwetType;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.networking.AetherNetworkingManager;
import com.gildedgames.the_aether.networking.packets.PacketSwetJump;
import com.gildedgames.the_aether.registry.AetherLootTables;
import com.gildedgames.the_aether.registry.sounds.SoundsAether;
import io.netty.buffer.ByteBuf;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAINearestAttackableTarget;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntitySwet
extends EntityMountable
implements IEntityAdditionalSpawnData {
    private int swetType;
    public boolean wasOnGround;
    public boolean midJump;
    public int jumpTimer;
    public float swetHeight;
    public float swetWidth;

    public EntitySwet(World world) {
        super(world);
        this.field_70765_h = new SwetMoveHelper(this);
        this.func_70105_a(0.8f, 0.8f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new SwetAIConsume(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new SwetAIHunt(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new SwetAIFaceRandom(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new SwetAIHop(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAINearestAttackableTarget((EntityCreature)this, EntityPlayer.class, true));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(1.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(25.0);
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(25.0);
        this.func_70606_j(25.0f);
    }

    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        this.setType(this.field_70146_Z.nextInt(2));
        this.swetHeight = 1.0f;
        this.swetWidth = 1.0f;
        return super.func_180482_a(difficulty, livingdata);
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
        if (!this.hasPrey() && entityIn instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityIn;
            if (this.func_70638_az() != null && this.func_70638_az() == player && !player.func_184812_l_()) {
                this.capturePrey((EntityPlayer)entityIn);
            }
        }
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        if (!this.field_70170_p.field_72995_K && !this.hasPrey() && this.isPlayerFriendly(player)) {
            this.capturePrey(player);
        }
        return true;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_70638_az() instanceof EntityPlayer && (this.isPlayerFriendly((EntityPlayer)this.func_70638_az()) || this.isFriendly())) {
            this.func_70624_b(null);
        }
    }

    public void capturePrey(EntityPlayer entity) {
        this.func_184185_a(SoundsAether.swet_attack, 0.5f, (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f);
        this.field_70169_q = this.field_70165_t = entity.field_70165_t;
        this.field_70167_r = this.field_70163_u = entity.field_70163_u + 0.01;
        this.field_70166_s = this.field_70161_v = entity.field_70161_v;
        this.field_70126_B = this.field_70177_z = entity.field_70177_z;
        this.field_70127_C = this.field_70125_A = entity.field_70125_A;
        this.field_70159_w = entity.field_70159_w;
        this.field_70181_x = entity.field_70181_x;
        this.field_70179_y = entity.field_70179_y;
        this.func_70105_a(entity.field_70130_N, entity.field_70131_O);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        entity.func_184220_m((Entity)this);
        this.field_70177_z = this.field_70146_Z.nextFloat() * 360.0f;
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
            this.field_70128_L = true;
        }
        if (this.func_70072_I()) {
            this.dissolveSwet();
        }
        super.func_70071_h_();
        if (!this.hasPrey()) {
            for (int i = 0; i < 5; ++i) {
                double d = (float)this.field_70165_t + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                double d1 = (float)this.field_70163_u + this.field_70131_O;
                double d2 = (float)this.field_70161_v + (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.3f;
                this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, d, d1 - 0.25, d2, 0.0, 0.0, 0.0, new int[0]);
            }
        }
        if (this.field_70122_E && !this.wasOnGround) {
            this.func_184185_a(SoundsAether.swet_squish, this.func_70599_aP(), ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f + 1.0f) / 0.8f);
        }
        if (!this.field_70170_p.field_72995_K) {
            this.midJump = !this.field_70122_E;
            AetherNetworkingManager.sendToAll(new PacketSwetJump(this.func_145782_y(), !this.field_70122_E));
        }
        if (this.field_70170_p.field_72995_K) {
            this.jumpTimer = this.midJump ? ++this.jumpTimer : 0;
            if (this.field_70122_E) {
                this.swetHeight = this.swetHeight < 1.0f ? (this.swetHeight = this.swetHeight + 0.25f) : 1.0f;
                this.swetWidth = this.swetWidth > 1.0f ? (this.swetWidth = this.swetWidth - 0.25f) : 1.0f;
            } else {
                this.swetHeight = 1.425f;
                this.swetWidth = 0.875f;
                if (this.getJumpTimer() > 3) {
                    float scale = Math.min(this.getJumpTimer(), 10);
                    this.swetHeight -= 0.05f * scale;
                    this.swetWidth += 0.05f * scale;
                }
            }
        }
        this.wasOnGround = this.field_70122_E;
    }

    @Override
    public void func_191986_a(float strafe, float vertical, float forward) {
        if (this.hasPrey() && this.isFriendly()) {
            EntityPlayer rider = (EntityPlayer)this.func_184188_bt().get(0);
            IPlayerAether aetherRider = AetherAPI.getInstance().get(rider);
            if (aetherRider.isJumping() && this.field_70122_E) {
                this.func_70664_aZ();
                this.field_70122_E = false;
                this.field_70181_x = 1.0;
            }
        }
        super.func_191986_a(strafe, vertical, forward);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
        if (!this.isFriendly()) {
            super.func_180430_e(distance, damageMultiplier);
        }
    }

    protected void func_70664_aZ() {
        this.field_70181_x = 0.42f;
        this.field_70160_al = true;
    }

    public int getJumpTimer() {
        return this.jumpTimer;
    }

    public int getJumpDelay() {
        if (this.isFriendly()) {
            return 2;
        }
        return this.field_70146_Z.nextInt(20) + 10;
    }

    public int func_70646_bf() {
        return 0;
    }

    public void func_70653_a(Entity entityIn, float strength, double xRatio, double zRatio) {
        if (!this.hasPrey()) {
            super.func_70653_a(entityIn, strength, xRatio, zRatio);
        }
    }

    public boolean hasPrey() {
        return !this.func_184188_bt().isEmpty() && this.func_184188_bt().get(0) != null;
    }

    public boolean isPlayerFriendly(EntityPlayer player) {
        IPlayerAether iPlayerAether = AetherAPI.getInstance().get(player);
        return iPlayerAether.getAccessoryInventory().wearingAccessory(new ItemStack(ItemsAether.swet_cape));
    }

    public boolean isFriendly() {
        return this.hasPrey() && this.func_184188_bt().get(0) instanceof EntityPlayer && this.isPlayerFriendly((EntityPlayer)this.func_184188_bt().get(0));
    }

    public void dissolveSwet() {
        for (int i = 0; i < 50; ++i) {
            float f = this.field_70146_Z.nextFloat() * 3.141593f * 2.0f;
            float f1 = this.field_70146_Z.nextFloat() * 0.5f + 0.25f;
            float f2 = MathHelper.func_76126_a((float)f) * f1;
            float f3 = MathHelper.func_76134_b((float)f) * f1;
            this.field_70170_p.func_175688_a(EnumParticleTypes.WATER_SPLASH, this.field_70165_t + (double)f2, this.func_174813_aQ().field_72338_b + 1.25, this.field_70161_v + (double)f3, (double)f2 * 1.5 + this.field_70159_w, 4.0, (double)f3 * 1.5 + this.field_70179_y, new int[0]);
        }
        if (this.func_184615_bR() != null) {
            this.func_184185_a(this.func_184615_bR(), this.func_70599_aP(), this.func_70647_i());
        }
        this.func_70106_y();
    }

    public float func_70047_e() {
        return 0.625f * this.field_70131_O;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        if (this.getType() == EnumSwetType.Gold.getMeta()) {
            return AetherLootTables.swet_gold;
        }
        return AetherLootTables.swet_blue;
    }

    public EntityAgeable func_90011_a(EntityAgeable entityageable) {
        return null;
    }

    protected float func_70599_aP() {
        return 0.6f;
    }

    protected SoundEvent func_184601_bQ(DamageSource source) {
        return SoundsAether.swet_squish;
    }

    protected SoundEvent func_184615_bR() {
        return SoundsAether.swet_death;
    }

    public SoundCategory func_184176_by() {
        return SoundCategory.HOSTILE;
    }

    public int getType() {
        return this.swetType;
    }

    private void setType(int type) {
        this.swetType = type;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70146_Z.nextInt(AetherConfig.spawnrates.swet_spawnrate) == 0 && super.func_70601_bi();
    }

    public int func_70641_bl() {
        return 3;
    }

    public boolean func_70692_ba() {
        return this.isFriendly();
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.swetType);
    }

    public void readSpawnData(ByteBuf buffer) {
        this.swetType = buffer.readInt();
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74768_a("SwetType", this.getType());
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setType(compound.func_74762_e("SwetType"));
    }
}

