/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.entities.bosses.valkyrie_queen;

import com.gildedgames.the_aether.Aether;
import com.gildedgames.the_aether.api.AetherAPI;
import com.gildedgames.the_aether.api.player.IPlayerAether;
import com.gildedgames.the_aether.api.player.util.IAetherBoss;
import com.gildedgames.the_aether.blocks.BlocksAether;
import com.gildedgames.the_aether.blocks.dungeon.BlockDungeonBase;
import com.gildedgames.the_aether.blocks.util.EnumStoneType;
import com.gildedgames.the_aether.client.gui.dialogue.entity.GuiValkyrieDialogue;
import com.gildedgames.the_aether.entities.ai.EntityAIAttackContinuously;
import com.gildedgames.the_aether.entities.ai.valkyrie_queen.ValkyrieQueenAIWander;
import com.gildedgames.the_aether.entities.projectile.crystals.EntityThunderBall;
import com.gildedgames.the_aether.entities.util.AetherNameGen;
import com.gildedgames.the_aether.entities.util.EntityBossMob;
import com.gildedgames.the_aether.registry.AetherLootTables;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTrapDoor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityValkyrieQueen
extends EntityBossMob
implements IAetherBoss {
    public static final DataParameter<String> VALKYRIE_NAME = EntityDataManager.func_187226_a(EntityValkyrieQueen.class, (DataSerializer)DataSerializers.field_187194_d);
    public static final DataParameter<Boolean> VALKYRIE_READY = EntityDataManager.func_187226_a(EntityValkyrieQueen.class, (DataSerializer)DataSerializers.field_187198_h);
    private EntityAIAttackContinuously enhancedCombat = new EntityAIAttackContinuously(this, 0.65);
    public int angerLevel;
    public int timeUntilTeleport = this.field_70146_Z.nextInt(250);
    public int chatTime;
    public int timeUntilTeleportToPlayer;
    public BlockPos dungeonPos;
    public int dungeonX;
    public int dungeonY;
    public int dungeonZ;
    public int dungeonEntranceZ;
    public double safeX;
    public double safeY;
    public double safeZ;
    public float sinage;
    public double lastMotionY;
    private IBlockState dungeonStone = BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic));
    private IBlockState lightDungeonStone = BlocksAether.dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic));
    private IBlockState lockedDungeonStone = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Angelic));
    private IBlockState lockedLightDungeonStone = BlocksAether.locked_dungeon_block.func_176223_P().func_177226_a(BlockDungeonBase.dungeon_stone, (Comparable)((Object)EnumStoneType.Light_angelic));

    public EntityValkyrieQueen(World world) {
        super(world);
        this.func_70105_a(0.6f, 1.95f);
        this.setBossName(AetherNameGen.valkGen());
        this.setSpawnPosition(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    public EntityValkyrieQueen(World world, double x, double y, double z) {
        this(world);
        this.setSpawnPosition(x, y, z);
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.enhancedCombat = new EntityAIAttackContinuously(this, 0.65);
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)this.enhancedCombat);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new ValkyrieQueenAIWander(this, 0.5));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f, 200.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(28.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.5);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(13.5);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(500.0);
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VALKYRIE_READY, (Object)false);
        this.field_70180_af.func_187214_a(VALKYRIE_NAME, (Object)AetherNameGen.valkGen());
    }

    public void swingArm() {
        if (!this.field_82175_bq) {
            this.field_82175_bq = true;
        }
    }

    private void becomeAngryAt(EntityLivingBase entity) {
        this.func_70624_b(entity);
        this.angerLevel = 200 + this.field_70146_Z.nextInt(200);
    }

    public void setSpawnPosition(double i, double j, double k) {
        this.safeX = i;
        this.safeY = j;
        this.safeZ = k;
    }

    public void setDungeonPosition(int i, int j, int k) {
        this.dungeonPos = new BlockPos(i, j, k);
        this.dungeonX = i;
        this.dungeonY = j;
        this.dungeonZ = k;
    }

    private void unlockDoor() {
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ), Blocks.field_150350_a.func_176223_P());
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY, this.dungeonEntranceZ + 1), Blocks.field_150350_a.func_176223_P());
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ + 1), Blocks.field_150350_a.func_176223_P());
        this.field_70170_p.func_175656_a(new BlockPos(this.dungeonX - 1, this.dungeonY + 1, this.dungeonEntranceZ), Blocks.field_150350_a.func_176223_P());
    }

    private void unlockTreasure() {
        this.field_70170_p.func_180501_a(this.dungeonPos.func_177982_a(16, 1, 9), Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH), 2);
        this.field_70170_p.func_180501_a(this.dungeonPos.func_177982_a(17, 1, 9), Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.SOUTH), 2);
        this.field_70170_p.func_180501_a(this.dungeonPos.func_177982_a(16, 1, 10), Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 2);
        this.field_70170_p.func_180501_a(this.dungeonPos.func_177982_a(17, 1, 10), Blocks.field_150415_aT.func_176223_P().func_177226_a((IProperty)BlockTrapDoor.field_176284_a, (Comparable)EnumFacing.NORTH), 2);
        for (int x = -27; x < 30; ++x) {
            for (int y = -1; y < 22; ++y) {
                for (int z = -6; z < 26; ++z) {
                    BlockPos pos = this.dungeonPos.func_177982_a(x, y, z);
                    IBlockState block = this.field_70170_p.func_180495_p(pos);
                    if (block == this.lockedDungeonStone) {
                        this.field_70170_p.func_180501_a(pos, this.dungeonStone, 2);
                    }
                    if (block == this.dungeonStone) {
                        this.field_70170_p.func_180501_a(pos, this.dungeonStone, 2);
                    }
                    if (block != this.lockedLightDungeonStone) continue;
                    this.field_70170_p.func_180501_a(pos, this.lightDungeonStone, 2);
                }
            }
        }
    }

    private void chatItUp(EntityPlayer player, ITextComponent s) {
        Side side = FMLCommonHandler.instance().getEffectiveSide();
        if (this.chatTime <= 0) {
            if (side.isClient()) {
                Aether.proxy.sendMessage(player, s);
            }
            this.chatTime = 60;
        }
    }

    public void makeHomeShot(int shots, EntityPlayer player) {
        for (int i = 0; i < shots; ++i) {
            EntityThunderBall e1 = new EntityThunderBall(this.field_70170_p, this.field_70165_t - this.field_70159_w / 2.0, this.field_70163_u, this.field_70161_v - this.field_70179_y / 2.0, (EntityLivingBase)player);
            if (this.field_70170_p.field_72995_K) continue;
            this.field_70170_p.func_72838_d((Entity)e1);
        }
    }

    public boolean func_184645_a(EntityPlayer entityplayer, EnumHand hand) {
        this.func_70625_a((Entity)entityplayer, 180.0f, 180.0f);
        if (this.isBossReady()) {
            this.chatItUp(entityplayer, (ITextComponent)new TextComponentTranslation("gui.queen.ready", new Object[0]));
        } else if (this.field_70170_p.field_72995_K) {
            this.displayValkyrieDialogue();
            return true;
        }
        return super.func_184645_a(entityplayer, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void displayValkyrieDialogue() {
        if (this.field_70170_p.field_72995_K) {
            FMLClientHandler.instance().getClient().func_147108_a((GuiScreen)new GuiValkyrieDialogue(this));
        }
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (!this.isBossReady()) {
            this.field_70181_x *= 0.5;
            this.field_191988_bg = 0.0f;
            this.field_70702_br = 0.0f;
        } else {
            EntityPlayer target;
            if (this.func_70638_az() != null && this.func_70638_az() instanceof EntityPlayer && (target = (EntityPlayer)this.func_70638_az()) != null) {
                if (target.field_70163_u > this.field_70163_u) {
                    ++this.timeUntilTeleportToPlayer;
                    if (this.timeUntilTeleportToPlayer >= 75 && !this.field_70170_p.field_72995_K) {
                        this.teleportToPlayer();
                    }
                } else {
                    this.timeUntilTeleportToPlayer = 0;
                }
                if (this.timeUntilTeleport++ >= 450) {
                    if (this.field_70122_E && this.field_70146_Z.nextInt(5) == 0) {
                        this.makeHomeShot(1, target);
                    } else if (!this.field_70170_p.field_72995_K) {
                        this.teleport(this.safeX, this.safeY, this.safeZ, 4);
                    }
                } else if (this.timeUntilTeleport < 446 && (this.field_70163_u <= 0.0 || this.field_70163_u <= this.safeY - 16.0)) {
                    this.timeUntilTeleport = 446;
                } else if (this.timeUntilTeleport % 5 == 0 && !this.func_70685_l((Entity)target)) {
                    this.timeUntilTeleport += 100;
                }
            }
            if (!this.field_70170_p.field_72995_K) {
                for (int k = 2; k < 23; k += 7) {
                    BlockPos newPos = this.dungeonPos.func_177976_e().func_177970_e(k);
                    IBlockState state = this.field_70170_p.func_180495_p(newPos);
                    if (state.func_177230_c() == this.lockedDungeonStone.func_177230_c() && state.func_177230_c() == this.lockedLightDungeonStone.func_177230_c()) continue;
                    this.field_70170_p.func_180501_a(newPos, this.lockedDungeonStone, 2);
                    this.field_70170_p.func_180501_a(newPos.func_177968_d(), this.lockedDungeonStone, 2);
                    this.field_70170_p.func_180501_a(newPos.func_177984_a().func_177968_d(), this.lockedDungeonStone, 2);
                    this.field_70170_p.func_180501_a(newPos.func_177984_a(), this.lockedDungeonStone, 2);
                    this.dungeonEntranceZ = newPos.func_177952_p();
                }
            }
        }
        if (this.func_70638_az() != null && this.func_70638_az().field_70128_L) {
            this.func_70624_b(null);
            this.unlockDoor();
            this.angerLevel = 0;
        }
        if (this.chatTime > 0) {
            --this.chatTime;
        }
    }

    @Override
    public void func_70071_h_() {
        this.lastMotionY = this.field_70181_x;
        super.func_70071_h_();
        if (!this.field_70122_E && this.func_70638_az() != null && this.lastMotionY >= 0.0 && this.field_70181_x < 0.0 && this.func_70032_d((Entity)this.func_70638_az()) <= 16.0f && this.func_70685_l((Entity)this.func_70638_az())) {
            double a = this.func_70638_az().field_70165_t - this.field_70165_t;
            double b = this.func_70638_az().field_70161_v - this.field_70161_v;
            double angle = Math.atan2(a, b);
            this.field_70159_w = Math.sin(angle) * 0.25;
            this.field_70179_y = Math.cos(angle) * 0.25;
        }
        if (!this.field_70122_E && !this.func_70617_f_() && Math.abs(this.field_70181_x - this.lastMotionY) > 0.07 && Math.abs(this.field_70181_x - this.lastMotionY) < 0.09) {
            this.field_70181_x += (double)0.055f;
            if (this.field_70181_x < (double)-0.275f) {
                this.field_70181_x = -0.275f;
            }
        }
        if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL && (this.func_70638_az() != null || this.angerLevel > 0)) {
            this.angerLevel = 0;
            this.func_70624_b(null);
        }
        this.sinage = !this.field_70122_E ? (this.sinage += 0.75f) : (this.sinage += 0.15f);
        if (this.sinage > 6.283186f) {
            this.sinage -= 6.283186f;
        }
        if (this.func_110143_aJ() <= 0.0f || this.field_70128_L) {
            if (!this.field_70170_p.field_72995_K) {
                this.unlockDoor();
                this.unlockTreasure();
            }
            if (this.func_70638_az() instanceof EntityPlayer) {
                this.chatItUp((EntityPlayer)this.func_70638_az(), (ITextComponent)new TextComponentTranslation("gui.queen.defeated", new Object[0]));
                AetherAPI.getInstance().get((EntityPlayer)this.func_70638_az()).setFocusedBoss(null);
            }
            this.func_70656_aK();
            this.func_70106_y();
        }
    }

    public void func_70091_d(MoverType type, double x, double y, double z) {
        if (this.isBossReady()) {
            super.func_70091_d(type, x, y, z);
        } else {
            super.func_70091_d(type, 0.0, y, 0.0);
        }
    }

    public void func_70014_b(NBTTagCompound nbttagcompound) {
        super.func_70014_b(nbttagcompound);
        nbttagcompound.func_74777_a("Anger", (short)this.angerLevel);
        nbttagcompound.func_74757_a("Duel", this.isBossReady());
        nbttagcompound.func_74768_a("DungeonX", this.dungeonX);
        nbttagcompound.func_74768_a("DungeonY", this.dungeonY);
        nbttagcompound.func_74768_a("DungeonZ", this.dungeonZ);
        nbttagcompound.func_74768_a("DungeonEntranceZ", this.dungeonEntranceZ);
        nbttagcompound.func_74782_a("SafePos", (NBTBase)this.func_70087_a(new double[]{this.safeX, this.safeY, this.safeZ}));
        nbttagcompound.func_74778_a("BossName", this.getBossName());
    }

    public void func_70037_a(NBTTagCompound nbttagcompound) {
        super.func_70037_a(nbttagcompound);
        this.angerLevel = nbttagcompound.func_74765_d("Anger");
        this.setBossReady(nbttagcompound.func_74767_n("Duel"));
        this.dungeonX = nbttagcompound.func_74762_e("DungeonX");
        this.dungeonY = nbttagcompound.func_74762_e("DungeonY");
        this.dungeonZ = nbttagcompound.func_74762_e("DungeonZ");
        this.dungeonPos = new BlockPos(this.dungeonX, this.dungeonY, this.dungeonZ);
        this.dungeonEntranceZ = nbttagcompound.func_74762_e("DungeonEntranceZ");
        NBTTagList nbttaglist = nbttagcompound.func_150295_c("SafePos", 10);
        this.setBossName(nbttagcompound.func_74779_i("BossName"));
        this.safeX = nbttaglist.func_150309_d(0);
        this.safeY = nbttaglist.func_150309_d(1);
        this.safeZ = nbttaglist.func_150309_d(2);
    }

    @Override
    public boolean func_70097_a(DamageSource ds, float i) {
        if (ds.func_76364_f() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)ds.func_76364_f();
            if (this.field_70170_p.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.chatItUp(player, (ITextComponent)new TextComponentTranslation("gui.queen.peaceful", new Object[0]));
                this.func_70656_aK();
                return false;
            }
            if (!this.isBossReady()) {
                int chance = this.field_70146_Z.nextInt(2);
                if (chance == 2) {
                    this.chatItUp(player, (ITextComponent)new TextComponentTranslation("gui.queen.peaceful", new Object[0]));
                } else {
                    this.chatItUp(player, (ITextComponent)new TextComponentTranslation("gui.queen.nomedals", new Object[0]));
                }
                this.func_70656_aK();
                return false;
            }
            IPlayerAether playerAether = AetherAPI.getInstance().get(player);
            if (playerAether != null && !player.field_70128_L) {
                playerAether.setFocusedBoss(this);
            }
            if (this.func_70638_az() == null) {
                this.chatTime = 0;
                this.becomeAngryAt((EntityLivingBase)player);
                this.chatItUp(player, (ITextComponent)new TextComponentTranslation("gui.queen.fight", new Object[0]));
            } else {
                this.timeUntilTeleport += 60;
            }
        } else {
            this.func_70066_B();
            return false;
        }
        return super.func_70097_a(ds, i);
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        EntityPlayer player;
        boolean flag = entity.func_70097_a(DamageSource.func_76358_a((EntityLivingBase)this), 8.0f);
        this.swingArm();
        if (entity instanceof EntityPlayer && this.func_70638_az() != null && entity == this.func_70638_az() && ((player = (EntityPlayer)entity).func_110143_aJ() <= 0.0f || player.field_70128_L)) {
            this.func_70624_b(null);
            this.chatTime = 0;
            this.angerLevel = 0;
            this.chatItUp(player, (ITextComponent)new TextComponentTranslation("gui.queen.lost", new Object[0]));
            this.unlockDoor();
        }
        return flag;
    }

    public void func_70098_U() {
        super.func_70098_U();
        if (this.func_184187_bx() != null) {
            this.func_184210_p();
        }
    }

    protected void func_70628_a(boolean var1, int var2) {
    }

    public boolean func_184652_a(EntityPlayer player) {
        return false;
    }

    public EntityItem func_70099_a(ItemStack stack, float offsetY) {
        if (stack.func_190916_E() != 0 && stack.func_77973_b() != null) {
            EntityItem entityitem = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + (double)offsetY, this.field_70161_v, stack);
            entityitem.func_184224_h(true);
            entityitem.func_174869_p();
            if (this.captureDrops) {
                this.capturedDrops.add(entityitem);
            } else {
                this.field_70170_p.func_72838_d((Entity)entityitem);
            }
            return entityitem;
        }
        return null;
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    public void teleport(double x, double y, double z, int rad) {
        int a = this.field_70146_Z.nextInt(rad + 1);
        int b = this.field_70146_Z.nextInt(rad / 2);
        int c = rad - a;
        int newX = MathHelper.func_76128_c((double)((x += (double)(a *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5));
        int newY = MathHelper.func_76128_c((double)((y += (double)(b *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5));
        int newZ = MathHelper.func_76128_c((double)((z += (double)(c *= this.field_70146_Z.nextInt(2) * 2 - 1)) - 0.5));
        boolean flag = false;
        for (int q = 0; q < 32; ++q) {
            int k;
            int j;
            int i;
            if (flag || !this.isAirySpace(i = newX + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2)), j = newY + this.field_70146_Z.nextInt(rad / 2), k = newZ + (this.field_70146_Z.nextInt(rad / 2) - this.field_70146_Z.nextInt(rad / 2))) || !this.isAirySpace(i, j + 1, k) || this.isAirySpace(i, j - 1, k)) continue;
            newX = i;
            newY = j;
            newZ = k;
            flag = true;
        }
        if (!flag) {
            this.timeUntilTeleport -= this.field_70146_Z.nextInt(40) + 40;
            if (this.field_70163_u <= 0.0) {
                this.timeUntilTeleport = 446;
            }
        } else {
            this.func_70634_a((double)newX + 0.5, (double)newY + 0.5, (double)newZ + 0.5);
            this.func_70656_aK();
            this.enhancedCombat.func_75251_c();
            this.field_70703_bu = false;
            this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
            this.timeUntilTeleport = this.field_70146_Z.nextInt(40);
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70181_x = this.field_70179_y = (double)0.0f;
            this.field_70159_w = this.field_70179_y;
        }
    }

    public void teleportToPlayer() {
        if (this.func_70638_az() instanceof EntityPlayer) {
            this.func_70634_a(this.func_70638_az().field_70165_t + 0.5, this.func_70638_az().field_70163_u + 0.5, this.func_70638_az().field_70161_v + 0.5);
            this.func_70656_aK();
            this.enhancedCombat.func_75251_c();
            this.field_70703_bu = false;
            this.field_70761_aq = this.field_70146_Z.nextFloat() * 360.0f;
            this.timeUntilTeleportToPlayer = 0;
            this.field_70177_z = 0.0f;
            this.field_70125_A = 0.0f;
            this.field_70702_br = 0.0f;
            this.field_191988_bg = 0.0f;
            this.field_70181_x = this.field_70179_y = (double)0.0f;
            this.field_70159_w = this.field_70179_y;
        }
    }

    public boolean isAirySpace(int x, int y, int z) {
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = this.field_70170_p.func_180495_p(pos);
        return state.func_177230_c() == Blocks.field_150350_a || state.func_185890_d((IBlockAccess)this.field_70170_p, pos) == null;
    }

    public boolean func_70692_ba() {
        return false;
    }

    public boolean func_184222_aU() {
        return false;
    }

    @Override
    public boolean func_70601_bi() {
        return this.field_70170_p.func_72829_c(this.func_174813_aQ()) && this.field_70170_p.func_184144_a((Entity)this, this.func_174813_aQ()).size() == 0;
    }

    protected SoundEvent getHurtSound() {
        return SoundEvents.field_187543_bD;
    }

    @Override
    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187543_bD;
    }

    public String getBossName() {
        return (String)this.field_70180_af.func_187225_a(VALKYRIE_NAME);
    }

    public void setBossName(String name) {
        this.field_70180_af.func_187227_b(VALKYRIE_NAME, (Object)name);
    }

    @Override
    public String getBossTitle() {
        return this.getBossName() + ", " + new TextComponentTranslation("title.aether_legacy.valkyrie_queen.name", new Object[0]).func_150254_d();
    }

    public void setBossReady(boolean isReady) {
        this.field_70180_af.func_187227_b(VALKYRIE_READY, (Object)isReady);
    }

    public boolean isBossReady() {
        return (Boolean)this.field_70180_af.func_187225_a(VALKYRIE_READY);
    }

    public float func_70047_e() {
        return 1.75f;
    }

    @Override
    public float getBossHealth() {
        return this.func_110143_aJ();
    }

    @Override
    public float getMaxBossHealth() {
        return this.func_110138_aP();
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return AetherLootTables.valkyrie_queen;
    }
}

