/*
 * Decompiled with CFR 0.152.
 */
package com.gildedgames.the_aether.client.gui.dialogue.entity;

import com.gildedgames.the_aether.client.gui.dialogue.DialogueOption;
import com.gildedgames.the_aether.client.gui.dialogue.GuiDialogue;
import com.gildedgames.the_aether.entities.bosses.valkyrie_queen.EntityValkyrieQueen;
import com.gildedgames.the_aether.items.ItemsAether;
import com.gildedgames.the_aether.networking.AetherNetworkingManager;
import com.gildedgames.the_aether.networking.packets.PacketInitiateValkyrieFight;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.EnumDifficulty;

public class GuiValkyrieDialogue
extends GuiDialogue {
    private EntityValkyrieQueen valkyrieQueen;
    private String title = this.getDialogue();
    private boolean medalCountMet = false;
    public static final int MEDALS_NEEDED = 10;

    public GuiValkyrieDialogue(EntityValkyrieQueen valkyrieQueen) {
        super("[" + TextFormatting.YELLOW + valkyrieQueen.getBossName() + ", " + I18n.func_135052_a((String)"title.aether_legacy.valkyrie_queen.name", (Object[])new Object[0]) + TextFormatting.RESET + "]", new DialogueOption(I18n.func_135052_a((String)"gui.queen.dialog.0", (Object[])new Object[0])), new DialogueOption(I18n.func_135052_a((String)"gui.queen.dialog.1", (Object[])new Object[0])), new DialogueOption(I18n.func_135052_a((String)"gui.queen.dialog.2", (Object[])new Object[0])));
        this.valkyrieQueen = valkyrieQueen;
    }

    @Override
    public void dialogueClicked(DialogueOption dialogue) {
        if (this.getDialogueOptions().size() == 3) {
            if (dialogue.getDialogueId() == 0) {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.queen.answer.0", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            } else if (dialogue.getDialogueId() == 1) {
                DialogueOption medalDialogue = new DialogueOption(this.getMedalDiaulogue());
                this.addDialogueWithOptions(this.title + ": " + I18n.func_135052_a((String)"gui.queen.answer.1", (Object[])new Object[0]), medalDialogue, new DialogueOption(I18n.func_135052_a((String)"gui.valkyrie.dialog.player.denyfight", (Object[])new Object[0])));
            } else if (dialogue.getDialogueId() == 2) {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.queen.answer.2", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            }
        } else if (dialogue.getDialogueId() == 0) {
            if (this.field_146297_k.field_71441_e.func_175659_aa() == EnumDifficulty.PEACEFUL) {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.queen.peaceful", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
                return;
            }
            if (this.medalCountMet) {
                AetherNetworkingManager.sendToServer(new PacketInitiateValkyrieFight(this.valkyrieQueen.func_145782_y()));
                this.valkyrieQueen.setBossReady(true);
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.valkyrie.dialog.ready", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            } else {
                this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.valkyrie.dialog.nomedals", (Object[])new Object[0]));
                this.dialogueTreeCompleted();
            }
        } else if (dialogue.getDialogueId() == 1) {
            this.addDialogueMessage(this.title + ": " + I18n.func_135052_a((String)"gui.valkyrie.dialog.nofight", (Object[])new Object[0]));
            this.dialogueTreeCompleted();
        }
    }

    private String getMedalDiaulogue() {
        int medals = 0;
        for (int slotId = 0; slotId < this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.size(); ++slotId) {
            ItemStack stack = (ItemStack)this.field_146297_k.field_71439_g.field_71071_by.field_70462_a.get(slotId);
            if (stack.func_77973_b() != ItemsAether.victory_medal) continue;
            medals += stack.func_190916_E();
        }
        if (medals >= 10) {
            this.medalCountMet = true;
            return I18n.func_135052_a((String)"gui.valkyrie.dialog.player.havemedals", (Object[])new Object[0]);
        }
        return I18n.func_135052_a((String)"gui.valkyrie.dialog.player.lackmedals", (Object[])new Object[0]) + " (" + medals + "/" + 10 + ")";
    }
}

