/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.core.common.item;

import com.google.common.collect.Sets;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.IEntityMultiPart;
import net.minecraft.entity.MultiPartEntityPart;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Enchantments;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.SPacketEntityVelocity;
import net.minecraft.stats.StatList;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.WorldServer;
import shetiphian.core.common.MyDamageSource;

public abstract class ItemToolWithDamageSource
extends ItemTool {
    private MyDamageSource damageSource;

    public ItemToolWithDamageSource(float damage, float speed, Item.ToolMaterial material, MyDamageSource damageSource) {
        this(damage, speed, material, damageSource, Sets.newHashSet((Object[])new Block[0]));
    }

    public ItemToolWithDamageSource(float damage, float speed, Item.ToolMaterial material, MyDamageSource damageSource, Set<Block> blocks) {
        super(damage, speed, material, blocks);
        this.damageSource = damageSource;
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        if (this.func_194125_a(tab)) {
            this.getSubItems(list);
        }
    }

    public abstract void getSubItems(NonNullList<ItemStack> var1);

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity victim) {
        if (victim.func_70075_an() && !victim.func_85031_j((Entity)player)) {
            AttackValues values = ItemToolWithDamageSource.calculateBaseValues(player, victim, null);
            values.bonusDamage = this.getBonusDamage(player, victim, this.damageSource, values.damage, values.bonusDamage);
            values.knockback = this.getKnockback(player, victim, this.damageSource, values.knockback);
            if ((values.damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, this.damageSource, null, values)) {
                this.postHurtEntity(player, victim, this.damageSource);
            }
        }
        return true;
    }

    public static boolean onLeftClickEntity(EntityPlayer player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers) {
        AttackValues values;
        if (victim.func_70075_an() && !victim.func_85031_j((Entity)player) && ((values = ItemToolWithDamageSource.calculateBaseValues(player, victim, extraModifiers)).damage > 0.0f || values.bonusDamage > 0.0f) && ItemToolWithDamageSource.preformDamage(player, victim, damageSource, extraModifiers, values)) {
            player.func_71020_j(0.3f);
        }
        return true;
    }

    private static AttackValues calculateBaseValues(EntityPlayer player, Entity victim, ItemStack extraModifiers) {
        AttackValues values = new AttackValues();
        values.damage = (float)player.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        if (victim instanceof EntityLivingBase) {
            values.bonusDamage = EnchantmentHelper.func_152377_a((ItemStack)player.func_184614_ca(), (EnumCreatureAttribute)((EntityLivingBase)victim).func_70668_bt());
            values.knockback = EnchantmentHelper.func_77501_a((EntityLivingBase)player);
            if (extraModifiers != null) {
                AttackValues attackValues = values;
                attackValues.bonusDamage = attackValues.bonusDamage + EnchantmentHelper.func_152377_a((ItemStack)extraModifiers, (EnumCreatureAttribute)((EntityLivingBase)victim).func_70668_bt());
                attackValues = values;
                attackValues.knockback = attackValues.knockback + EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_180313_o, (ItemStack)extraModifiers);
            }
        }
        values.strength = player.func_184825_o(0.5f);
        values.damage = values.damage * (0.2f + values.strength * values.strength * 0.8f);
        values.bonusDamage = values.bonusDamage * values.strength;
        player.func_184821_cY();
        if (player.func_70051_ag()) {
            values.knockback++;
        }
        return values;
    }

    protected float getBonusDamage(EntityPlayer player, Entity victim, MyDamageSource source, float damage, float bonusDamage) {
        return bonusDamage;
    }

    protected int getKnockback(EntityPlayer player, Entity victim, MyDamageSource source, int knockback) {
        return knockback;
    }

    private static boolean preformDamage(EntityPlayer player, Entity victim, MyDamageSource damageSource, ItemStack extraModifiers, AttackValues values) {
        ItemStack itemstack;
        AttackValues attackValues;
        boolean isStrongAttack = values.strength > 0.9f;
        boolean flag1 = false;
        boolean flag3 = false;
        if (player.func_70051_ag() && isStrongAttack) {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187721_dT, player.func_184176_by(), 1.0f, 1.0f);
            flag1 = true;
        }
        boolean doBoostDamage = isStrongAttack && player.field_70143_R > 0.0f && !player.field_70122_E && !player.func_70617_f_() && !player.func_70090_H() && !player.func_70644_a(MobEffects.field_76440_q) && !player.func_184218_aH() && victim instanceof EntityLivingBase;
        boolean bl = doBoostDamage = doBoostDamage && !player.func_70051_ag();
        if (doBoostDamage) {
            attackValues = values;
            attackValues.damage = attackValues.damage * 1.5f;
        }
        attackValues = values;
        attackValues.damage = attackValues.damage + values.bonusDamage;
        double d0 = player.field_70140_Q - player.field_70141_P;
        if (isStrongAttack && !doBoostDamage && !flag1 && player.field_70122_E && d0 < (double)player.func_70689_ay() && !(itemstack = player.func_184586_b(EnumHand.MAIN_HAND)).func_190926_b() && itemstack.func_77973_b() instanceof ItemSword) {
            flag3 = true;
        }
        float victimHealthPreAttack = 0.0f;
        boolean victimOnFire = false;
        int fireDamage = EnchantmentHelper.func_90036_a((EntityLivingBase)player);
        if (extraModifiers != null) {
            fireDamage += EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_77334_n, (ItemStack)extraModifiers);
        }
        if (victim instanceof EntityLivingBase) {
            victimHealthPreAttack = ((EntityLivingBase)victim).func_110143_aJ();
            if (fireDamage > 0 && !victim.func_70027_ad()) {
                victimOnFire = true;
                victim.func_70015_d(1);
            }
        }
        double d1 = victim.field_70159_w;
        double d2 = victim.field_70181_x;
        double d3 = victim.field_70179_y;
        boolean victimWasHurt = damageSource != null ? victim.func_70097_a(damageSource.causeEntityDamage((Entity)player), values.damage) : victim.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), values.damage);
        if (victimWasHurt) {
            IEntityMultiPart ientitymultipart;
            if (values.knockback > 0) {
                if (victim instanceof EntityLivingBase) {
                    ((EntityLivingBase)victim).func_70653_a((Entity)player, (float)values.knockback * 0.5f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                } else {
                    victim.func_70024_g((double)(-MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)values.knockback * 0.5f), 0.1, (double)(MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180))) * (float)values.knockback * 0.5f));
                }
                player.field_70159_w *= 0.6;
                player.field_70179_y *= 0.6;
                player.func_70031_b(false);
            }
            if (flag3) {
                for (EntityLivingBase entitylivingbase : player.func_130014_f_().func_72872_a(EntityLivingBase.class, victim.func_174813_aQ().func_72321_a(1.0, 0.25, 1.0))) {
                    if (entitylivingbase == player || entitylivingbase == victim || player.func_184191_r((Entity)entitylivingbase) || !(player.func_70068_e((Entity)entitylivingbase) < 9.0)) continue;
                    entitylivingbase.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                    entitylivingbase.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), 1.0f);
                }
                player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
                player.func_184810_cG();
            }
            if (victim instanceof EntityPlayerMP && victim.field_70133_I) {
                ((EntityPlayerMP)victim).field_71135_a.func_147359_a((Packet)new SPacketEntityVelocity(victim));
                victim.field_70133_I = false;
                victim.field_70159_w = d1;
                victim.field_70181_x = d2;
                victim.field_70179_y = d3;
            }
            if (doBoostDamage) {
                player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187718_dS, player.func_184176_by(), 1.0f, 1.0f);
                player.func_71009_b(victim);
            }
            if (!doBoostDamage && !flag3) {
                if (isStrongAttack) {
                    player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187727_dV, player.func_184176_by(), 1.0f, 1.0f);
                } else {
                    player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187733_dX, player.func_184176_by(), 1.0f, 1.0f);
                }
            }
            if (values.bonusDamage > 0.0f) {
                player.func_71047_c(victim);
            }
            if (!player.func_130014_f_().field_72995_K && victim instanceof EntityPlayer) {
                ItemStack itemStack3;
                EntityPlayer entityplayer = (EntityPlayer)victim;
                ItemStack itemStack2 = player.func_184614_ca();
                ItemStack itemStack = itemStack3 = entityplayer.func_184587_cr() ? entityplayer.func_184607_cu() : ItemStack.field_190927_a;
                if (!itemStack2.func_190926_b() && !itemStack3.func_190926_b() && itemStack2.func_77973_b() instanceof ItemAxe && itemStack3.func_77973_b() == Items.field_185159_cQ) {
                    float f3 = 0.25f + (float)EnchantmentHelper.func_185293_e((EntityLivingBase)player) * 0.05f;
                    if (flag1) {
                        f3 += 0.75f;
                    }
                    if (player.func_130014_f_().field_73012_v.nextFloat() < f3) {
                        entityplayer.func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                        player.func_130014_f_().func_72960_a((Entity)entityplayer, (byte)30);
                    }
                }
            }
            if (values.damage >= 0.0f) {
                player.func_71047_c(victim);
            }
            player.func_130011_c(victim);
            if (victim instanceof EntityLivingBase) {
                EnchantmentHelper.func_151384_a((EntityLivingBase)((EntityLivingBase)victim), (Entity)player);
            }
            EnchantmentHelper.func_151385_b((EntityLivingBase)player, (Entity)victim);
            ItemStack equippedItem = player.func_184614_ca();
            Entity entity = victim;
            if (victim instanceof MultiPartEntityPart && (ientitymultipart = ((MultiPartEntityPart)victim).field_70259_a) instanceof EntityLivingBase) {
                entity = (EntityLivingBase)ientitymultipart;
            }
            if (!equippedItem.func_190926_b() && entity instanceof EntityLivingBase) {
                equippedItem.func_77961_a((EntityLivingBase)entity, player);
                if (equippedItem.func_190916_E() <= 0) {
                    player.func_184611_a(EnumHand.MAIN_HAND, ItemStack.field_190927_a);
                }
            }
            if (victim instanceof EntityLivingBase) {
                float victimHealthPostAttack = victimHealthPreAttack - ((EntityLivingBase)victim).func_110143_aJ();
                player.func_71064_a(StatList.field_188111_y, Math.round(victimHealthPostAttack * 10.0f));
                if (fireDamage > 0) {
                    victim.func_70015_d(fireDamage * 4);
                }
                if (player.func_130014_f_() instanceof WorldServer && victimHealthPostAttack > 2.0f) {
                    int k = (int)((double)victimHealthPostAttack * 0.5);
                    ((WorldServer)player.func_130014_f_()).func_175739_a(EnumParticleTypes.DAMAGE_INDICATOR, victim.field_70165_t, victim.field_70163_u + (double)(victim.field_70131_O * 0.5f), victim.field_70161_v, k, 0.1, 0.0, 0.1, 0.2, new int[0]);
                }
            }
            player.func_71020_j(0.3f);
        } else {
            player.func_130014_f_().func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187724_dU, player.func_184176_by(), 1.0f, 1.0f);
            if (victimOnFire) {
                victim.func_70066_B();
            }
        }
        return victimWasHurt;
    }

    protected void postHurtEntity(EntityPlayer player, Entity victim, MyDamageSource source) {
        player.func_71020_j(0.3f);
    }

    private static class AttackValues {
        private float damage;
        private int knockback;
        private float bonusDamage;
        private float strength;

        private AttackValues() {
        }
    }
}

