/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.waypoint.render.world;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.util.vector.Vector4f;
import xaero.common.HudMod;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiMisc;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointUtil;
import xaero.common.minimap.waypoints.render.WaypointsIngameRenderer;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.element.render.MinimapElementReader;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.element.render.MinimapElementRenderer;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.WaypointPurpose;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderContext;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderProvider;
import xaero.hud.minimap.waypoint.render.world.WaypointWorldRenderReader;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;
import xaero.hud.render.TextureLocations;

public abstract class WaypointWorldRenderer
extends MinimapElementRenderer<Waypoint, WaypointWorldRenderContext> {
    private Vec3d lookVector;
    private boolean temporaryWaypointsGlobal;
    private double waypointsDistance;
    private double waypointsDistanceMin;
    private int distanceSetting;
    private boolean displayShortDistances;
    private boolean dimensionScaleDistance;
    private double clampDepth;
    private int lookingAtAngle;
    private int lookingAtAngleVertical;
    private boolean keepWaypointNames;
    private int autoConvertWaypointDistanceToKmThreshold;
    private int waypointDistancePrecision;
    private float iconScale;
    private int distanceTextScale;
    private int nameScale;
    protected int opacity;
    private float cameraAngleYaw;
    private float cameraAnglePitch;
    private String subWorldName;
    private MinimapRendererHelper helper;
    private FontRenderer fontRenderer;

    protected WaypointWorldRenderer(MinimapElementReader<Waypoint, WaypointWorldRenderContext> elementReader, WaypointWorldRenderProvider provider, WaypointWorldRenderContext context) {
        super(elementReader, provider, context);
    }

    @Override
    public boolean renderElement(Waypoint w, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo) {
        double zFromEntity;
        double distanceFromEntity;
        double waypointPosDivider = renderInfo.backgroundCoordinateScale / ((WaypointWorldRenderContext)this.context).dimCoordinateScale;
        double wX = (double)w.getX(waypointPosDivider) + 0.5;
        double wZ = (double)w.getZ(waypointPosDivider) + 0.5;
        double offX = wX - renderInfo.renderPos.field_72450_a;
        double offY = (double)w.getY() + 1.0 - renderInfo.renderPos.field_72448_b;
        if (!w.isYIncluded()) {
            offY = renderInfo.renderEntityPos.field_72448_b + 1.0 - renderInfo.renderPos.field_72448_b;
        }
        double offZ = wZ - renderInfo.renderPos.field_72449_c;
        double distance2D = Math.sqrt(offX * offX + offZ * offZ);
        if (this.waypointsDistanceMin != 0.0 && distance2D < this.waypointsDistanceMin) {
            return false;
        }
        double distanceScale = this.dimensionScaleDistance ? renderInfo.backgroundCoordinateScale : 1.0;
        double scaledDistance2D = distance2D * distanceScale;
        if (!(w.isDestination() || w.getPurpose() == WaypointPurpose.DEATH || w.isGlobal() || w.isTemporary() && this.temporaryWaypointsGlobal || this.waypointsDistance == 0.0 || !(scaledDistance2D > this.waypointsDistance))) {
            return false;
        }
        Vec3d lookVector = this.lookVector;
        double depth = offX * lookVector.field_72450_a + offY * lookVector.field_72448_b + offZ * lookVector.field_72449_c;
        double xFromEntity = wX - renderInfo.renderEntityPos.field_72450_a;
        double yFromEntity = (double)w.getY() - renderInfo.renderEntityPos.field_72448_b;
        if (!w.isYIncluded()) {
            yFromEntity = 0.0;
        }
        boolean usingNearbyDisplay = (distanceFromEntity = Math.sqrt(xFromEntity * xFromEntity + yFromEntity * yFromEntity + (zFromEntity = wZ - renderInfo.renderEntityPos.field_72449_c) * zFromEntity)) <= 20.0 && !this.displayShortDistances;
        boolean displayingDistance = !usingNearbyDisplay && highlighted;
        String distanceText = displayingDistance ? this.getDistanceText(distanceFromEntity) : null;
        String name = null;
        if (usingNearbyDisplay || displayingDistance && this.keepWaypointNames || !displayingDistance && w.getPurpose() == WaypointPurpose.DEATH) {
            name = w.getLocalizedName();
        }
        FontRenderer fontRenderer = this.fontRenderer;
        float iconScale = this.iconScale;
        int nameScale = this.nameScale;
        int halfIconPixel = (int)iconScale / 2;
        if (renderInfo.location == MinimapElementRenderLocation.IN_WORLD && depth < this.clampDepth) {
            float scale = (float)(this.clampDepth / depth);
            GlStateManager.func_179152_a((float)scale, (float)scale, (float)1.0f);
        }
        GlStateManager.func_179137_b((double)halfIconPixel, (double)0.0, (double)optionalDepth);
        this.renderIconWithLabels(w, highlighted, name, distanceText, this.subWorldName, iconScale, nameScale, this.distanceTextScale, fontRenderer, halfIconPixel);
        return true;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo) {
        Minecraft mc = Minecraft.func_71410_x();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager manager = session.getWorldManager();
        MinimapWorld currentWorld = manager.getCurrentWorld();
        ModSettings settings = HudMod.INSTANCE.getSettings();
        this.lookVector = Misc.getLookVec();
        this.cameraAngleYaw = (float)Math.toDegrees(Misc.getYawRadians());
        this.cameraAnglePitch = (float)Math.toDegrees(Misc.getPitchRadians());
        double fov = Minecraft.func_71410_x().field_71474_y.field_74334_X;
        int screenWidth = mc.field_71443_c;
        int screenHeight = mc.field_71440_d;
        this.subWorldName = null;
        if (currentWorld != null && manager.getAutoWorld() != currentWorld) {
            this.subWorldName = "(" + currentWorld.getContainer().getSubName() + ")";
        }
        ((WaypointWorldRenderContext)this.context).dimCoordinateScale = session.getDimensionHelper().getDimCoordinateScale(manager.getCurrentWorld());
        ((WaypointWorldRenderContext)this.context).renderEntityPos = renderInfo.renderEntityPos;
        int displayMultipleWaypointInfo = settings.displayMultipleWaypointInfo;
        ((WaypointWorldRenderContext)this.context).onlyMainInfo = displayMultipleWaypointInfo == 0 || displayMultipleWaypointInfo == 1 && !renderInfo.renderEntity.func_70093_af();
        this.temporaryWaypointsGlobal = settings.temporaryWaypointsGlobal;
        this.waypointsDistance = settings.getMaxWaypointsDistance();
        this.waypointsDistanceMin = settings.waypointsDistanceMin;
        this.distanceSetting = settings.distance;
        this.displayShortDistances = settings.alwaysShowDistance;
        this.dimensionScaleDistance = settings.dimensionScaledMaxWaypointDistance;
        this.clampDepth = settings.getWaypointsClampDepth(fov, screenHeight, renderInfo.scaledResolution.func_78325_e());
        this.lookingAtAngle = MathHelper.func_76125_a((int)settings.lookingAtAngle, (int)0, (int)180);
        this.lookingAtAngleVertical = MathHelper.func_76125_a((int)settings.lookingAtAngleVertical, (int)0, (int)180);
        this.keepWaypointNames = settings.keepWaypointNames;
        this.autoConvertWaypointDistanceToKmThreshold = settings.autoConvertWaypointDistanceToKmThreshold;
        this.waypointDistancePrecision = settings.waypointDistancePrecision;
        this.iconScale = settings.getWaypointsIngameIconScale(renderInfo.scaledResolution.func_78325_e());
        this.distanceTextScale = (int)Math.ceil(settings.getWaypointsIngameDistanceScale(renderInfo.scaledResolution.func_78325_e()));
        this.nameScale = settings.getWaypointsIngameNameScale(renderInfo.scaledResolution.func_78325_e());
        this.opacity = settings.waypointOpacityIngame;
        ((WaypointWorldRenderContext)this.context).interactionBoxTop = this.distanceSetting == 0 || this.lookingAtAngleVertical == 0 ? 0 : (this.distanceSetting == 2 || this.lookingAtAngleVertical >= 90 ? -screenHeight : -OptimizedMath.myFloor((double)(screenHeight / 2) * Math.tan(Math.toRadians(this.lookingAtAngleVertical)) / Math.tan(Math.toRadians(fov / 2.0))));
        double horizontalTan = Math.tan(Math.toRadians(fov / 2.0)) * (double)screenWidth / (double)screenHeight;
        int n = this.distanceSetting == 0 || this.lookingAtAngle == 0 ? 0 : (((WaypointWorldRenderContext)this.context).interactionBoxLeft = this.distanceSetting == 2 || this.lookingAtAngle >= 90 ? -screenWidth : -OptimizedMath.myFloor((double)(screenWidth / 2) * Math.tan(Math.toRadians(this.lookingAtAngle)) / horizontalTan));
        if (Minecraft.func_71410_x().func_152349_b()) {
            this.iconScale = (float)(Math.ceil(this.iconScale / 2.0f) * 2.0);
            this.distanceTextScale = (this.distanceTextScale + 1) / 2 * 2;
            this.nameScale = (this.nameScale + 1) / 2 * 2;
        }
        this.helper = HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().getHelper();
        this.fontRenderer = mc.field_71466_p;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179090_x();
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo) {
        ((WaypointWorldRenderContext)this.context).onlyMainInfo = false;
        ((WaypointWorldRenderContext)this.context).renderEntityPos = null;
        this.fontRenderer = null;
        GlStateManager.func_179098_w();
    }

    protected void renderIconWithLabels(Waypoint w, boolean highlit, String name, String distanceText, String subWorldName, float iconScale, int nameScale, int distanceTextScale, FontRenderer fontRenderer, int halfIconPixel) {
        GlStateManager.func_179152_a((float)iconScale, (float)iconScale, (float)1.0f);
        this.renderIcon(w, highlit, fontRenderer);
        GlStateManager.func_179152_a((float)(1.0f / iconScale), (float)(1.0f / iconScale), (float)1.0f);
        GlStateManager.func_179109_b((float)(-halfIconPixel), (float)0.0f, (float)0.0f);
        GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        float labelAlpha = 0.3529412f;
        if ((distanceText != null || name != null) && subWorldName != null) {
            this.renderWaypointLabel(subWorldName, this.helper, fontRenderer, nameScale, labelAlpha);
            GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        }
        if (name != null) {
            this.renderWaypointLabel(name, this.helper, fontRenderer, nameScale, labelAlpha);
        }
        GlStateManager.func_179109_b((float)0.0f, (float)2.0f, (float)0.0f);
        if (distanceText != null) {
            this.renderWaypointLabel(distanceText, this.helper, fontRenderer, distanceTextScale, labelAlpha);
        }
    }

    protected void renderIcon(Waypoint w, boolean highlit, FontRenderer fontRenderer) {
        int color = w.getWaypointColor().getHex();
        float red = (float)(color >> 16 & 0xFF) / 255.0f;
        float green = (float)(color >> 8 & 0xFF) / 255.0f;
        float blue = (float)(color & 0xFF) / 255.0f;
        float alpha = 0.52274513f * (float)this.opacity / 100.0f;
        if (highlit && ((WaypointWorldRenderContext)this.context).onlyMainInfo) {
            alpha = Math.min(1.0f, alpha * 1.5f);
        }
        int initialsWidth = w.getPurpose() == WaypointPurpose.DEATH ? 7 : fontRenderer.func_78256_a(w.getInitials());
        int addedFrame = WaypointUtil.getAddedMinimapIconFrame(initialsWidth);
        this.renderColorBackground(addedFrame, red, green, blue, alpha);
        if (w.getPurpose() == WaypointPurpose.DEATH) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
            this.renderTexturedIcon(addedFrame, 0, 78, 0.9882f, 0.9882f, 0.9882f, 1.0f);
            return;
        }
        GlStateManager.func_179098_w();
        fontRenderer.func_175065_a(w.getInitials(), (float)(-initialsWidth / 2), -8.0f, -1, false);
        GlStateManager.func_179090_x();
    }

    private void renderColorBackground(int addedFrame, float r, float g, float b, float a) {
        a = Misc.adjustOpacityForGamma(a);
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        bufferBuilder.func_181662_b((double)(-5 - addedFrame), -9.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)(-5 - addedFrame), 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)(4 + addedFrame), 0.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)(4 + addedFrame), -9.0, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        GlStateManager.func_179118_c();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179141_d();
    }

    private void renderTexturedIcon(int addedFrame, int textureX, int textureY, float r, float g, float b, float a) {
        a = Misc.adjustOpacityForGamma(a);
        GlStateManager.func_179098_w();
        float f = 0.00390625f;
        float f1 = 0.00390625f;
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181709_i);
        bufferBuilder.func_181662_b((double)(-5 - addedFrame), (double)(-9 - addedFrame), 0.0).func_187315_a((double)((float)textureX * f), (double)((float)textureY * f1)).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)(-5 - addedFrame), (double)addedFrame, 0.0).func_187315_a((double)((float)textureX * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)(4 + addedFrame), (double)addedFrame, 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)(textureY + 9 + addedFrame * 2) * f1)).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)(4 + addedFrame), (double)(-9 - addedFrame), 0.0).func_187315_a((double)((float)(textureX + 9 + addedFrame * 2) * f), (double)((float)textureY * f1)).func_181666_a(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
        GlStateManager.func_179090_x();
    }

    private void renderColoredRect(int x1, int y1, int w, int h, float r, float g, float b, float a) {
        a = Misc.adjustOpacityForGamma(a);
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        int x2 = x1 + w;
        int y2 = y1 + h;
        bufferBuilder.func_181662_b((double)x1, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)x1, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)x2, (double)y2, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        bufferBuilder.func_181662_b((double)x2, (double)y1, 0.0).func_181666_a(r, g, b, a).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    protected void renderWaypointLabel(String label, MinimapRendererHelper helper, FontRenderer fontRenderer, int labelScale, float bgAlpha) {
        int nameWidth = fontRenderer.func_78256_a(label);
        int backgroundWidth = nameWidth + 3;
        int halfBackgroundWidth = backgroundWidth / 2;
        int halfPixel = 0;
        if ((backgroundWidth & 1) != 0) {
            halfPixel = labelScale - labelScale / 2;
            GlStateManager.func_179109_b((float)(-halfPixel), (float)0.0f, (float)0.0f);
        }
        GlStateManager.func_179152_a((float)labelScale, (float)labelScale, (float)1.0f);
        this.renderColoredRect(-halfBackgroundWidth, 0, backgroundWidth, 9, 0.0f, 0.0f, 0.0f, bgAlpha);
        GlStateManager.func_179098_w();
        fontRenderer.func_175065_a(label, (float)(-halfBackgroundWidth + 2), 1.0f, -1, false);
        GlStateManager.func_179090_x();
        GlStateManager.func_179109_b((float)0.0f, (float)9.0f, (float)0.0f);
        GlStateManager.func_179152_a((float)(1.0f / (float)labelScale), (float)(1.0f / (float)labelScale), (float)1.0f);
        if ((backgroundWidth & 1) != 0) {
            GlStateManager.func_179109_b((float)halfPixel, (float)0.0f, (float)0.0f);
        }
    }

    private String getDistanceText(double distanceFromEntity) {
        if (this.autoConvertWaypointDistanceToKmThreshold != -1 && distanceFromEntity >= (double)this.autoConvertWaypointDistanceToKmThreshold) {
            return GuiMisc.getFormat(this.waypointDistancePrecision).format(distanceFromEntity / 1000.0) + "km";
        }
        return GuiMisc.getFormat(this.waypointDistancePrecision).format(distanceFromEntity) + "m";
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        if (!HudMod.INSTANCE.getSettings().getShowIngameWaypoints()) {
            return false;
        }
        Minecraft mc = Minecraft.func_71410_x();
        return mc.field_71439_g != null && !Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_WAYPOINTS) && !Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_WAYPOINTS_HARMFUL);
    }

    @Override
    public int getOrder() {
        return 100;
    }

    public static final class Builder {
        private Builder() {
        }

        private Builder setDefault() {
            return this;
        }

        public WaypointWorldRenderer build() {
            WaypointWorldRenderContext context = new WaypointWorldRenderContext();
            return new WaypointsIngameRenderer(new WaypointWorldRenderReader(context), new WaypointWorldRenderProvider(), context, new Vector4f(0.0f, 0.0f, 0.0f, 1.0f));
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

