/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.minimap.radar.render.element;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.shader.Framebuffer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import org.lwjgl.opengl.GL11;
import xaero.common.HudMod;
import xaero.common.icon.XaeroIcon;
import xaero.common.minimap.element.render.MinimapElementRenderer;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.settings.ModSettings;
import xaero.hud.entity.EntityUtils;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.Minimap;
import xaero.hud.minimap.element.render.MinimapElementRenderInfo;
import xaero.hud.minimap.element.render.MinimapElementRenderLocation;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.radar.RadarSession;
import xaero.hud.minimap.radar.category.EntityRadarCategory;
import xaero.hud.minimap.radar.category.EntityRadarCategoryManager;
import xaero.hud.minimap.radar.category.setting.EntityRadarCategorySettings;
import xaero.hud.minimap.radar.color.RadarColor;
import xaero.hud.minimap.radar.icon.RadarIconManager;
import xaero.hud.minimap.radar.render.element.RadarElementReader;
import xaero.hud.minimap.radar.render.element.RadarRenderContext;
import xaero.hud.minimap.radar.render.element.RadarRenderProvider;
import xaero.hud.minimap.radar.util.RadarUtils;
import xaero.hud.render.TextureLocations;

public abstract class RadarRenderer
extends MinimapElementRenderer<Entity, RadarRenderContext> {
    private final RadarIconManager radarIconManager;
    private final Minimap minimap;
    private RadarSession radarSession;
    private EntityRadarCategoryManager categoryManager;
    private EntityRadarCategory previousCategory;
    private double maxDistanceSquared;
    private double labelScale;
    private boolean smoothDots;
    private boolean debugEntityIcons;
    private boolean debugEntityVariantIds;
    private int dotsStyle;
    private int heightLimit;
    private boolean heightBasedFade;
    private int startFadingAt;
    private boolean displayNameWhenIconFails;
    private boolean alwaysNameTags;
    private RadarColor radarColor;
    private RadarColor fallbackColor;
    private int displayY;
    private int nameSettingForCategory;
    private boolean namesForCategory;
    private boolean name;
    private boolean iconsAllowed;
    private boolean labelsAllowed;
    private MinimapRendererHelper helper;
    private final RadarRenderProvider radarRenderProvider;

    protected RadarRenderer(RadarIconManager radarIconManager, Minimap minimap, RadarElementReader elementReader, RadarRenderProvider provider, RadarRenderContext context) {
        super(elementReader, provider, context);
        this.radarIconManager = radarIconManager;
        this.minimap = minimap;
        this.radarRenderProvider = provider;
    }

    @Override
    public void preRender(MinimapElementRenderInfo renderInfo) {
        this.radarIconManager.allowPrerender();
        ModSettings settings = HudMod.INSTANCE.getSettings();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        if (settings.getSmoothDots()) {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
        } else {
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        this.iconsAllowed = true;
        this.labelsAllowed = true;
        ((RadarRenderContext)this.context).reversedOrder = ModSettings.keyReverseEntityRadar.func_151470_d();
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        this.radarSession = session.getRadarSession();
        this.categoryManager = this.radarSession.getCategoryManager();
        this.previousCategory = null;
        this.labelScale = settings.getDotNameScale();
        this.smoothDots = settings.getSmoothDots();
        this.debugEntityIcons = settings.debugEntityIcons;
        this.debugEntityVariantIds = settings.debugEntityVariantIds;
        this.dotsStyle = settings.getDotsStyle();
        this.helper = HudMod.INSTANCE.getMinimap().getMinimapFBORenderer().getHelper();
        double playerDimDiv = renderInfo.backgroundCoordinateScale / renderInfo.renderEntityDimensionScale;
        this.maxDistanceSquared = RadarUtils.getMaxDistance(session.getProcessor(), settings.minimapShape == 1, renderInfo.scaledResolution.func_78325_e()) * playerDimDiv * playerDimDiv;
    }

    @Override
    public boolean renderElement(Entity e, boolean highlighted, boolean outOfBounds, double optionalDepth, float optionalScale, double partialX, double partialY, MinimapElementRenderInfo renderInfo) {
        double figureScale;
        if (renderInfo.location == MinimapElementRenderLocation.IN_MINIMAP) {
            double offX = e.field_70165_t - renderInfo.renderEntityPos.field_72450_a;
            if (offX * offX > this.maxDistanceSquared) {
                return false;
            }
            double offY = e.field_70161_v - renderInfo.renderEntityPos.field_72449_c;
            if (offY * offY > this.maxDistanceSquared) {
                return false;
            }
        }
        if (((RadarRenderContext)this.context).entityCategory == null) {
            EntityRadarCategory rootCategory = this.categoryManager.getRootCategory();
            ((RadarRenderContext)this.context).entityCategory = this.categoryManager.getRuleResolver().resolve(rootCategory, e, renderInfo.player);
            if (((RadarRenderContext)this.context).entityCategory == null) {
                return false;
            }
        }
        if (((RadarRenderContext)this.context).entityCategory != this.previousCategory) {
            this.setupRenderForCategory(((RadarRenderContext)this.context).entityCategory);
            this.previousCategory = ((RadarRenderContext)this.context).entityCategory;
        }
        this.setupRenderForEntity(e);
        if (e instanceof EntityPlayer) {
            this.confirmTrackedPlayerRadarRender((EntityPlayer)e);
        }
        MinimapElementRenderLocation location = renderInfo.location;
        Entity renderEntity = renderInfo.renderEntity;
        boolean cave = renderInfo.cave;
        float optionalScaleAdjust = renderInfo.location == MinimapElementRenderLocation.OVER_MINIMAP ? 0.5f : 1.0f;
        optionalScale *= optionalScaleAdjust;
        GlStateManager.func_179094_E();
        boolean icon = this.iconsAllowed && ((RadarRenderContext)this.context).icon;
        boolean name = this.name;
        if (highlighted && this.nameSettingForCategory > 0) {
            name = true;
        }
        XaeroIcon entityIcon = null;
        if (icon) {
            entityIcon = this.radarIconManager.get(e, (float)((RadarRenderContext)this.context).iconScale, this.debugEntityIcons, this.debugEntityVariantIds, renderInfo.framebuffer, renderInfo.scaledResolution);
        }
        if (entityIcon == RadarIconManager.DOT) {
            entityIcon = null;
            icon = false;
        }
        boolean usableIcon = entityIcon != null && entityIcon != RadarIconManager.FAILED;
        float offY = (float)(renderEntity.field_70163_u - e.field_70163_u);
        int labelOffsetX = 0;
        int labelOffsetY = 0;
        GlStateManager.func_179137_b((double)partialX, (double)partialY, (double)0.0);
        if (usableIcon) {
            figureScale = ((RadarRenderContext)this.context).iconScale;
            this.renderIcon(entityIcon, optionalScale, figureScale, offY, cave);
        } else {
            boolean smooth = this.smoothDots;
            if (!smooth) {
                optionalScale = (float)Math.ceil(optionalScale);
            }
            double dotActualScale = optionalScale;
            figureScale = ((RadarRenderContext)this.context).dotScale;
            if (this.dotsStyle == 1) {
                if (!smooth) {
                    figureScale = (int)figureScale;
                }
                dotActualScale *= figureScale;
            }
            float dotOffset = this.renderDot(e, renderInfo.player, smooth, optionalScale, figureScale, offY, cave);
            if (!smooth) {
                double dotRadius = (double)(-dotOffset) * dotActualScale;
                double dotRadiusPartial = dotRadius - (double)((int)dotRadius);
                labelOffsetX = partialX - dotRadiusPartial <= -0.5 ? -1 : 0;
                int n = labelOffsetY = partialY - dotRadiusPartial < -0.5 ? -1 : 0;
            }
            if (icon && this.displayNameWhenIconFails && entityIcon == RadarIconManager.FAILED) {
                name = true;
            }
        }
        GlStateManager.func_179121_F();
        if (!this.labelsAllowed) {
            return true;
        }
        if (!name && this.displayY <= 0) {
            return true;
        }
        GlStateManager.func_179137_b((double)labelOffsetX, (double)(labelOffsetY += (int)Math.round((double)(usableIcon ? 11 : 5) * figureScale * (double)optionalScale)), (double)(optionalDepth + (double)0.1f));
        if (optionalScale < 1.0f) {
            optionalScale = 1.0f;
        }
        this.renderLabel(e, renderEntity, name, optionalScale);
        return true;
    }

    @Override
    public void postRender(MinimapElementRenderInfo renderInfo) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
        GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        GlStateManager.func_179118_c();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
        this.previousCategory = null;
    }

    private void renderIcon(XaeroIcon entityIcon, double optionalScale, double figureScale, float offY, boolean cave) {
        double clampedScale = Math.max(1.0, figureScale * optionalScale);
        GlStateManager.func_179152_a((float)((float)clampedScale), (float)((float)clampedScale), (float)1.0f);
        float brightness = !this.heightBasedFade ? 1.0f : this.radarSession.getColorHelper().getEntityHeightFade(offY, this.heightLimit, this.startFadingAt);
        float opacity = 1.0f;
        if (cave) {
            opacity = brightness;
            brightness = 1.0f;
        }
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        GlStateManager.func_179144_i((int)entityIcon.getTextureAtlas().getTextureId());
        GlStateManager.func_179131_c((float)brightness, (float)brightness, (float)brightness, (float)opacity);
        this.helper.drawMyTexturedModalRect(-31.0f, -31.0f, entityIcon.getOffsetX() + 1, entityIcon.getOffsetY() + 1, 62.0f, 62.0f, entityIcon.getTextureAtlas().getWidth());
    }

    private float renderDot(Entity e, EntityPlayer player, boolean smooth, float optionalScale, double figureScale, float offY, boolean cave) {
        GlStateManager.func_179152_a((float)optionalScale, (float)optionalScale, (float)1.0f);
        int color = this.radarSession.getColorHelper().getEntityColor(e, offY, cave, this.heightLimit, this.startFadingAt, this.heightBasedFade, this.radarColor, this.fallbackColor);
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float a = (float)(color >> 24 & 0xFF) / 255.0f;
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)a);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureLocations.GUI_TEXTURES);
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)771);
        int dotTextureX = 0;
        int dotTextureY = 0;
        int dotTextureW = 0;
        int dotTextureH = 0;
        float dotOffset = 0.0f;
        if (this.dotsStyle == 1) {
            if (smooth) {
                dotTextureX = 1;
                dotTextureY = 88;
            } else {
                dotTextureX = 9;
                dotTextureY = 77;
            }
            dotOffset = -3.5f;
            dotTextureH = 8;
            dotTextureW = 8;
            GlStateManager.func_179152_a((float)((float)figureScale), (float)((float)figureScale), (float)1.0f);
        } else {
            switch (((RadarRenderContext)this.context).dotSize) {
                case 1: {
                    dotOffset = -4.5f;
                    dotTextureY = 108;
                    dotTextureH = 9;
                    dotTextureW = 9;
                    break;
                }
                case 3: {
                    dotOffset = -7.5f;
                    dotTextureY = 128;
                    dotTextureH = 15;
                    dotTextureW = 15;
                    break;
                }
                case 4: {
                    dotOffset = -10.5f;
                    dotTextureY = 160;
                    dotTextureH = 21;
                    dotTextureW = 21;
                    break;
                }
                default: {
                    dotOffset = -5.5f;
                    dotTextureY = 117;
                    dotTextureH = 11;
                    dotTextureW = 11;
                }
            }
        }
        this.helper.drawMyTexturedModalRect(dotOffset, dotOffset, dotTextureX, dotTextureY, dotTextureW, dotTextureH, 256.0f);
        return dotOffset;
    }

    private void renderLabel(Entity e, Entity renderEntity, boolean name, double optionalScale) {
        GlStateManager.func_179129_p();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        double dotNameScale = this.labelScale * optionalScale;
        GlStateManager.func_179152_a((float)((float)dotNameScale), (float)((float)dotNameScale), (float)1.0f);
        String yValueString = null;
        if (this.displayY > 0) {
            int yInt = (int)Math.floor(e.field_70163_u);
            int pYInt = (int)Math.floor(renderEntity.field_70163_u);
            yValueString = this.displayY == 1 ? yInt + "" : (this.displayY == 2 ? yInt - pYInt + "" : "");
            if ((yValueString = yValueString + (yInt > pYInt ? "\u2191" : (yInt != pYInt ? "\u2193" : ""))).length() == 0) {
                yValueString = "-";
            }
        }
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        String label = null;
        if (name) {
            if (e instanceof EntityItem) {
                EntityItem ei = (EntityItem)e;
                label = ei.func_92059_d().func_82833_r();
            } else {
                label = e.func_145748_c_().func_150254_d();
            }
            if (this.displayY > 0) {
                label = label + "(" + yValueString + ")";
            }
        } else if (this.displayY > 0) {
            label = yValueString;
        }
        if (label == null) {
            return;
        }
        int labelW = font.func_78256_a(label);
        GlStateManager.func_179090_x();
        this.helper.drawMyColoredRect(-labelW / 2 - 2, -1.0f, labelW / 2 + 1, 9.0f, 0x5A000000);
        GlStateManager.func_179098_w();
        font.func_78276_b(label, -labelW / 2, 0, -1);
        GlStateManager.func_179141_d();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179089_o();
    }

    private void setupRenderForCategory(EntityRadarCategory entityCategory) {
        if (!this.radarRenderProvider.isUsed()) {
            this.radarRenderProvider.setupContextForCategory(entityCategory, (RadarRenderContext)this.context);
        }
        this.heightLimit = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_LIMIT).intValue();
        this.heightBasedFade = entityCategory.getSettingValue(EntityRadarCategorySettings.HEIGHT_FADE);
        this.startFadingAt = entityCategory.getSettingValue(EntityRadarCategorySettings.START_FADING_AT).intValue();
        this.displayNameWhenIconFails = entityCategory.getSettingValue(EntityRadarCategorySettings.ICON_NAME_FALLBACK);
        this.alwaysNameTags = entityCategory.getSettingValue(EntityRadarCategorySettings.ALWAYS_NAMETAGS);
        this.radarColor = RadarColor.fromIndex(entityCategory.getSettingValue(EntityRadarCategorySettings.COLOR).intValue());
        this.fallbackColor = this.radarSession.getColorHelper().getFallbackColor(entityCategory);
        this.displayY = entityCategory.getSettingValue(EntityRadarCategorySettings.DISPLAY_Y).intValue();
        this.nameSettingForCategory = entityCategory.getSettingValue(EntityRadarCategorySettings.NAMES).intValue();
        this.namesForCategory = this.nameSettingForCategory == 1 && ((RadarRenderContext)this.context).playerListDown || this.nameSettingForCategory == 2;
    }

    private void setupRenderForEntity(Entity entity) {
        boolean name;
        if (!this.radarRenderProvider.isUsed()) {
            this.radarRenderProvider.setupContextForEntity(entity, (RadarRenderContext)this.context);
        }
        if (!(name = this.namesForCategory) && !(entity instanceof EntityPlayer)) {
            name = this.alwaysNameTags && entity.func_145818_k_();
        }
        this.name = name;
    }

    private void confirmTrackedPlayerRadarRender(EntityPlayer e) {
        if (HudMod.INSTANCE.getTrackedPlayerRenderer().getCollector().playerExists(e.func_110124_au())) {
            HudMod.INSTANCE.getTrackedPlayerRenderer().getCollector().confirmPlayerRadarRender(e);
        }
        if (!HudMod.INSTANCE.getSupportMods().worldmap()) {
            return;
        }
        if (!HudMod.INSTANCE.getSupportMods().worldmapSupport.hasTrackedPlayerSystemSupport()) {
            return;
        }
        HudMod.INSTANCE.getSupportMods().worldmapSupport.confirmPlayerRadarRender(e);
    }

    public void renderSingleEntity(Entity entity, boolean cave, boolean highlighted, float optionalScale, boolean allowIcon, boolean allowLabel, MinimapElementRenderLocation location, Framebuffer defaultFramebuffer, ScaledResolution scaledRes) {
        ((RadarRenderContext)this.context).entityCategory = null;
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        MinimapElementRenderInfo renderInfo = new MinimapElementRenderInfo(location, entity, (EntityPlayer)player, EntityUtils.getEntityPos(entity, 1.0f), cave, 1.0f, defaultFramebuffer, scaledRes, 1.0, entity.field_70170_p.field_73011_w.getDimension());
        this.preRender(renderInfo);
        this.iconsAllowed = allowIcon;
        this.labelsAllowed = allowLabel;
        this.renderElement(entity, highlighted, false, 0.0, optionalScale, 0.0, 0.0, renderInfo);
        this.postRender(renderInfo);
    }

    @Override
    public boolean shouldRender(MinimapElementRenderLocation location) {
        if (!this.minimap.usingFBO()) {
            return false;
        }
        if (location == MinimapElementRenderLocation.WORLD_MAP) {
            return true;
        }
        if (location == MinimapElementRenderLocation.WORLD_MAP_MENU) {
            return true;
        }
        return HudMod.INSTANCE.getSettings().getEntityRadar();
    }

    public static final class Builder {
        private RadarIconManager radarIconManager;
        private Minimap minimap;

        private Builder() {
        }

        public Builder setDefault() {
            this.setRadarIconManager(null);
            return this;
        }

        public Builder setRadarIconManager(RadarIconManager radarIconManager) {
            this.radarIconManager = radarIconManager;
            return this;
        }

        public Builder setMinimap(Minimap minimap) {
            this.minimap = minimap;
            return this;
        }

        public RadarRenderer build() {
            if (this.radarIconManager == null || this.minimap == null) {
                throw new IllegalStateException();
            }
            xaero.common.minimap.render.radar.element.RadarElementReader elementReader = new xaero.common.minimap.render.radar.element.RadarElementReader();
            xaero.common.minimap.render.radar.element.RadarRenderProvider provider = new xaero.common.minimap.render.radar.element.RadarRenderProvider();
            xaero.common.minimap.render.radar.element.RadarRenderContext context = new xaero.common.minimap.render.radar.element.RadarRenderContext();
            return new xaero.common.minimap.render.radar.element.RadarRenderer(this.radarIconManager, this.minimap, elementReader, provider, context);
        }

        public static Builder begin() {
            return new Builder().setDefault();
        }
    }
}

