/*
 * Decompiled with CFR 0.152.
 */
package xaero.hud.category.ui.node;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import xaero.common.graphics.CursorBox;
import xaero.common.misc.ListFactory;
import xaero.hud.category.ObjectCategory;
import xaero.hud.category.ui.GuiCategoryEditor;
import xaero.hud.category.ui.entry.ConnectionLineType;
import xaero.hud.category.ui.entry.EditorListEntryCategory;
import xaero.hud.category.ui.entry.EditorListRootEntry;
import xaero.hud.category.ui.entry.EditorListRootEntryFactory;
import xaero.hud.category.ui.node.EditorAdderNode;
import xaero.hud.category.ui.node.EditorNode;
import xaero.hud.category.ui.node.EditorSettingsNode;
import xaero.hud.category.ui.node.tooltip.IEditorDataTooltipSupplier;

public abstract class EditorCategoryNode<C extends ObjectCategory<?, C>, SD extends EditorSettingsNode<?>, ED extends EditorCategoryNode<C, SD, ED>>
extends EditorNode {
    private final ED self = this;
    private boolean cut;
    private final List<ED> subCategories;
    private final EditorAdderNode topAdder;
    private final Function<EditorAdderNode, ED> newCategorySupplier;
    private final SD settingsNode;

    protected EditorCategoryNode(@Nonnull SD settingNode, @Nonnull List<ED> subCategories, @Nonnull EditorAdderNode topAdder, @Nonnull Function<EditorAdderNode, ED> newCategorySupplier, boolean movable, int subIndex, @Nonnull EditorListRootEntryFactory listEntryFactory, IEditorDataTooltipSupplier tooltipSupplier) {
        super(movable, listEntryFactory, tooltipSupplier);
        this.settingsNode = settingNode;
        this.subCategories = subCategories;
        this.topAdder = topAdder;
        this.newCategorySupplier = newCategorySupplier;
    }

    public SD getSettingsNode() {
        return this.settingsNode;
    }

    public final List<ED> getSubCategories() {
        return this.subCategories;
    }

    public String getName() {
        return ((EditorSettingsNode)this.settingsNode).getNameOption().getResult();
    }

    @Override
    public String getDisplayName() {
        return this.getName();
    }

    private BiConsumer<EditorAdderNode, Integer> getAdderHandler() {
        return new BiConsumer<EditorAdderNode, Integer>(){

            @Override
            public void accept(EditorAdderNode adder, Integer i) {
                if (!adder.isConfirmed()) {
                    return;
                }
                EditorCategoryNode newCategory = (EditorCategoryNode)EditorCategoryNode.this.newCategorySupplier.apply(adder);
                EditorCategoryNode.this.subCategories.add(i, newCategory);
                adder.reset();
            }
        };
    }

    private Runnable getDeletionHandler() {
        return new Runnable(){

            @Override
            public void run() {
                Iterator subIterator = EditorCategoryNode.this.subCategories.iterator();
                while (subIterator.hasNext()) {
                    EditorCategoryNode subCategory = (EditorCategoryNode)subIterator.next();
                    if (!((EditorSettingsNode)subCategory.getSettingsNode()).isToBeDeleted()) continue;
                    subIterator.remove();
                }
            }
        };
    }

    public Supplier<Boolean> getMoveAction(final int subIndex, final int direction, final GuiCategoryEditor.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                int newSlot = subIndex + direction;
                EditorCategoryNode subCategoryToMove = (EditorCategoryNode)EditorCategoryNode.this.subCategories.get(subIndex);
                rowList.setLastExpandedData(subCategoryToMove);
                if (newSlot < 0) {
                    EditorCategoryNode.this.subCategories.remove(subCategoryToMove);
                    EditorCategoryNode.this.subCategories.add(subCategoryToMove);
                    return true;
                }
                if (newSlot >= EditorCategoryNode.this.subCategories.size()) {
                    EditorCategoryNode.this.subCategories.remove(subCategoryToMove);
                    EditorCategoryNode.this.subCategories.add(0, subCategoryToMove);
                    return true;
                }
                rowList.restoreScrollAfterUpdate();
                EditorCategoryNode subCategoryToReplace = (EditorCategoryNode)EditorCategoryNode.this.subCategories.get(newSlot);
                EditorCategoryNode.this.subCategories.set(subIndex, subCategoryToReplace);
                EditorCategoryNode.this.subCategories.set(newSlot, subCategoryToMove);
                return true;
            }
        };
    }

    public Supplier<Boolean> getDuplicateAction(final int subIndex, final GuiCategoryEditor.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                if (subIndex < 0 || subIndex >= EditorCategoryNode.this.subCategories.size()) {
                    return false;
                }
                final EditorCategoryNode subCategoryToDuplicate = (EditorCategoryNode)EditorCategoryNode.this.subCategories.get(subIndex);
                final GuiCategoryEditor screenToRestore = (GuiCategoryEditor)Minecraft.func_71410_x().field_71462_r;
                String confirmSecondLine = "\u00a7e" + I18n.func_135052_a((String)subCategoryToDuplicate.getDisplayName(), (Object[])new Object[0]);
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo(new GuiYesNoCallback(){

                    public void func_73878_a(boolean result, int i) {
                        if (!result) {
                            Minecraft.func_71410_x().func_147108_a((GuiScreen)screenToRestore);
                            return;
                        }
                        Object convertedCategory = rowList.getDataConverter().convert(subCategoryToDuplicate);
                        Object reconstructedEditorData = rowList.getDataConverter().convert(convertedCategory, false);
                        ((EditorCategoryNode)reconstructedEditorData).removeProtectionRecursive();
                        EditorCategoryNode.this.subCategories.add(subIndex + 1, reconstructedEditorData);
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)screenToRestore);
                        GuiCategoryEditor.SettingRowList newRowList = screenToRestore.getRowList();
                        newRowList.setLastExpandedData((EditorNode)reconstructedEditorData);
                        newRowList.updateEntries();
                    }
                }, I18n.func_135052_a((String)"gui.xaero_category_duplicate_confirm", (Object[])new Object[0]), confirmSecondLine, 0));
                return true;
            }
        };
    }

    public Supplier<Boolean> getCutAction(final ED parent, final GuiCategoryEditor.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                rowList.setCutCategory(EditorCategoryNode.this.self, parent);
                rowList.setLastExpandedData(EditorCategoryNode.this);
                rowList.restoreScrollAfterUpdate();
                return true;
            }
        };
    }

    public Supplier<Boolean> getPasteAction(final GuiCategoryEditor.SettingRowList rowList) {
        return new Supplier<Boolean>(){

            @Override
            public Boolean get() {
                rowList.pasteTo(EditorCategoryNode.this.self);
                rowList.restoreScrollAfterUpdate();
                return true;
            }
        };
    }

    @Override
    public List<EditorNode> getSubNodes() {
        BiConsumer<EditorAdderNode, Integer> adderHandler = this.getAdderHandler();
        adderHandler.accept(this.topAdder, 0);
        this.getDeletionHandler().run();
        ArrayList<EditorNode> result = new ArrayList<EditorNode>(this.subCategories);
        result.add(0, this.topAdder);
        result.add(0, (EditorNode)this.settingsNode);
        return result;
    }

    public void removeProtectionRecursive() {
        ((EditorSettingsNode)this.getSettingsNode()).setProtected(false);
        for (EditorCategoryNode sub : this.subCategories) {
            sub.removeProtectionRecursive();
        }
    }

    public static abstract class Builder<C extends ObjectCategory<?, C>, ED extends EditorCategoryNode<C, SD, ED>, SD extends EditorSettingsNode<?>, SDB extends EditorSettingsNode.Builder<SD, SDB>, EDB extends Builder<C, ED, SD, SDB, EDB>>
    extends EditorNode.Builder<EDB> {
        protected final EDB self;
        protected String name;
        protected final SDB settingsDataBuilder;
        protected final List<EDB> subCategoryBuilders;
        protected final ListFactory listFactory;
        protected final EditorAdderNode.Builder topAdderBuilder;
        protected Function<EditorAdderNode, ED> newCategorySupplier;
        protected int subIndex;

        protected Builder(ListFactory listFactory, SDB settingsDataBuilder) {
            if (settingsDataBuilder == null) {
                throw new IllegalStateException("settings data builder cannot be null!");
            }
            this.settingsDataBuilder = settingsDataBuilder;
            this.subCategoryBuilders = listFactory.get();
            this.listFactory = listFactory;
            this.topAdderBuilder = EditorAdderNode.Builder.begin(listFactory);
            this.self = this;
        }

        @Override
        public EDB setDefault() {
            super.setDefault();
            this.setName(null);
            ((EditorSettingsNode.Builder)this.settingsDataBuilder).setDefault();
            this.subCategoryBuilders.clear();
            this.topAdderBuilder.setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_add_subcategory", (Object[])new Object[0]));
            this.setMovable(true);
            this.setSubIndex(0);
            this.setTooltipSupplier(new IEditorDataTooltipSupplier(){

                @Override
                public Supplier<CursorBox> apply(EditorNode parent, EditorNode data) {
                    TextComponentTranslation displayNameComponent = new TextComponentTranslation(data.getDisplayName(), new Object[0]);
                    CursorBox tooltip = new CursorBox((ITextComponent)new TextComponentTranslation("gui.xaero_box_category", new Object[]{displayNameComponent}));
                    tooltip.setAutoLinebreak(false);
                    return tooltip;
                }
            });
            return this.self;
        }

        @Override
        protected EditorListRootEntry mainEntryFactory(EditorNode data, EditorNode parent, int index, ConnectionLineType lineType, GuiCategoryEditor.SettingRowList rowList, int screenWidth, boolean isFinalExpanded) {
            return new EditorListEntryCategory(screenWidth, index, rowList, lineType, (EditorCategoryNode)data, (EditorCategoryNode)parent, data.getTooltipSupplier(parent), isFinalExpanded);
        }

        public EDB setNewCategorySupplier(Function<EditorAdderNode, ED> newCategorySupplier) {
            this.newCategorySupplier = newCategorySupplier;
            return this.self;
        }

        public EDB setSubIndex(int subIndex) {
            this.subIndex = subIndex;
            return this.self;
        }

        public EDB setName(String name) {
            this.name = name;
            return this.self;
        }

        public SDB getSettingDataBuilder() {
            return this.settingsDataBuilder;
        }

        public EDB addSubCategoryBuilder(EDB subCategory) {
            ((Builder)subCategory).setSubIndex(this.subCategoryBuilders.size());
            this.subCategoryBuilders.add(subCategory);
            return this.self;
        }

        protected List<ED> buildSubCategories() {
            return (List)this.subCategoryBuilders.stream().map(new Function<EDB, Object>(){

                @Override
                public Object apply(EDB b) {
                    return ((Builder)b).build();
                }
            }).collect(new Supplier<List<ED>>(){

                @Override
                public List<ED> get() {
                    return Builder.this.listFactory.get();
                }
            }, new BiConsumer<List<ED>, Object>(){

                @Override
                public void accept(List<ED> l, Object e) {
                    l.add((EditorCategoryNode)e);
                }
            }, new BiConsumer<List<ED>, List<ED>>(){

                @Override
                public void accept(List<ED> l1, List<ED> l2) {
                    l1.addAll(l2);
                }
            });
        }

        public ED build() {
            if (this.name == null || this.newCategorySupplier == null) {
                throw new IllegalStateException("required fields not set!");
            }
            ((EditorSettingsNode.Builder)this.settingsDataBuilder).getNameOptionBuilder().setInput(this.name);
            ((EditorSettingsNode.Builder)this.settingsDataBuilder).getNameOptionBuilder().setDisplayName(I18n.func_135052_a((String)"gui.xaero_category_name", (Object[])new Object[0]));
            ((EditorSettingsNode.Builder)this.settingsDataBuilder).getNameOptionBuilder().setMaxLength(200);
            EditorCategoryNode result = (EditorCategoryNode)super.build();
            return (ED)result;
        }
    }
}

