/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.controls;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.GameSettings;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import xaero.common.HudMod;
import xaero.common.IXaeroMinimap;
import xaero.common.effect.Effects;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiSlimeSeed;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.ScreenBase;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.misc.KeySortableByOther;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.hud.HudSession;
import xaero.hud.minimap.BuiltInHudModules;
import xaero.hud.minimap.MinimapLogs;
import xaero.hud.minimap.module.MinimapSession;
import xaero.hud.minimap.waypoint.set.WaypointSet;
import xaero.hud.minimap.world.MinimapWorld;
import xaero.hud.minimap.world.MinimapWorldManager;

public class ControlsHandler {
    protected IXaeroMinimap modMain;
    protected HudSession hudSession;

    public ControlsHandler(IXaeroMinimap modMain, HudSession hudSession) {
        this.modMain = modMain;
        this.hudSession = hudSession;
    }

    public void setKeyState(KeyBinding kb, boolean pressed) {
        KeyBinding.func_74510_a((int)kb.func_151463_i(), (boolean)pressed);
    }

    public boolean isDown(KeyBinding kb) {
        return GameSettings.func_100015_a((KeyBinding)kb);
    }

    public void keyDownPre(KeyBinding kb) {
    }

    public void keyDownPost(KeyBinding kb) {
    }

    public void keyDown(KeyBinding kb, boolean tickEnd, boolean isRepeat) {
        MinimapSession session = BuiltInHudModules.MINIMAP.getCurrentSession();
        MinimapWorldManager waypointsManager = session.getWorldManager();
        Minecraft mc = Minecraft.func_71410_x();
        if (!tickEnd) {
            MinimapWorld currentWorld;
            GuiScreen currentEscScreen;
            GuiScreen current;
            this.keyDownPre(kb);
            if (kb == ModSettings.newWaypoint && this.modMain.getSettings().waypointsGUI(session)) {
                mc.func_147108_a((GuiScreen)new GuiAddWaypoint((HudMod)this.modMain, session, null, new ArrayList<Waypoint>(), session.getWorldState().getCurrentWorldPath().getRoot(), waypointsManager.getCurrentWorld(), true));
            }
            if (kb == ModSettings.keyWaypoints && this.modMain.getSettings().waypointsGUI(session)) {
                current = mc.field_71462_r;
                currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                mc.func_147108_a((GuiScreen)new GuiWaypoints((HudMod)this.modMain, session, current, currentEscScreen));
            }
            if (kb == ModSettings.keyLargeMap) {
                session.getProcessor().setEnlargedMap(this.modMain.getSettings().enlargedMinimapAToggle ? !session.getProcessor().isEnlargedMap() : true);
                session.getProcessor().setToResetImage(true);
                session.getProcessor().instantZoom();
            }
            if (kb == ModSettings.keyToggleMap && !Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_MINIMAP) && !Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_MINIMAP_HARMFUL)) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.MINIMAP, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.INGAME_WAYPOINTS, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleMapWaypoints) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS, 0);
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleSlimes) {
                try {
                    if (this.modMain.getSettings().customSlimeSeedNeeded(this.hudSession) && this.modMain.getSettings().getBooleanValue(ModOptions.OPEN_SLIME_SETTINGS)) {
                        current = mc.field_71462_r;
                        currentEscScreen = current instanceof ScreenBase ? ((ScreenBase)current).escape : null;
                        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSlimeSeed(this.modMain, session, current, currentEscScreen));
                    } else {
                        this.modMain.getSettings().slimeChunks = !this.modMain.getSettings().slimeChunks;
                        this.modMain.getSettings().saveSettings();
                    }
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyToggleGrid) {
                try {
                    this.modMain.getSettings().chunkGrid = -this.modMain.getSettings().chunkGrid - 1;
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyInstantWaypoint && !Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_WAYPOINTS) && !Misc.hasEffect((EntityPlayer)mc.field_71439_g, Effects.NO_WAYPOINTS_HARMFUL)) {
                session.getWaypointSession().getTemporaryHandler().createTemporaryWaypoint(waypointsManager.getCurrentWorld(), OptimizedMath.myFloor(mc.func_175606_aa().field_70165_t), OptimizedMath.myFloor(mc.func_175606_aa().field_70163_u + 0.0625), OptimizedMath.myFloor(mc.func_175606_aa().field_70161_v));
            }
            if (kb == ModSettings.keySwitchSet && (currentWorld = waypointsManager.getCurrentWorld()) != null) {
                ArrayList<KeySortableByOther<Object>> keysList = new ArrayList<KeySortableByOther<Object>>();
                for (WaypointSet set : currentWorld.getIterableWaypointSets()) {
                    String key = set.getName();
                    keysList.add(new KeySortableByOther<Object>(key, new Comparable[]{I18n.func_135052_a((String)key, (Object[])new Object[0]).toLowerCase()}));
                }
                Collections.sort(keysList);
                boolean foundCurrent = false;
                String firstSetKey = null;
                for (KeySortableByOther keySortableByOther : keysList) {
                    String setKey = (String)keySortableByOther.getKey();
                    if (firstSetKey == null) {
                        firstSetKey = setKey;
                    }
                    if (setKey != null && setKey.equals(currentWorld.getCurrentWaypointSetId())) {
                        foundCurrent = true;
                        continue;
                    }
                    if (!foundCurrent) continue;
                    foundCurrent = false;
                    currentWorld.setCurrentWaypointSetId(setKey);
                    break;
                }
                if (foundCurrent) {
                    currentWorld.setCurrentWaypointSetId(firstSetKey);
                }
                session.getWorldStateUpdater().update();
                session.getWaypointSession().setSetChangedTime(System.currentTimeMillis());
                try {
                    session.getWorldManagerIO().saveWorld(currentWorld);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyAllSets) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.WAYPOINTS_ALL_SETS, 0);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyLightOverlay) {
                this.modMain.getSettings().lightOverlayType = this.modMain.getSettings().lightOverlayType == 0 ? 1 : (this.modMain.getSettings().lightOverlayType *= -1);
                try {
                    this.modMain.getSettings().saveSettings();
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (!session.getProcessor().isEnlargedMap() || this.modMain.getSettings().zoomOnEnlarged == 0) {
                int zoomChange = 0;
                if (kb == ModSettings.keyBindZoom) {
                    zoomChange = 1;
                }
                if (kb == ModSettings.keyBindZoom1) {
                    zoomChange = -1;
                }
                if (zoomChange != 0) {
                    this.modMain.getSettings().changeZoom(zoomChange);
                    try {
                        this.modMain.getSettings().saveSettings();
                    }
                    catch (IOException e) {
                        MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                    }
                }
            }
            if (kb == ModSettings.keyToggleRadar) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.RADAR_DISPLAYED, 0);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            if (kb == ModSettings.keyManualCaveMode) {
                session.getProcessor().toggleManualCaveMode();
            } else if (kb == ModSettings.keyToggleTrackedPlayersOnMap) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.TRACKED_PLAYERS_ON_MAP, 0);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            } else if (kb == ModSettings.keyToggleTrackedPlayersInWorld) {
                try {
                    this.modMain.getSettings().setOptionValue(ModOptions.TRACKED_PLAYERS_IN_WORLD, 0);
                }
                catch (IOException e) {
                    MinimapLogs.LOGGER.error("suppressed exception", (Throwable)e);
                }
            }
            this.keyDownPost(kb);
        }
    }

    public void keyUpPre(KeyBinding kb) {
    }

    public void keyUpPost(KeyBinding kb) {
    }

    public void keyUp(KeyBinding kb, boolean tickEnd) {
        MinimapSession minimapSession = BuiltInHudModules.MINIMAP.getCurrentSession();
        if (!tickEnd) {
            this.keyUpPre(kb);
            if (!this.modMain.getSettings().enlargedMinimapAToggle && kb == ModSettings.keyLargeMap) {
                minimapSession.getProcessor().setEnlargedMap(false);
                minimapSession.getProcessor().setToResetImage(true);
                minimapSession.getProcessor().instantZoom();
            }
            this.keyUpPost(kb);
        }
    }
}

