/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.misc;

import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;
import shetiphian.core.common.Function;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.block.BlockEnderTank;
import shetiphian.endertanks.common.misc.TankHelper;

public class EventHandler {
    @SubscribeEvent
    public void worldSave(WorldEvent.Save event) {
        TankHelper.INSTANCE.saveTankData(event);
    }

    @SubscribeEvent
    public void playerRightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
        EntityPlayer player = event.getEntityPlayer();
        if (player == null || player.func_70093_af() || event.getItemStack().func_190926_b() || event.getItemStack().func_77973_b() instanceof ItemBlock) {
            return;
        }
        Function.BlockInfo blockInfo = Function.getBlockInfront((World)event.getWorld(), (EntityPlayer)player, (double)5.0, (boolean)false);
        if (blockInfo != null && blockInfo.block instanceof BlockEnderTank) {
            for (ItemStack stack : Values.itemCapacitySmall) {
                if (!Function.areItemStacksEqual((ItemStack)event.getItemStack(), (ItemStack)stack, (boolean)true)) continue;
                event.setCanceled(true);
                return;
            }
            for (ItemStack stack : Values.itemCapacityLarge) {
                if (!Function.areItemStacksEqual((ItemStack)event.getItemStack(), (ItemStack)stack, (boolean)true)) continue;
                event.setCanceled(true);
                return;
            }
        }
    }

    @SubscribeEvent
    public void missingItemMappings(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            String name = mapping.key.toString();
            if (Values.itemEnderBucket != null && name.equalsIgnoreCase("EnderTanks:itemEnderBucket")) {
                Values.logEnderTanks.info("Item Remap: " + name + " > " + Values.itemEnderBucket.getRegistryName());
                mapping.remap((IForgeRegistryEntry)Values.itemEnderBucket);
            }
            if (Values.blockEnderTank == null || !name.equalsIgnoreCase("EnderTanks:blockEnderTank")) continue;
            Values.logEnderTanks.info("ItemBlock Remap: " + name + " > " + Values.blockEnderTank.getRegistryName());
            mapping.remap((IForgeRegistryEntry)Item.func_150898_a((Block)Values.blockEnderTank));
        }
    }

    @SubscribeEvent
    public void missingBlockMappings(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping mapping : event.getAllMappings()) {
            Block block;
            String name = mapping.key.toString();
            if (Values.blockEnderTank == null || !name.equalsIgnoreCase("EnderTanks:blockEnderTank") || (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation("endertanks:ender_tank"))) == null) continue;
            Values.logEnderTanks.info("Block Remap: " + name + " > " + block.getRegistryName());
            mapping.remap((IForgeRegistryEntry)block);
        }
    }
}

