/*
 * Decompiled with CFR 0.152.
 */
package shetiphian.endertanks.common.block;

import com.google.common.base.Strings;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import shetiphian.core.common.CapabilityHelper;
import shetiphian.core.common.Function;
import shetiphian.core.common.IColored;
import shetiphian.core.common.MaterialImmovable;
import shetiphian.endertanks.Configuration;
import shetiphian.endertanks.Values;
import shetiphian.endertanks.common.misc.CauldronHelper;
import shetiphian.endertanks.common.misc.StackHelper;
import shetiphian.endertanks.common.misc.TankHelper;
import shetiphian.endertanks.common.misc.TankInfoHelper;
import shetiphian.endertanks.common.tileentity.TileEntityEnderTank;

public class BlockEnderTank
extends Block
implements IColored {
    public static final PropertyDirection FACING = PropertyDirection.func_177714_a((String)"facing");
    private static final PropertyEnum<EnumType> VARIANT = PropertyEnum.func_177709_a((String)"variant", EnumType.class);
    private static final PropertyBool POWERED = PropertyBool.func_177716_a((String)"powered");
    private static final AxisAlignedBB AABB_UD = new AxisAlignedBB(0.125, 0.0, 0.125, 0.875, 1.0, 0.875);
    private static final AxisAlignedBB AABB_NS = new AxisAlignedBB(0.125, 0.125, 0.0, 0.875, 0.875, 1.0);
    private static final AxisAlignedBB AABB_EW = new AxisAlignedBB(0.0, 0.125, 0.125, 1.0, 0.875, 0.875);
    private final float[] size = new float[]{0.09375f, 0.90625f};
    private final float[][] ring = new float[][]{{0.59375f, 0.65625f}, {0.46875f, 0.53125f}, {0.34375f, 0.40625f}};

    public BlockEnderTank() {
        super((Material)MaterialImmovable.TRANSLUCENT);
        this.func_149647_a((CreativeTabs)Values.tabEnderTanks);
        this.func_149672_a(SoundType.field_185851_d);
        this.func_149711_c(1.5f);
        this.func_149752_b(5.0f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING, VARIANT, POWERED});
    }

    public IBlockState func_176203_a(int meta) {
        EnumFacing facing = EnumFacing.func_82600_a((int)(meta > 5 ? 0 : meta));
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)facing);
    }

    public int func_176201_c(IBlockState state) {
        return BlockEnderTank.getFacing(state).func_176745_a();
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            state = state.func_177226_a((IProperty)POWERED, (Comparable)Boolean.valueOf(tile.func_145831_w().func_175640_z(pos)));
            return state.func_177226_a(VARIANT, (Comparable)((Object)(tile.isTeam() ? EnumType.TEAM : (tile.isPublic() ? EnumType.PUBLIC : EnumType.PRIVATE))));
        }
        return state;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityEnderTank();
    }

    private TileEntityEnderTank getTile(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityEnderTank ? (TileEntityEnderTank)tile : null;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean canCreatureSpawn(IBlockState state, IBlockAccess world, BlockPos pos, EntityLiving.SpawnPlacementType type) {
        return false;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (state.func_177230_c() != this) {
            return AABB_UD;
        }
        return this.getTraceBox(world, pos, state);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity, boolean p_185477_7_) {
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)mask, list, (AxisAlignedBB)this.getBounds(state));
    }

    private AxisAlignedBB getBounds(IBlockState state) {
        EnumFacing facing = BlockEnderTank.getFacing(state);
        switch (facing) {
            case DOWN: 
            case UP: {
                return AABB_UD;
            }
            case NORTH: 
            case SOUTH: {
                return AABB_NS;
            }
            case WEST: 
            case EAST: {
                return AABB_EW;
            }
        }
        return Block.field_185505_j;
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return false;
        }
        TileEntityEnderTank tankTile = this.getTile((IBlockAccess)world, pos);
        if (tankTile == null || tankTile.lastClick > System.currentTimeMillis()) {
            return false;
        }
        tankTile.lastClick = System.currentTimeMillis() + 200L;
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (tankTile.canUse(player)) {
                EnumFacing tankFacing = BlockEnderTank.getFacing(state);
                IFluidHandler tankHandler = CapabilityHelper.getFluidHandler((TileEntity)tankTile, (EnumFacing)tankFacing);
                IFluidHandler iFluidHandler = CapabilityHelper.getFluidHandler((ItemStack)heldItem.func_77946_l().func_77979_a(1), (EnumFacing)facing);
                if (tankHandler != null && iFluidHandler != null) {
                    int used;
                    IFluidTankProperties[] properties = iFluidHandler.getTankProperties();
                    int containerCapacity = properties != null && properties.length > 0 ? properties[0].getCapacity() : 1000;
                    FluidStack fluidStack = tankHandler.drain(containerCapacity, false);
                    int n = used = fluidStack != null ? iFluidHandler.fill(fluidStack, false) : 0;
                    if (used > 0) {
                        iFluidHandler.fill(tankHandler.drain(used, true), true);
                        world.func_184133_a(player, pos, fluidStack.getFluid().getFillSound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                    } else {
                        fluidStack = iFluidHandler.drain(containerCapacity, false);
                        int n2 = used = fluidStack != null ? tankHandler.fill(fluidStack, false) : 0;
                        if (used > 0) {
                            tankHandler.fill(iFluidHandler.drain(used, true), true);
                            world.func_184133_a(player, pos, fluidStack.getFluid().getEmptySound(), SoundCategory.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                    if (used > 0 && iFluidHandler instanceof IFluidHandlerItem) {
                        heldItem.func_190918_g(1);
                        Function.giveItem((EntityPlayer)player, (ItemStack)((IFluidHandlerItem)iFluidHandler).getContainer());
                    }
                    return true;
                }
            }
            if (world.field_72995_K) {
                return true;
            }
            if (tankTile.isPublic()) {
                boolean changed = false;
                for (ItemStack itemStack : Values.itemPersonal) {
                    if (!Function.areItemStacksEqual((ItemStack)heldItem, (ItemStack)itemStack, (boolean)true)) continue;
                    if (Configuration.ACCESS_SETTINGS.allowPersonalTanks) {
                        tankTile.setOwner(player, heldItem.func_77946_l().func_77979_a(1));
                        changed = true;
                        break;
                    }
                    TankInfoHelper.sendError(player, "endertanks.tank.private.disabled");
                    break;
                }
                if (!changed) {
                    for (ItemStack itemStack : Values.itemTeam) {
                        if (!Function.areItemStacksEqual((ItemStack)heldItem, (ItemStack)itemStack, (boolean)true)) continue;
                        if (Configuration.ACCESS_SETTINGS.allowTeamTanks) {
                            String teamID = Function.getPlayerTeamID((EntityPlayer)player);
                            if (!Strings.isNullOrEmpty((String)teamID)) {
                                tankTile.setOwner(Function.getTeamDisplayName((String)teamID), "#" + teamID, heldItem.func_77946_l().func_77979_a(1));
                                changed = true;
                                break;
                            }
                            TankInfoHelper.sendError(player, "shetiphian.team.noteam");
                            return true;
                        }
                        TankInfoHelper.sendError(player, "endertanks.tank.team.disabled");
                        break;
                    }
                }
                if (changed) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    Function.syncTile((TileEntity)tankTile);
                    world.func_175685_c(pos, (Block)this, true);
                    return true;
                }
            }
            if (!tankTile.canEdit(player)) {
                return true;
            }
            short capacity = TankHelper.getCapacityInBuckets(tankTile.getTank());
            if (capacity < Configuration.UPGRADE_SETTINGS.tankSizeMax) {
                int newValue = 0;
                for (ItemStack stack : Values.itemCapacitySmall) {
                    if (!Function.areItemStacksEqual((ItemStack)heldItem, (ItemStack)stack, (boolean)true)) continue;
                    newValue = Configuration.UPGRADE_SETTINGS.smallCapacity;
                    break;
                }
                if (newValue == 0 && capacity + Configuration.UPGRADE_SETTINGS.largeCapacity <= Configuration.UPGRADE_SETTINGS.tankSizeMax) {
                    for (ItemStack stack : Values.itemCapacityLarge) {
                        if (!Function.areItemStacksEqual((ItemStack)heldItem, (ItemStack)stack, (boolean)true)) continue;
                        newValue = Configuration.UPGRADE_SETTINGS.largeCapacity;
                        break;
                    }
                }
                if (newValue > 0) {
                    TankHelper.setCapacityInBuckets(tankTile.getTank(), (short)(capacity + newValue));
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    TankInfoHelper.sendCapacityInfo(player, tankTile);
                    return true;
                }
            }
            if (tankTile.getPumpUpgradeCount() < Configuration.UPGRADE_SETTINGS.tankPumpMax) {
                for (ItemStack itemStack : Values.itemPump) {
                    if (!Function.areItemStacksEqual((ItemStack)heldItem, (ItemStack)itemStack, (boolean)true)) continue;
                    tankTile.addPumpUpgrade(heldItem.func_77946_l().func_77979_a(1));
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    TankInfoHelper.sendPumpInfo(player, tankTile);
                    Function.syncTile((TileEntity)tankTile);
                    return true;
                }
            }
            if (Configuration.enableInWorldRecoloring) {
                byte by;
                boolean found = false;
                boolean bl = false;
                block5: while (by < 16) {
                    NonNullList results = Function.getOres((String)Function.dyeNamesWB[by]);
                    for (ItemStack check : results) {
                        if (!OreDictionary.itemMatches((ItemStack)heldItem, (ItemStack)check, (boolean)true)) continue;
                        found = true;
                        break block5;
                    }
                    by = (byte)(by + true);
                }
                if (found && tankTile.doColorRing(EnumDyeColor.func_176764_b((int)by), player)) {
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldItem.func_190918_g(1);
                    }
                    world.func_175685_c(pos, (Block)this, true);
                    return true;
                }
            }
        }
        if (!(world.field_72995_K || !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ItemBlock)) {
            TankInfoHelper.sendTankInfo(player, tankTile);
            return true;
        }
        return false;
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World world, BlockPos pos) {
        TileEntityEnderTank tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null && tile.canEdit(player)) {
            return super.func_180647_a(state, player, world, pos);
        }
        return -1.0f;
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.func_180650_b(world, pos, state, world.field_73012_v);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighbor, BlockPos pos2) {
        this.func_180650_b(world, pos, state, world.field_73012_v);
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random random) {
        boolean isPowered = world.func_175640_z(pos);
        if (!world.field_72995_K && isPowered) {
            TileEntityEnderTank tankTile = this.getTile((IBlockAccess)world, pos);
            if (tankTile != null) {
                EnumFacing tankFacing = BlockEnderTank.getFacing(state);
                BlockPos fromPos = pos.func_177972_a(tankFacing.func_176734_d());
                BlockPos toPos = pos.func_177972_a(tankFacing);
                IFluidHandler thisHandler = CapabilityHelper.getFluidHandler((TileEntity)tankTile, (EnumFacing)tankFacing);
                IFluidHandler fromHandler = CapabilityHelper.getFluidHandler((TileEntity)world.func_175625_s(fromPos), (EnumFacing)tankFacing.func_176734_d());
                IFluidHandler toHandler = CapabilityHelper.getFluidHandler((TileEntity)world.func_175625_s(toPos), (EnumFacing)tankFacing);
                int pumpCapacity = tankTile.getPumpCapacity();
                if (thisHandler != null) {
                    int used;
                    FluidStack fluidStack;
                    if (fromHandler != null) {
                        fluidStack = fromHandler.drain(pumpCapacity, false);
                        used = thisHandler.fill(fluidStack, false);
                        if (used > 0) {
                            thisHandler.fill(fromHandler.drain(used, true), true);
                        }
                    } else if (CauldronHelper.isCauldron((IBlockAccess)world, fromPos)) {
                        CauldronHelper.drainCauldron(thisHandler, world, fromPos, true);
                    }
                    if (toHandler != null) {
                        fluidStack = thisHandler.drain(pumpCapacity, false);
                        used = toHandler.fill(fluidStack, false);
                        if (used > 0) {
                            toHandler.fill(thisHandler.drain(used, true), true);
                        }
                    } else if (CauldronHelper.isCauldron((IBlockAccess)world, toPos)) {
                        CauldronHelper.fillCauldron(thisHandler, world, toPos, true);
                    }
                }
            }
            world.func_175684_a(pos, (Block)this, 20);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (this.func_180647_a(state, player, world, pos) == -1.0f) {
            return false;
        }
        return willHarvest || super.removedByPlayer(state, world, pos, player, false);
    }

    public void func_180657_a(World world, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity tile, ItemStack stack) {
        super.func_180657_a(world, player, pos, state, tile, stack);
        super.removedByPlayer(state, world, pos, player, true);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile != null) {
            if (this.harvesters.get() != null && ((EntityPlayer)this.harvesters.get()).func_70093_af()) {
                drops.add((Object)StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null));
                ItemStack personal = tile.getPersonalItem();
                if (personal != null) {
                    drops.add((Object)personal);
                }
            } else {
                drops.add((Object)StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem()));
            }
            drops.addAll(tile.getPumpUpgrades());
        } else {
            drops.add((Object)new ItemStack((Block)this));
        }
    }

    public int func_180651_a(IBlockState state) {
        return 0;
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityEnderTank tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            if (player != null && !player.func_70093_af()) {
                if (tile.isTeam() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase("#" + Function.getPlayerTeamID((EntityPlayer)player)))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
                if (!tile.isPublic() && (player.field_71075_bZ.field_75098_d || tile.getOwnerID().equalsIgnoreCase(player.func_110124_au().toString()))) {
                    return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), tile.getOwnerID(), tile.getPersonalItem());
                }
            }
            return StackHelper.create(Item.func_150898_a((Block)this), tile.getCode(), null);
        }
        return new ItemStack((Block)this);
    }

    public boolean rotateBlock(World world, BlockPos pos, EnumFacing axis) {
        EnumFacing facing = BlockEnderTank.getFacing(world.func_180495_p(pos));
        if (axis.func_176740_k() == facing.func_176740_k()) {
            return false;
        }
        EnumFacing newFacing = facing.func_176732_a(axis.func_176740_k());
        if (facing != newFacing) {
            Function.setBlock((World)world, (BlockPos)pos, (IBlockState)world.func_180495_p(pos).func_177226_a((IProperty)FACING, (Comparable)newFacing), (boolean)true);
            return true;
        }
        return false;
    }

    public boolean func_149740_M(IBlockState state) {
        return true;
    }

    public int func_180641_l(IBlockState state, World world, BlockPos pos) {
        return CapabilityHelper.getComparatorInputOverride((TileEntity)this.getTile((IBlockAccess)world, pos));
    }

    private AxisAlignedBB getTraceBox(IBlockAccess world, BlockPos pos, IBlockState state) {
        TileEntityEnderTank tile = this.getTile(world, pos);
        if (tile == null || !tile.rayTracing || tile.tracePart < 1 || tile.tracePart > 4) {
            return this.getBounds(state);
        }
        int index = tile.tracePart - 1;
        EnumFacing facing = BlockEnderTank.getFacing(state);
        switch (facing) {
            case DOWN: {
                return new AxisAlignedBB((double)this.size[0], (double)this.ring[index][0], (double)this.size[0], (double)this.size[1], (double)this.ring[index][1], (double)this.size[1]);
            }
            case UP: {
                return new AxisAlignedBB((double)this.size[0], (double)this.ring[2 - index][0], (double)this.size[0], (double)this.size[1], (double)this.ring[2 - index][1], (double)this.size[1]);
            }
            case NORTH: {
                return new AxisAlignedBB((double)this.size[0], (double)this.size[0], (double)this.ring[index][0], (double)this.size[1], (double)this.size[1], (double)this.ring[index][1]);
            }
            case SOUTH: {
                return new AxisAlignedBB((double)this.size[0], (double)this.size[0], (double)this.ring[2 - index][0], (double)this.size[1], (double)this.size[1], (double)this.ring[2 - index][1]);
            }
            case WEST: {
                return new AxisAlignedBB((double)this.ring[index][0], (double)this.size[0], (double)this.size[0], (double)this.ring[index][1], (double)this.size[1], (double)this.size[1]);
            }
            case EAST: {
                return new AxisAlignedBB((double)this.ring[2 - index][0], (double)this.size[0], (double)this.size[0], (double)this.ring[2 - index][1], (double)this.size[1], (double)this.size[1]);
            }
        }
        return this.getBounds(state);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d startVec, Vec3d endVec) {
        this.getBounds(state);
        RayTraceResult original = super.func_180636_a(state, world, pos, startVec, endVec);
        TileEntityEnderTank tile = this.getTile((IBlockAccess)world, pos);
        if (tile != null) {
            RayTraceResult areaHit = null;
            tile.rayTracing = true;
            double hitDist = 100.0;
            for (int codeBand = 0; codeBand < 4; codeBand = (int)((byte)(codeBand + 1))) {
                tile.tracePart = codeBand;
                RayTraceResult ringHit = this.func_185503_a(pos, startVec, endVec, this.getTraceBox((IBlockAccess)world, pos, state));
                if (ringHit == null) continue;
                ringHit.subHit = codeBand;
                double ringDist = ringHit.field_72307_f.func_72436_e(startVec);
                if (!(ringDist < hitDist)) continue;
                hitDist = ringDist;
                areaHit = ringHit;
            }
            if (areaHit != null && areaHit.subHit > 0) {
                tile.tracePart = areaHit.subHit;
                return areaHit;
            }
            tile.rayTracing = false;
        }
        return original;
    }

    public boolean recolorBlock(World world, BlockPos pos, EnumFacing side, EnumDyeColor color) {
        TileEntityEnderTank tankTile;
        if (Configuration.enableInWorldRecoloring && color != null && (tankTile = this.getTile((IBlockAccess)world, pos)) != null) {
            tankTile.setCode(StackHelper.BASE_CODES[color.func_176767_b()]);
            world.func_175685_c(pos, (Block)this, true);
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public int getColorFor(IColored.Data data, int index) {
        TileEntityEnderTank tile;
        if (index > 0 && index < 4 && data.world != null && data.pos != null && (tile = this.getTile(data.world, data.pos)) != null) {
            int value = MathHelper.func_76125_a((int)Integer.parseInt("" + tile.getCode().charAt(index - 1), 16), (int)0, (int)16);
            return Values.colorValues[value];
        }
        return 0xFFFFFF;
    }

    public static EnumFacing getFacing(IBlockState state) {
        EnumFacing facing;
        try {
            facing = (EnumFacing)state.func_177229_b((IProperty)FACING);
        }
        catch (Exception e) {
            facing = EnumFacing.DOWN;
            Values.logEnderTanks.error("PropertyEnum 'BlockEnderTank.FACING' not found in provided BlockState, returning 'DOWN'. Provided BlockState: " + state);
        }
        return facing;
    }

    public static enum EnumType implements IStringSerializable
    {
        PUBLIC,
        PRIVATE,
        TEAM;


        public String func_176610_l() {
            return this.toString();
        }

        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

