/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.util;

import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import org.apache.commons.lang3.tuple.Pair;
import team.chisel.Chisel;
import team.chisel.api.chunkdata.ChunkData;
import team.chisel.api.chunkdata.IChunkData;
import team.chisel.api.chunkdata.IChunkDataRegistry;
import team.chisel.common.util.NBTSaveable;

public enum PerChunkData implements IChunkDataRegistry
{
    INSTANCE;

    private Map<String, IChunkData<?>> data = Maps.newHashMap();

    private PerChunkData() {
        ChunkData.setOffsetRegistry(this);
    }

    @Override
    public void registerChunkData(String key, IChunkData<?> cd) {
        this.data.put(key, cd);
    }

    @Override
    public <T extends IChunkData<?>> T getData(String key) {
        return (T)this.data.get(key);
    }

    @SubscribeEvent
    public void onChunkSave(ChunkDataEvent.Save event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            e.getValue().writeToNBT(event.getChunk(), tag);
            event.getData().func_74782_a("chisel:" + e.getKey(), (NBTBase)tag);
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkDataEvent.Load event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            NBTTagCompound tag = event.getData().func_74775_l("chisel:" + e.getKey());
            e.getValue().readFromNBT(event.getChunk(), tag);
            this.updateClient(event.getChunk(), e.getKey(), e.getValue());
        }
    }

    @SubscribeEvent
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        for (Map.Entry<String, IChunkData<?>> e : this.data.entrySet()) {
            if (!e.getValue().requiresClientSync()) continue;
            Chisel.network.sendTo((IMessage)new MessageChunkData(e.getKey(), e.getValue()), (EntityPlayerMP)event.player);
        }
    }

    public void chunkModified(Chunk chunk, String key) {
        IChunkData<?> cd = this.data.get(key);
        chunk.func_177427_f(true);
        this.updateClient(chunk, key, cd);
    }

    private void updateClient(@Nonnull Chunk chunk, String key, IChunkData<?> cd) {
        if (cd.requiresClientSync()) {
            NBTTagCompound tag = new NBTTagCompound();
            cd.writeToNBT(chunk, tag);
            PlayerChunkMapEntry entry = ((WorldServer)chunk.func_177412_p()).func_184164_w().func_187301_b(chunk.field_76635_g, chunk.field_76647_h);
            if (entry != null) {
                entry.func_187267_a(Chisel.network.getPacketFrom((IMessage)new MessageChunkData(chunk, key, tag)));
            }
        }
    }

    public static class ChunkDataBase<T extends NBTSaveable>
    implements IChunkData<T> {
        protected final Map<Pair<Integer, ChunkPos>, T> data = new HashMap<Pair<Integer, ChunkPos>, T>();
        protected final Class<? extends T> clazz;
        private final boolean needsClientSync;

        public ChunkDataBase(Class<? extends T> clazz, boolean needsClientSync) {
            this.clazz = clazz;
            this.needsClientSync = needsClientSync;
        }

        @Override
        public NBTTagList writeToNBT() {
            NBTTagList tags = new NBTTagList();
            for (Map.Entry<Pair<Integer, ChunkPos>, T> e : this.data.entrySet()) {
                NBTTagCompound entry = new NBTTagCompound();
                entry.func_74768_a("d", ((Integer)e.getKey().getLeft()).intValue());
                entry.func_74772_a("p", (long)(((ChunkPos)e.getKey().getRight()).field_77276_a << 32 | ((ChunkPos)e.getKey().getRight()).field_77275_b));
                NBTTagCompound data = new NBTTagCompound();
                ((NBTSaveable)e.getValue()).write(data);
                entry.func_74782_a("v", (NBTBase)data);
                tags.func_74742_a((NBTBase)entry);
            }
            return tags;
        }

        @Override
        public void writeToNBT(@Nonnull Chunk chunk, @Nonnull NBTTagCompound tag) {
            NBTSaveable t = (NBTSaveable)this.data.get(Pair.of((Object)chunk.func_177412_p().field_73011_w.getDimension(), (Object)chunk.func_76632_l()));
            if (t != null) {
                t.write(tag);
            }
        }

        @Override
        public Iterable<ChunkPos> readFromNBT(@Nonnull NBTTagList tags) {
            ArrayList<ChunkPos> changed = new ArrayList<ChunkPos>();
            for (int i = 0; i < tags.func_74745_c(); ++i) {
                long coordsRaw;
                ChunkPos coords;
                NBTTagCompound entry = tags.func_150305_b(i);
                int dimID = entry.func_74762_e("d");
                if (!this.readFromNBT(dimID, coords = new ChunkPos((int)((coordsRaw = entry.func_74763_f("p")) >>> 32 & 0xFFFFFFFFFFFFFFFFL), (int)(coordsRaw & 0xFFFFFFFFFFFFFFFFL)), entry.func_74775_l("v"))) continue;
                changed.add(coords);
            }
            return changed;
        }

        @Override
        public void readFromNBT(@Nonnull Chunk chunk, @Nonnull NBTTagCompound tag) {
            int dimID = chunk.func_177412_p().field_73011_w.getDimension();
            ChunkPos coords = chunk.func_76632_l();
            this.readFromNBT(dimID, coords, tag);
        }

        private boolean readFromNBT(int dimID, ChunkPos coords, NBTTagCompound tag) {
            if (tag.func_82582_d()) {
                this.data.remove(dimID, coords);
                return false;
            }
            T t = this.getOrCreateNew(dimID, coords);
            t.read(tag);
            return true;
        }

        protected T getOrCreateNew(int dimID, @Nonnull ChunkPos coords) {
            Pair pair = Pair.of((Object)dimID, (Object)coords);
            NBTSaveable t = (NBTSaveable)this.data.get(pair);
            if (t == null) {
                try {
                    t = (NBTSaveable)this.clazz.newInstance();
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not instantiate NBTSaveable " + this.clazz.getName() + "!", e);
                }
            }
            this.data.put((Pair<Integer, ChunkPos>)pair, t);
            return (T)t;
        }

        @Override
        public boolean requiresClientSync() {
            return this.needsClientSync && !this.data.isEmpty();
        }

        @Override
        public T getDataForChunk(int dimID, @Nonnull ChunkPos coords) {
            return this.getOrCreateNew(dimID, coords);
        }
    }

    public static class MessageChunkDataHandler
    implements IMessageHandler<MessageChunkData, IMessage> {
        public IMessage onMessage(final MessageChunkData message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(new Runnable(){

                @Override
                public void run() {
                    Chunk chunk = null;
                    if (message.chunk != null) {
                        chunk = Chisel.proxy.getClientWorld().func_72964_e(((MessageChunkData)message).chunk.field_77276_a, ((MessageChunkData)message).chunk.field_77275_b);
                    }
                    IChunkData data = (IChunkData)INSTANCE.data.get(message.key);
                    if (chunk != null) {
                        data.readFromNBT(chunk, message.tag);
                        int x = chunk.field_76635_g << 4;
                        int z = chunk.field_76647_h << 4;
                        Chisel.proxy.getClientWorld().func_147458_c(x, 0, z, x, 255, z);
                    } else {
                        for (ChunkPos pos : data.readFromNBT(message.tag.func_150295_c("l", 10))) {
                            Chisel.proxy.getClientWorld().func_147458_c(pos.field_77276_a, 0, pos.field_77275_b, pos.field_77276_a, 255, pos.field_77275_b);
                        }
                    }
                }
            });
            return null;
        }
    }

    public static class MessageChunkData
    implements IMessage {
        private ChunkPos chunk;
        private String key;
        @Nonnull
        private NBTTagCompound tag;

        public MessageChunkData() {
        }

        public MessageChunkData(Chunk chunk, String key, @Nonnull NBTTagCompound tag) {
            this.chunk = chunk.func_76632_l();
            this.key = key;
            this.tag = tag;
        }

        public MessageChunkData(String key, IChunkData<?> iChunkData) {
            this.chunk = null;
            this.key = key;
            this.tag = new NBTTagCompound();
            this.tag.func_74782_a("l", (NBTBase)iChunkData.writeToNBT());
        }

        public void toBytes(ByteBuf buf) {
            if (this.chunk == null) {
                buf.writeBoolean(false);
            } else {
                buf.writeBoolean(true);
                buf.writeInt(this.chunk.field_77276_a);
                buf.writeInt(this.chunk.field_77275_b);
            }
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.key);
            ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.tag);
        }

        public void fromBytes(ByteBuf buf) {
            if (buf.readBoolean()) {
                this.chunk = new ChunkPos(buf.readInt(), buf.readInt());
            }
            this.key = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.tag = ByteBufUtils.readTag((ByteBuf)buf);
        }
    }
}

