/*
 * Decompiled with CFR 0.152.
 */
package team.chisel.common.item;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import team.chisel.api.IChiselItem;
import team.chisel.api.carving.CarvingUtils;
import team.chisel.api.carving.IChiselMode;
import team.chisel.common.item.ChiselMode;
import team.chisel.common.util.NBTUtil;

public class PacketChiselMode
implements IMessage {
    private int slot;
    @Nonnull
    private IChiselMode mode;

    public PacketChiselMode(int slot, @Nonnull IChiselMode mode) {
        this.slot = slot;
        this.mode = mode;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.slot);
        ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.mode.name());
    }

    public void fromBytes(ByteBuf buf) {
        this.slot = buf.readInt();
        this.mode = CarvingUtils.getModeRegistry().getModeByName(ByteBufUtils.readUTF8String((ByteBuf)buf));
        if (this.mode == null) {
            this.mode = ChiselMode.SINGLE;
        }
    }

    public PacketChiselMode() {
    }

    public static class Handler
    implements IMessageHandler<PacketChiselMode, IMessage> {
        public IMessage onMessage(PacketChiselMode message, MessageContext ctx) {
            ctx.getServerHandler().field_147369_b.func_184102_h().func_152344_a(() -> {
                ItemStack stack = ctx.getServerHandler().field_147369_b.field_71071_by.func_70301_a(message.slot);
                if (stack.func_77973_b() instanceof IChiselItem && ((IChiselItem)stack.func_77973_b()).supportsMode((EntityPlayer)ctx.getServerHandler().field_147369_b, stack, message.mode)) {
                    NBTUtil.setChiselMode(stack, message.mode);
                }
            });
            return null;
        }
    }
}

