/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui.ingredients;

import java.awt.Color;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.Internal;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IGuiIngredient;
import mezz.jei.api.gui.ITooltipCallback;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.gui.TooltipRenderer;
import mezz.jei.gui.ingredients.CycleTimer;
import mezz.jei.ingredients.IngredientFilter;
import mezz.jei.ingredients.IngredientRegistry;
import mezz.jei.startup.ForgeModIdHelper;
import mezz.jei.util.ErrorUtil;
import mezz.jei.util.Log;
import mezz.jei.util.Translator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class GuiIngredient<T>
extends Gui
implements IGuiIngredient<T> {
    private static final String oreDictionaryIngredient = Translator.translateToLocal("jei.tooltip.recipe.ore.dict");
    private final int slotIndex;
    private final boolean input;
    private final Rectangle rect;
    private final int xPadding;
    private final int yPadding;
    private final CycleTimer cycleTimer;
    private final List<T> displayIngredients = new ArrayList<T>();
    private final List<T> allIngredients = new ArrayList<T>();
    private final IIngredientRenderer<T> ingredientRenderer;
    private final IIngredientHelper<T> ingredientHelper;
    @Nullable
    private ITooltipCallback<T> tooltipCallback;
    @Nullable
    private IDrawable background;
    private boolean enabled;

    public GuiIngredient(int slotIndex, boolean input, IIngredientRenderer<T> ingredientRenderer, IIngredientHelper<T> ingredientHelper, Rectangle rect, int xPadding, int yPadding, int cycleOffset) {
        this.ingredientRenderer = ingredientRenderer;
        this.ingredientHelper = ingredientHelper;
        this.slotIndex = slotIndex;
        this.input = input;
        this.rect = rect;
        this.xPadding = xPadding;
        this.yPadding = yPadding;
        this.cycleTimer = new CycleTimer(cycleOffset);
    }

    public Rectangle getRect() {
        return this.rect;
    }

    public boolean isMouseOver(int xOffset, int yOffset, int mouseX, int mouseY) {
        return this.enabled && mouseX >= xOffset + this.rect.x && mouseY >= yOffset + this.rect.y && mouseX < xOffset + this.rect.x + this.rect.width && mouseY < yOffset + this.rect.y + this.rect.height;
    }

    @Override
    @Nullable
    public T getDisplayedIngredient() {
        return this.cycleTimer.getCycledItem(this.displayIngredients);
    }

    @Override
    public List<T> getAllIngredients() {
        return this.allIngredients;
    }

    public void set(@Nullable List<T> ingredients, @Nullable IFocus<T> focus) {
        this.displayIngredients.clear();
        this.allIngredients.clear();
        List displayIngredients = ingredients == null ? Collections.emptyList() : this.ingredientHelper.expandSubtypes(ingredients);
        Object match = this.getMatch(displayIngredients, focus);
        if (match != null) {
            this.displayIngredients.add(match);
        } else {
            displayIngredients = this.filterOutHidden(displayIngredients);
            this.displayIngredients.addAll(displayIngredients);
        }
        if (ingredients != null) {
            this.allIngredients.addAll(ingredients);
        }
        this.enabled = !this.displayIngredients.isEmpty();
    }

    private List<T> filterOutHidden(List<T> ingredients) {
        if (ingredients.isEmpty()) {
            return ingredients;
        }
        IngredientRegistry ingredientRegistry = Internal.getIngredientRegistry();
        IngredientFilter ingredientFilter = Internal.getIngredientFilter();
        ArrayList<T> visible = new ArrayList<T>();
        for (T ingredient : ingredients) {
            if (ingredient == null || ingredientRegistry.isIngredientVisible(ingredient, ingredientFilter)) {
                visible.add(ingredient);
            }
            if (visible.size() <= 100) continue;
            return visible;
        }
        if (visible.size() > 0) {
            return visible;
        }
        return ingredients;
    }

    public void setBackground(IDrawable background) {
        this.background = background;
    }

    @Nullable
    private T getMatch(Collection<T> ingredients, @Nullable IFocus<T> focus) {
        if (focus != null && this.isMode(focus.getMode())) {
            T focusValue = focus.getValue();
            return this.ingredientHelper.getMatch(ingredients, focusValue);
        }
        return null;
    }

    public void setTooltipCallback(@Nullable ITooltipCallback<T> tooltipCallback) {
        this.tooltipCallback = tooltipCallback;
    }

    public void draw(Minecraft minecraft, int xOffset, int yOffset) {
        this.cycleTimer.onDraw();
        if (this.background != null) {
            this.background.draw(minecraft, xOffset + this.rect.x, yOffset + this.rect.y);
        }
        T value = this.getDisplayedIngredient();
        try {
            this.ingredientRenderer.render(minecraft, xOffset + this.rect.x + this.xPadding, yOffset + this.rect.y + this.yPadding, value);
        }
        catch (LinkageError | RuntimeException e) {
            if (value != null) {
                throw ErrorUtil.createRenderIngredientException(e, value);
            }
            throw e;
        }
    }

    @Override
    public void drawHighlight(Minecraft minecraft, Color color, int xOffset, int yOffset) {
        int x = this.rect.x + xOffset + this.xPadding;
        int y = this.rect.y + yOffset + this.yPadding;
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GuiIngredient.func_73734_a((int)x, (int)y, (int)(x + this.rect.width - this.xPadding * 2), (int)(y + this.rect.height - this.yPadding * 2), (int)color.getRGB());
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public void drawOverlays(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY) {
        T value = this.getDisplayedIngredient();
        if (value != null) {
            this.drawTooltip(minecraft, xOffset, yOffset, mouseX, mouseY, value);
        }
    }

    private void drawTooltip(Minecraft minecraft, int xOffset, int yOffset, int mouseX, int mouseY, T value) {
        try {
            GlStateManager.func_179097_i();
            RenderHelper.func_74518_a();
            GuiIngredient.func_73734_a((int)(xOffset + this.rect.x + this.xPadding), (int)(yOffset + this.rect.y + this.yPadding), (int)(xOffset + this.rect.x + this.rect.width - this.xPadding), (int)(yOffset + this.rect.y + this.rect.height - this.yPadding), (int)Integer.MAX_VALUE);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ITooltipFlag.TooltipFlags tooltipFlag = minecraft.field_71474_y.field_82882_x ? ITooltipFlag.TooltipFlags.ADVANCED : ITooltipFlag.TooltipFlags.NORMAL;
            List<String> tooltip = this.ingredientRenderer.getTooltip(minecraft, value, (ITooltipFlag)tooltipFlag);
            tooltip = ForgeModIdHelper.getInstance().addModNameToIngredientTooltip(tooltip, value, this.ingredientHelper);
            if (this.tooltipCallback != null) {
                this.tooltipCallback.onTooltip(this.slotIndex, this.input, value, tooltip);
            }
            FontRenderer fontRenderer = this.ingredientRenderer.getFontRenderer(minecraft, value);
            if (value instanceof ItemStack) {
                List<ItemStack> itemStacks = this.allIngredients;
                String oreDictEquivalent = Internal.getStackHelper().getOreDictEquivalent(itemStacks);
                if (oreDictEquivalent != null) {
                    String acceptsAny = String.format(oreDictionaryIngredient, oreDictEquivalent);
                    tooltip.add(TextFormatting.GRAY + acceptsAny);
                }
                TooltipRenderer.drawHoveringText((ItemStack)value, minecraft, tooltip, xOffset + mouseX, yOffset + mouseY, fontRenderer);
            } else {
                TooltipRenderer.drawHoveringText(minecraft, tooltip, xOffset + mouseX, yOffset + mouseY, fontRenderer);
            }
            GlStateManager.func_179126_j();
        }
        catch (RuntimeException e) {
            Log.get().error("Exception when rendering tooltip on {}.", value, (Object)e);
        }
    }

    @Override
    public boolean isInput() {
        return this.input;
    }

    public boolean isMode(IFocus.Mode mode) {
        return this.input && mode == IFocus.Mode.INPUT || !this.input && mode == IFocus.Mode.OUTPUT;
    }
}

