/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.gui;

import java.awt.Color;
import java.awt.Rectangle;
import mezz.jei.Internal;
import mezz.jei.gui.GuiHelper;
import mezz.jei.gui.elements.GuiIconButton;
import mezz.jei.input.IPaged;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;

public class PageNavigation {
    private final IPaged paged;
    private final GuiButton nextButton;
    private final GuiButton backButton;
    private final boolean hideOnSinglePage;
    private String pageNumDisplayString = "1/1";
    private int pageNumDisplayX;
    private int pageNumDisplayY;

    public PageNavigation(IPaged paged, boolean hideOnSinglePage) {
        this.paged = paged;
        GuiHelper guiHelper = Internal.getHelpers().getGuiHelper();
        this.nextButton = new GuiIconButton(0, guiHelper.getArrowNext(), (mc, mouseX, mouseY) -> paged.nextPage());
        this.backButton = new GuiIconButton(1, guiHelper.getArrowPrevious(), (mc, mouseX, mouseY) -> paged.previousPage());
        this.hideOnSinglePage = hideOnSinglePage;
    }

    public void updateBounds(Rectangle area) {
        int buttonSize = area.height;
        this.nextButton.field_146128_h = area.x + area.width - buttonSize;
        this.nextButton.field_146129_i = area.y;
        this.nextButton.field_146120_f = this.nextButton.field_146121_g = buttonSize;
        this.backButton.field_146128_h = area.x;
        this.backButton.field_146129_i = area.y;
        this.backButton.field_146120_f = this.backButton.field_146121_g = buttonSize;
    }

    public void updatePageState() {
        int pageNum = this.paged.getPageNumber();
        int pageCount = this.paged.getPageCount();
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        this.pageNumDisplayString = pageNum + 1 + "/" + pageCount;
        int pageDisplayWidth = fontRenderer.func_78256_a(this.pageNumDisplayString);
        this.pageNumDisplayX = (this.backButton.field_146128_h + this.backButton.field_146120_f + this.nextButton.field_146128_h) / 2 - pageDisplayWidth / 2;
        this.pageNumDisplayY = this.backButton.field_146129_i + Math.round((float)(this.backButton.field_146121_g - fontRenderer.field_78288_b) / 2.0f);
    }

    public void draw(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (!this.hideOnSinglePage || this.paged.hasNext() || this.paged.hasPrevious()) {
            minecraft.field_71466_p.func_175065_a(this.pageNumDisplayString, (float)this.pageNumDisplayX, (float)this.pageNumDisplayY, Color.white.getRGB(), true);
            this.nextButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
            this.backButton.func_191745_a(minecraft, mouseX, mouseY, partialTicks);
        }
    }

    public boolean isMouseOver() {
        return this.nextButton.func_146115_a() || this.backButton.func_146115_a();
    }

    public boolean handleMouseClickedButtons(int mouseX, int mouseY) {
        Minecraft minecraft = Minecraft.func_71410_x();
        return this.nextButton.func_146116_c(minecraft, mouseX, mouseY) || this.backButton.func_146116_c(minecraft, mouseX, mouseY);
    }
}

