/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gate;

import buildcraft.api.core.BCLog;
import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.InvalidInputDataException;
import buildcraft.api.statements.IAction;
import buildcraft.api.statements.IActionInternal;
import buildcraft.api.statements.IStatement;
import buildcraft.api.statements.StatementManager;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.ActionWrapper;
import buildcraft.lib.statement.StatementType;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;

public class ActionType
extends StatementType<ActionWrapper> {
    public static final ActionType INSTANCE = new ActionType();

    private ActionType() {
        super(ActionWrapper.class, null);
    }

    @Override
    public ActionWrapper convertToType(Object value) {
        if (value instanceof IActionInternal) {
            return new ActionWrapper.ActionWrapperInternal((IActionInternal)value);
        }
        return null;
    }

    @Override
    public ActionWrapper readFromNbt(NBTTagCompound nbt) {
        if (nbt == null) {
            return null;
        }
        String kind = nbt.func_74779_i("kind");
        if (kind == null || kind.isEmpty()) {
            return null;
        }
        EnumPipePart side = EnumPipePart.fromMeta(nbt.func_74771_c("side"));
        IStatement statement = StatementManager.statements.get(kind);
        if (statement instanceof IAction) {
            return ActionWrapper.wrap(statement, side.face);
        }
        BCLog.logger.warn("[gate.trigger] Couldn't find an action called '{}'! (found {})", (Object)kind, (Object)statement);
        return null;
    }

    @Override
    public NBTTagCompound writeToNbt(ActionWrapper slot) {
        NBTTagCompound nbt = new NBTTagCompound();
        if (slot == null) {
            return nbt;
        }
        nbt.func_74778_a("kind", slot.getUniqueTag());
        nbt.func_74774_a("side", (byte)slot.sourcePart.getIndex());
        return nbt;
    }

    @Override
    public ActionWrapper readFromBuffer(PacketBufferBC buffer) throws IOException {
        if (buffer.readBoolean()) {
            String name = buffer.readString();
            EnumPipePart part = buffer.func_179257_a(EnumPipePart.class);
            IStatement statement = StatementManager.statements.get(name);
            if (statement instanceof IAction) {
                return ActionWrapper.wrap(statement, part.face);
            }
            throw new InvalidInputDataException("Unknown action '" + name + "'");
        }
        return null;
    }

    @Override
    public void writeToBuffer(PacketBufferBC buffer, ActionWrapper slot) {
        if (slot == null) {
            buffer.writeBoolean(false);
        } else {
            buffer.writeBoolean(true);
            buffer.func_180714_a(slot.getUniqueTag());
            buffer.writeEnumValue(slot.sourcePart);
        }
    }
}

