/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;

public class MatrixUtil {
    private static final Map<EnumFacing, Matrix4f> rotationMap;

    public static Matrix4f rotateTowardsFace(EnumFacing face) {
        return new Matrix4f(rotationMap.get(face));
    }

    public static Matrix4f rotateTowardsFace(EnumFacing from, EnumFacing to) {
        Matrix4f fromMatrix = new Matrix4f(MatrixUtil.rotateTowardsFace(from));
        fromMatrix.invert();
        Matrix4f toMatrix = MatrixUtil.rotateTowardsFace(to);
        Matrix4f result = new Matrix4f(toMatrix);
        result.mul(fromMatrix);
        return result;
    }

    public static AxisAlignedBB multiply(AxisAlignedBB box, Matrix4f matrix) {
        Point3f min = new Point3f(new Point3d(box.field_72340_a, box.field_72338_b, box.field_72339_c));
        Point3f max = new Point3f(new Point3d(box.field_72336_d, box.field_72337_e, box.field_72334_f));
        matrix.transform(min);
        matrix.transform(max);
        return new AxisAlignedBB((double)min.x, (double)min.y, (double)min.z, (double)max.x, (double)max.y, (double)max.z);
    }

    public static AxisAlignedBB[] multiplyAll(AxisAlignedBB[] boxes, Matrix4f matrix) {
        AxisAlignedBB[] result = new AxisAlignedBB[boxes.length];
        for (int i = 0; i < boxes.length; ++i) {
            result[i] = MatrixUtil.multiply(boxes[i], matrix);
        }
        return result;
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (EnumFacing face : EnumFacing.field_82609_l) {
            Matrix4f mat = new Matrix4f();
            mat.setIdentity();
            if (face == EnumFacing.WEST) {
                builder.put((Object)face, (Object)mat);
                continue;
            }
            mat.setTranslation(new Vector3f(0.5f, 0.5f, 0.5f));
            Matrix4f m2 = new Matrix4f();
            m2.setIdentity();
            if (face.func_176740_k() == EnumFacing.Axis.Y) {
                AxisAngle4f axisAngle = new AxisAngle4f(0.0f, 0.0f, 1.0f, 1.5707964f * (float)(-face.func_96559_d()));
                m2.setRotation(axisAngle);
                mat.mul(m2);
                m2.setIdentity();
                m2.setRotation(new AxisAngle4f(1.0f, 0.0f, 0.0f, (float)Math.PI * (1.0f + (float)face.func_96559_d() * 0.5f)));
                mat.mul(m2);
            } else {
                int ang = face == EnumFacing.EAST ? 2 : (face == EnumFacing.NORTH ? 3 : 1);
                AxisAngle4f axisAngle = new AxisAngle4f(0.0f, 1.0f, 0.0f, 1.5707964f * (float)ang);
                m2.setRotation(axisAngle);
                mat.mul(m2);
            }
            m2.setIdentity();
            m2.setTranslation(new Vector3f(-0.5f, -0.5f, -0.5f));
            mat.mul(m2);
            builder.put((Object)face, (Object)mat);
        }
        rotationMap = builder.build();
    }
}

