/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory.filter;

import buildcraft.api.core.IStackFilter;
import buildcraft.api.recipes.StackDefinition;
import buildcraft.lib.misc.StackUtil;
import java.util.Arrays;
import java.util.Collection;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.oredict.OreDictionary;

public class OreStackFilter
implements IStackFilter {
    private final String[] ores;

    public OreStackFilter(String ... iOres) {
        this.ores = iOres;
    }

    @Override
    public boolean matches(@Nonnull ItemStack stack) {
        int[] ids = OreDictionary.getOreIDs((ItemStack)stack);
        if (ids.length == 0) {
            return false;
        }
        for (String ore : this.ores) {
            int expected = OreDictionary.getOreID((String)ore);
            for (int id : ids) {
                if (id != expected) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public NonNullList<ItemStack> getExamples() {
        return Arrays.stream(this.ores).map(OreDictionary::getOres).flatMap(Collection::stream).distinct().collect(StackUtil.nonNullListCollector());
    }

    public static StackDefinition definition(int count, String ... ores) {
        return new StackDefinition(new OreStackFilter(ores), count);
    }

    public static StackDefinition definition(String ... ores) {
        return OreStackFilter.definition(1, ores);
    }
}

