/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.statement;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.render.ISprite;
import buildcraft.api.statements.IGuiSlot;
import buildcraft.api.statements.IStatementParameter;
import buildcraft.lib.gui.BuildCraftGui;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.IMenuElement;
import buildcraft.lib.gui.statement.GuiElementStatement;
import buildcraft.lib.gui.statement.ParameterRenderer;
import buildcraft.lib.misc.data.IReference;
import buildcraft.lib.statement.StatementWrapper;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GlStateManager;

public class GuiElementStatementDrag
implements IMenuElement {
    public final BuildCraftGui gui;
    private boolean isDragging;
    @Nullable
    private IGuiSlot dragging;

    public GuiElementStatementDrag(BuildCraftGui gui) {
        this.gui = gui;
    }

    public void startDragging(IGuiSlot slot) {
        this.isDragging = true;
        this.dragging = slot;
        this.gui.currentMenu = this;
    }

    @Override
    public double getX() {
        return 0.0;
    }

    @Override
    public double getY() {
        return 0.0;
    }

    @Override
    public double getWidth() {
        return 0.0;
    }

    @Override
    public double getHeight() {
        return 0.0;
    }

    @Override
    public void drawForeground(float partialTicks) {
        if (this.isDragging) {
            boolean canPlace = false;
            for (IGuiElement element : this.gui.getElementsAt(this.gui.mouse.getX(), this.gui.mouse.getY())) {
                if (!(element instanceof IReference) || !GuiElementStatementDrag.checkCanSet((IReference)((Object)element), this.dragging)) continue;
                canPlace = true;
                break;
            }
            GlStateManager.func_179086_m((int)256);
            if (!canPlace) {
                GlStateManager.func_179124_c((float)1.0f, (float)0.7f, (float)0.7f);
            }
            double x = this.gui.mouse.getX() - 9.0;
            double y = this.gui.mouse.getY() - 9.0;
            if (this.dragging instanceof IStatementParameter) {
                ParameterRenderer.draw((IStatementParameter)this.dragging, x, y);
            } else {
                ISprite sprite;
                EnumPipePart part;
                GuiIcon background = GuiElementStatement.SLOT_COLOUR;
                if (this.dragging instanceof StatementWrapper && (part = ((StatementWrapper)this.dragging).sourcePart) != EnumPipePart.CENTER) {
                    background = background.offset(0.0, (1 + part.getIndex()) * 18);
                }
                background.drawAt(x, y);
                if (this.dragging != null && (sprite = this.dragging.getSprite()) != null) {
                    GuiIcon.drawAt(sprite, x + 1.0, y + 1.0, 16.0);
                }
            }
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    private static <T> boolean checkCanSet(IReference<T> ref, Object value) {
        if (value == null) {
            return ref.canSet(null);
        }
        T obj = ref.convertToType(value);
        return obj != null && ref.canSet(obj);
    }

    @Override
    public void onMouseClicked(int button) {
        if (button != 1) {
            return;
        }
        for (IGuiElement element : this.gui.getElementsAt(this.gui.mouse.getX(), this.gui.mouse.getY())) {
            IReference ref;
            Object obj;
            if (!(element instanceof IReference) || (obj = (ref = (IReference)((Object)element)).get()) != null && !(obj instanceof IGuiSlot)) continue;
            this.startDragging((IGuiSlot)obj);
            break;
        }
    }

    @Override
    public void onMouseReleased(int button) {
        if (!this.isDragging) {
            return;
        }
        for (IGuiElement element : this.gui.getElementsAt(this.gui.mouse.getX(), this.gui.mouse.getY())) {
            if (!(element instanceof IReference)) continue;
            IReference ref = (IReference)((Object)element);
            ref.setIfCan(this.dragging);
        }
        this.isDragging = false;
        this.dragging = null;
        if (this.gui.currentMenu == this) {
            this.gui.currentMenu = null;
        }
    }

    @Override
    public boolean shouldFullyOverride() {
        return false;
    }
}

