/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.json;

import buildcraft.lib.expression.FunctionContext;
import buildcraft.lib.gui.IGuiElement;
import buildcraft.lib.gui.json.BuildCraftJsonGui;
import buildcraft.lib.gui.json.ElementType;
import buildcraft.lib.gui.json.JsonGuiElement;
import buildcraft.lib.gui.json.JsonGuiInfo;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.statement.GuiElementStatement;
import buildcraft.lib.statement.FullStatement;
import buildcraft.lib.statement.StatementContext;
import com.google.gson.JsonSyntaxException;

public class ElementTypeStatementSlot
extends ElementType {
    public static final String NAME = "buildcraftlib:statement/slot";
    public static final ElementTypeStatementSlot INSTANCE = new ElementTypeStatementSlot();

    private ElementTypeStatementSlot() {
        super(NAME);
    }

    @Override
    public IGuiElement deserialize0(BuildCraftJsonGui gui, IGuiPosition parent, JsonGuiInfo info, JsonGuiElement json) {
        String source;
        FunctionContext ctx = ElementTypeStatementSlot.createContext(json);
        if (!json.properties.containsKey("size[0]")) {
            json.properties.put("size[0]", "18");
        }
        if (!json.properties.containsKey("size[1]")) {
            json.properties.put("size[1]", "18");
        }
        ElementTypeStatementSlot.inheritProperty(json, "pos[0]", "area[0]");
        ElementTypeStatementSlot.inheritProperty(json, "pos[1]", "area[1]");
        ElementTypeStatementSlot.inheritProperty(json, "size[0]", "area[2]");
        ElementTypeStatementSlot.inheritProperty(json, "size[1]", "area[3]");
        IGuiArea area = ElementTypeStatementSlot.resolveArea(json, "area", parent, ctx);
        if (json.properties.containsKey("source")) {
            source = json.properties.get("source");
        } else {
            source = ElementTypeStatementSlot.resolveEquation(json, "source_expression", ctx);
            if (source == null) {
                throw new JsonSyntaxException("Expected either 'source' or 'source_expression' for buildcraftlib:statement/slot");
            }
        }
        boolean draw = !"false".equals(json.properties.get("draw"));
        FullStatement fullStatement = gui.properties.get(source, FullStatement.class);
        if (fullStatement == null) {
            throw new JsonSyntaxException("Can't find a statement called '" + source + "'");
        }
        StatementContext context = gui.properties.get(source, StatementContext.class);
        return new GuiElementStatement(gui, area, fullStatement, context, draw);
    }
}

