/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.contents;

import buildcraft.lib.client.guide.PageLine;
import buildcraft.lib.client.guide.entry.ItemStackValueFilter;
import buildcraft.lib.client.guide.entry.PageEntryItemStack;
import buildcraft.lib.client.guide.entry.PageValue;
import buildcraft.lib.client.guide.parts.GuidePage;
import buildcraft.lib.client.guide.parts.GuidePageFactory;
import buildcraft.lib.client.guide.parts.GuidePart;
import buildcraft.lib.client.guide.parts.contents.PageLink;
import buildcraft.lib.client.guide.parts.contents.PageLinkItemStack;
import buildcraft.lib.misc.ItemStackKey;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.profiler.Profiler;
import net.minecraft.util.NonNullList;

public final class PageLinkItemPermutations
extends PageLink {
    private final List<ItemStack> permutations;

    private PageLinkItemPermutations(PageLine text, boolean startVisible, List<ItemStack> permutations) {
        super(text, startVisible);
        this.permutations = permutations;
    }

    @Override
    public GuidePageFactory getFactoryLink() {
        return gui -> {
            ArrayList<GuidePart> parts = new ArrayList<GuidePart>();
            Profiler prof = new Profiler();
            prof.field_76327_a = true;
            for (ItemStack stack : this.permutations) {
                parts.add(PageLinkItemStack.create(true, stack, prof).createGuidePart(gui));
            }
            ItemStackValueFilter filter = new ItemStackValueFilter(new ItemStackKey(this.permutations.get(0)), false, false);
            return new GuidePage(gui, parts, new PageValue<ItemStackValueFilter>(PageEntryItemStack.INSTANCE, filter));
        };
    }

    public static PageLinkItemPermutations create(boolean startVisible, NonNullList<ItemStack> stacks, Profiler prof) {
        PageLinkItemStack link = PageLinkItemStack.create(startVisible, (ItemStack)stacks.get(0), prof);
        return new PageLinkItemPermutations(link.text, startVisible, (List<ItemStack>)stacks);
    }
}

