/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.api.schematics.SchematicBlockContext;
import buildcraft.api.schematics.SchematicBlockFactoryRegistry;
import buildcraft.api.schematics.SchematicEntityFactoryRegistry;
import buildcraft.builders.snapshot.SchematicBlockAir;
import buildcraft.builders.snapshot.SchematicBlockDefault;
import buildcraft.builders.snapshot.SchematicBlockFluid;
import buildcraft.builders.snapshot.SchematicEntityDefault;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockBanner;
import net.minecraft.block.BlockVine;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemBanner;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BCBuildersSchematics {
    public static void preInit() {
        BCBuildersSchematics.registerSchematicFactory("air", 0, SchematicBlockAir::predicate, SchematicBlockAir::new);
        BCBuildersSchematics.registerSchematicFactory("default", 100, SchematicBlockDefault::predicate, SchematicBlockDefault::new);
        BCBuildersSchematics.registerSchematicFactory("fluid", 200, SchematicBlockFluid::predicate, SchematicBlockFluid::new);
        BCBuildersSchematics.registerSchematicFactory("banner", 300, c -> c.block instanceof BlockBanner, BCBuildersSchematics::getBanner);
        BCBuildersSchematics.registerSchematicFactory("vine", 300, c -> c.block instanceof BlockVine, BCBuildersSchematics::getVine);
        SchematicEntityFactoryRegistry.registerFactory("default", 100, SchematicEntityDefault::predicate, SchematicEntityDefault::new);
    }

    private static <S extends ISchematicBlock> void registerSchematicFactory(String name, int priority, Predicate<SchematicBlockContext> predicate, Supplier<S> supplier) {
        SchematicBlockFactoryRegistry.registerFactory(name, priority, predicate, supplier);
    }

    private static SchematicBlockDefault getBanner() {
        return new SchematicBlockDefault(){

            @Override
            @Nonnull
            public List<ItemStack> computeRequiredItems() {
                return Collections.singletonList(ItemBanner.func_190910_a((EnumDyeColor)EnumDyeColor.func_176766_a((int)this.tileNbt.func_74762_e("Base")), (NBTTagList)this.tileNbt.func_150295_c("Patterns", 10)));
            }
        };
    }

    private static SchematicBlockDefault getVine() {
        return new SchematicBlockDefault(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public boolean isReadyToBuild(World world, BlockPos blockPos) {
                if (!super.isReadyToBuild(world, blockPos)) return false;
                if (world.func_180495_p(blockPos.func_177984_a()).func_177230_c() instanceof BlockVine) return true;
                if (!StreamSupport.stream(EnumFacing.Plane.HORIZONTAL.spliterator(), false).map(arg_0 -> ((BlockPos)blockPos).func_177972_a(arg_0)).map(arg_0 -> ((World)world).func_180495_p(arg_0)).anyMatch(state -> state.func_185917_h() && state.func_185904_a().func_76230_c())) return false;
                return true;
            }
        };
    }
}

