/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders;

import buildcraft.api.schematics.ISchematicBlock;
import buildcraft.builders.BCBuildersItems;
import buildcraft.builders.client.ClientArchitectTables;
import buildcraft.builders.item.ItemSchematicSingle;
import buildcraft.builders.snapshot.Blueprint;
import buildcraft.builders.snapshot.ClientSnapshots;
import buildcraft.builders.snapshot.Snapshot;
import buildcraft.builders.tile.TileQuarry;
import java.lang.ref.WeakReference;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.world.GetCollisionBoxesEvent;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public enum BCBuildersEventDist {
    INSTANCE;

    private static final UUID UUID_SINGLE_SCHEMATIC;
    private final Map<World, Deque<WeakReference<TileQuarry>>> allQuarries = new WeakHashMap<World, Deque<WeakReference<TileQuarry>>>();

    public synchronized void validateQuarry(TileQuarry quarry) {
        Deque quarries = this.allQuarries.computeIfAbsent(quarry.func_145831_w(), k -> new LinkedList());
        quarries.add(new WeakReference<TileQuarry>(quarry));
    }

    public synchronized void invalidateQuarry(TileQuarry quarry) {
        Deque<WeakReference<TileQuarry>> quarries = this.allQuarries.get(quarry.func_145831_w());
        if (quarries == null) {
            return;
        }
        Iterator<WeakReference<TileQuarry>> iter = quarries.iterator();
        while (iter.hasNext()) {
            WeakReference<TileQuarry> ref = iter.next();
            TileQuarry pos = (TileQuarry)ref.get();
            if (pos != null && pos != quarry) continue;
            iter.remove();
        }
    }

    @SubscribeEvent
    public synchronized void onGetCollisionBoxesForQuarry(GetCollisionBoxesEvent event) {
        Deque<WeakReference<TileQuarry>> quarries = this.allQuarries.get(event.getWorld());
        if (quarries == null) {
            return;
        }
        Iterator<WeakReference<TileQuarry>> iter = quarries.iterator();
        while (iter.hasNext()) {
            WeakReference<TileQuarry> ref = iter.next();
            TileQuarry quarry = (TileQuarry)ref.get();
            if (quarry == null) {
                iter.remove();
                continue;
            }
            for (AxisAlignedBB aabb : quarry.getCollisionBoxes()) {
                if (!event.getAabb().func_72326_a(aabb)) continue;
                event.getCollisionBoxesList().add(aabb);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onRenderTooltipPostText(RenderTooltipEvent.PostText event) {
        ISchematicBlock schematicBlock;
        Snapshot.Header header;
        Snapshot snapshot = null;
        ItemStack stack = event.getStack();
        Snapshot.Header header2 = header = BCBuildersItems.snapshot != null ? BCBuildersItems.snapshot.getHeader(stack) : null;
        if (header != null) {
            snapshot = ClientSnapshots.INSTANCE.getSnapshot(header.key);
        } else if (BCBuildersItems.schematicSingle != null && (schematicBlock = ItemSchematicSingle.getSchematicSafe(stack)) != null) {
            Blueprint blueprint = new Blueprint();
            blueprint.size = new BlockPos(1, 1, 1);
            blueprint.offset = BlockPos.field_177992_a;
            blueprint.data = new int[]{0};
            blueprint.palette.add(schematicBlock);
            blueprint.computeKey();
            snapshot = blueprint;
        }
        if (snapshot != null) {
            int pX = event.getX();
            int pY = event.getY() + event.getHeight() + 10;
            int sX = 100;
            int sY = 100;
            int zLevel = 300;
            int backgroundColor = -267386864;
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 3), (int)(pY - 4), (int)(pX + sX + 3), (int)(pY - 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 3), (int)(pY + sY + 3), (int)(pX + sX + 3), (int)(pY + sY + 4), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 3), (int)(pY - 3), (int)(pX + sX + 3), (int)(pY + sY + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 4), (int)(pY - 3), (int)(pX - 3), (int)(pY + sY + 3), (int)backgroundColor, (int)backgroundColor);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX + sX + 3), (int)(pY - 3), (int)(pX + sX + 4), (int)(pY + sY + 3), (int)backgroundColor, (int)backgroundColor);
            int borderColorStart = 0x505000FF;
            int borderColorEnd = (borderColorStart & 0xFEFEFE) >> 1 | borderColorStart & 0xFF000000;
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 3), (int)(pY - 3 + 1), (int)(pX - 3 + 1), (int)(pY + sY + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX + sX + 2), (int)(pY - 3 + 1), (int)(pX + sX + 3), (int)(pY + sY + 3 - 1), (int)borderColorStart, (int)borderColorEnd);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 3), (int)(pY - 3), (int)(pX + sX + 3), (int)(pY - 3 + 1), (int)borderColorStart, (int)borderColorStart);
            GuiUtils.drawGradientRect((int)zLevel, (int)(pX - 3), (int)(pY + sY + 2), (int)(pX + sX + 3), (int)(pY + sY + 3), (int)borderColorEnd, (int)borderColorEnd);
            ClientSnapshots.INSTANCE.renderSnapshot(snapshot, pX, pY, sX, sY);
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onTickClientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !Minecraft.func_71410_x().func_147113_T()) {
            ClientArchitectTables.tick();
        }
    }

    static {
        UUID_SINGLE_SCHEMATIC = new UUID(-199411441644031599L, 8588012674694053802L);
    }
}

