/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.api.transport.pipe;

import java.util.Arrays;

public class PipeFaceTex {
    private static final int SINGLE_WHITE_SPRITES_COUNT = 64;
    private static final PipeFaceTex[] SINGLE_WHITE_SPRITES;
    private static final int[] EMPTY_INT_ARRAY;
    public static final PipeFaceTex NO_SPRITE;
    private final int[] textures;
    private final int[] colours;
    private final int hash;

    public static PipeFaceTex get(int[] textures, int ... colours) {
        switch (textures.length) {
            case 0: {
                return NO_SPRITE;
            }
            case 1: {
                if (colours.length == 0 || colours[0] == -1) {
                    return PipeFaceTex.get(textures[0]);
                }
                return new PipeFaceTex(textures, colours);
            }
        }
        return new PipeFaceTex(textures, colours);
    }

    public static PipeFaceTex get(int ... textures) {
        return PipeFaceTex.get(textures, EMPTY_INT_ARRAY);
    }

    public static PipeFaceTex get(int singleTexture) {
        if (singleTexture < 64) {
            return SINGLE_WHITE_SPRITES[singleTexture];
        }
        return new PipeFaceTex(singleTexture);
    }

    private PipeFaceTex(int[] textures, int ... colours) {
        this.textures = textures;
        this.colours = colours;
        int i = 0;
        while (i < colours.length) {
            int n = i++;
            colours[n] = colours[n] & 0xFFFFFF;
        }
        if (textures.length == 0) {
            this.hash = -1;
        } else if (textures.length == 1) {
            this.hash = textures[0] + this.getColour(0) + 1;
        } else {
            int[] cArr = colours;
            int prevLength = cArr.length;
            int count = this.getCount();
            if (prevLength < count) {
                cArr = Arrays.copyOf(cArr, count);
                for (int i2 = prevLength; i2 < count; ++i2) {
                    cArr[i2] = -1;
                }
            }
            this.hash = Arrays.hashCode(cArr) + 31 * Arrays.hashCode(textures);
        }
    }

    private PipeFaceTex(int ... textures) {
        this(textures, EMPTY_INT_ARRAY);
    }

    private PipeFaceTex(int singleTexture) {
        this.textures = new int[]{singleTexture};
        this.colours = EMPTY_INT_ARRAY;
        this.hash = singleTexture;
    }

    public int getCount() {
        return this.textures.length;
    }

    public int getTexture(int index) {
        return this.textures[index];
    }

    public int getColour(int index) {
        if (index >= this.colours.length) {
            return -1;
        }
        return this.colours[index];
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        PipeFaceTex other = (PipeFaceTex)obj;
        if (this.hash != other.hash) {
            return false;
        }
        if (!Arrays.equals(this.textures, other.textures)) {
            return false;
        }
        int i = this.textures.length;
        while (i > 0) {
            if (this.getColour(--i) == other.getColour(i)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.hash;
    }

    public static PipeFaceTex ___testing_create_single(int single) {
        return new PipeFaceTex(single);
    }

    static {
        EMPTY_INT_ARRAY = new int[0];
        NO_SPRITE = new PipeFaceTex(new int[0]);
        SINGLE_WHITE_SPRITES = new PipeFaceTex[64];
        for (int i = 0; i < 64; ++i) {
            PipeFaceTex.SINGLE_WHITE_SPRITES[i] = new PipeFaceTex(i);
        }
    }
}

