/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.multiblock;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.items.ItemRollingStockComponent;
import cam72cam.immersiverailroading.library.GuiTypes;
import cam72cam.immersiverailroading.multiblock.Multiblock;
import cam72cam.immersiverailroading.tile.TileMultiblock;
import cam72cam.mod.entity.Player;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.item.ItemStackHandler;
import cam72cam.mod.math.Rotation;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.sound.StandardSound;
import cam72cam.mod.world.World;

public class SteamHammerMultiblock
extends Multiblock {
    private static Multiblock.FuzzyProvider piston = () -> Fuzzy.PISTON;
    public static final String NAME = "STEAM_HAMMER";
    private static final Vec3i center = new Vec3i(2, 0, 0);
    private static final Vec3i power = new Vec3i(2, 5, 0);

    public SteamHammerMultiblock() {
        super(NAME, new Multiblock.FuzzyProvider[][][]{{{SteamHammerMultiblock.L_ENG(), AIR, SteamHammerMultiblock.STEEL(), AIR, SteamHammerMultiblock.L_ENG()}, {SteamHammerMultiblock.L_ENG(), AIR, AIR, AIR, SteamHammerMultiblock.L_ENG()}, {SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.H_ENG(), SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.L_ENG()}, {AIR, SteamHammerMultiblock.L_ENG(), SteamHammerMultiblock.H_ENG(), SteamHammerMultiblock.L_ENG(), AIR}, {AIR, AIR, piston, AIR, AIR}, {AIR, AIR, SteamHammerMultiblock.H_ENG(), AIR, AIR}}});
    }

    @Override
    public Vec3i placementPos() {
        return new Vec3i(2, 0, 0);
    }

    @Override
    protected Multiblock.MultiblockInstance newInstance(World world, Vec3i origin, Rotation rot) {
        return new SteamHammerInstance(world, origin, rot);
    }

    public class SteamHammerInstance
    extends Multiblock.MultiblockInstance {
        public SteamHammerInstance(World world, Vec3i origin, Rotation rot) {
            super(world, origin, rot);
        }

        @Override
        public boolean onBlockActivated(Player player, Player.Hand hand, Vec3i offset) {
            if (this.isCenter(offset)) {
                if (this.world.isServer) {
                    Vec3i pos = this.getPos(offset);
                    GuiTypes.STEAM_HAMMER.open(player, pos);
                }
                return true;
            }
            return false;
        }

        private boolean isCenter(Vec3i offset) {
            return offset.equals((Object)center);
        }

        @Override
        public boolean isRender(Vec3i offset) {
            return this.isCenter(offset);
        }

        @Override
        public int getInvSize(Vec3i offset) {
            return this.isCenter(offset) ? 2 : 0;
        }

        @Override
        public void tick(Vec3i offset) {
            if (!this.isCenter(offset)) {
                return;
            }
            TileMultiblock te = this.getTile(offset);
            if (te == null) {
                return;
            }
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return;
            }
            if (!this.hasPower()) {
                return;
            }
            if (this.world.isClient) {
                if (te.getRenderTicks() % 10L == 0L && te.getCraftProgress() != 0) {
                    Audio.playSound((World)this.world, (Vec3i)te.getPos(), (StandardSound)StandardSound.BLOCK_ANVIL_PLACE, (SoundCategory)SoundCategory.BLOCKS, (float)(1.0f * ConfigSound.SoundCategories.Machines.category()), (float)0.2f);
                }
                return;
            }
            if (te.getCraftProgress() != 0) {
                powerTe.getEnergy(null).extract(this.powerRequired(), false);
                te.setCraftProgress(Math.max(0, te.getCraftProgress() - 1));
            }
            float progress = te.getCraftProgress();
            ItemStackHandler container = te.getContainer();
            ItemStack input = container.get(0);
            ItemStack output = container.get(1);
            if (progress == 0.0f && !input.isEmpty() && new ItemRollingStockComponent.Data((ItemStack)input).rawCast && output.isEmpty()) {
                te.setCraftProgress(100);
            }
            if (progress == 1.0f) {
                ItemStack out = input.copy();
                out.setCount(1);
                ItemRollingStockComponent.Data data = new ItemRollingStockComponent.Data(out);
                data.rawCast = false;
                data.write();
                container.set(1, out);
                input.shrink(1);
                container.set(0, input);
                progress = 100.0f;
            }
        }

        @Override
        public boolean canInsertItem(Vec3i offset, int slot, ItemStack stack) {
            return slot == 0 && new ItemRollingStockComponent.Data((ItemStack)stack).rawCast;
        }

        @Override
        public boolean isOutputSlot(Vec3i offset, int slot) {
            return slot == 1;
        }

        @Override
        public int getSlotLimit(Vec3i offset, int slot) {
            return this.isCenter(offset) ? 1 : 0;
        }

        @Override
        public boolean canRecievePower(Vec3i offset) {
            return offset.equals((Object)power);
        }

        public boolean hasPower() {
            TileMultiblock powerTe = this.getTile(power);
            if (powerTe == null) {
                return false;
            }
            return powerTe.getEnergy(null).getCurrent() >= this.powerRequired();
        }

        private int powerRequired() {
            return (int)Math.ceil(32.0f * Config.ConfigBalance.machinePowerFactor);
        }
    }
}

