/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.part;

import cam72cam.immersiverailroading.entity.Locomotive;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.ModelState;
import cam72cam.immersiverailroading.model.components.ComponentProvider;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.model.part.StephensonValveGear;
import cam72cam.immersiverailroading.model.part.WheelSet;
import cam72cam.immersiverailroading.util.VecUtil;
import cam72cam.mod.math.Vec3d;
import java.util.Comparator;
import java.util.List;
import util.Matrix4;

public class WalschaertsValveGear
extends StephensonValveGear {
    protected final ModelComponent crossHead;
    protected final ModelComponent combinationLever;
    protected final ModelComponent returnCrank;
    protected final ModelComponent returnCrankRod;
    protected final ModelComponent slottedLink;
    protected final ModelComponent radiusBar;
    protected final List<ModelComponent> todo;
    private final Vec3d crankWheel;

    public static WalschaertsValveGear get(WheelSet wheels, ComponentProvider provider, ModelState state, ModelComponentType.ModelPosition pos, float angleOffset) {
        ModelComponent drivingRod = provider.parse(ModelComponentType.MAIN_ROD_SIDE, pos);
        ModelComponent connectingRod = provider.parse(ModelComponentType.SIDE_ROD_SIDE, pos);
        ModelComponent pistonRod = provider.parse(ModelComponentType.PISTON_ROD_SIDE, pos);
        ModelComponent cylinder = provider.parse(ModelComponentType.CYLINDER_SIDE, pos);
        ModelComponent crossHead = provider.parse(ModelComponentType.UNION_LINK_SIDE, pos);
        ModelComponent combinationLever = provider.parse(ModelComponentType.COMBINATION_LEVER_SIDE, pos);
        ModelComponent returnCrank = provider.parse(ModelComponentType.ECCENTRIC_CRANK_SIDE, pos);
        ModelComponent returnCrankRod = provider.parse(ModelComponentType.ECCENTRIC_ROD_SIDE, pos);
        ModelComponent slottedLink = provider.parse(ModelComponentType.EXPANSION_LINK_SIDE, pos);
        ModelComponent radiusBar = provider.parse(ModelComponentType.RADIUS_BAR_SIDE, pos);
        ModelComponent frontExhaust = provider.parse(ModelComponentType.CYLINDER_DRAIN_SIDE, pos.and(ModelComponentType.ModelPosition.A));
        ModelComponent rearExhaust = provider.parse(ModelComponentType.CYLINDER_DRAIN_SIDE, pos.and(ModelComponentType.ModelPosition.B));
        List<ModelComponent> todo = provider.parse(pos, ModelComponentType.VALVE_STEM_SIDE, ModelComponentType.REVERSING_ARM_SIDE, ModelComponentType.LIFTING_LINK_SIDE, ModelComponentType.REACH_ROD_SIDE);
        return drivingRod != null && connectingRod != null && pistonRod != null && crossHead != null && combinationLever != null && returnCrank != null && returnCrankRod != null && slottedLink != null && radiusBar != null ? new WalschaertsValveGear(wheels, state, drivingRod, connectingRod, pistonRod, cylinder, angleOffset, crossHead, combinationLever, returnCrank, returnCrankRod, slottedLink, radiusBar, todo, frontExhaust, rearExhaust) : null;
    }

    public WalschaertsValveGear(WheelSet wheels, ModelState state, ModelComponent drivingRod, ModelComponent connectingRod, ModelComponent pistonRod, ModelComponent cylinder, float angleOffset, ModelComponent crossHead, ModelComponent combinationLever, ModelComponent returnCrank, ModelComponent returnCrankRod, ModelComponent slottedLink, ModelComponent radiusBar, List<ModelComponent> todo, ModelComponent frontExhaust, ModelComponent rearExhaust) {
        super(wheels, state, drivingRod, connectingRod, pistonRod, cylinder, angleOffset, frontExhaust, rearExhaust);
        this.crossHead = crossHead;
        this.combinationLever = combinationLever;
        this.returnCrank = returnCrank;
        this.returnCrankRod = returnCrankRod;
        this.slottedLink = slottedLink;
        this.radiusBar = radiusBar;
        this.todo = todo;
        this.crankWheel = wheels.wheels.stream().map(w -> w.wheel.center).min(Comparator.comparingDouble(w -> w.distanceTo(this.reverse ? returnCrank.min : returnCrank.max))).get();
        state.include(todo);
        state = state.push(builder -> builder.add((stock, group, partialTicks) -> {
            float raidiusBarAngle;
            float returnCrankRodRot;
            float wheelAngle = super.angle(stock.distanceTraveled);
            float reverser = stock instanceof Locomotive ? ((Locomotive)stock).getReverser() : 0.0f;
            Vec3d connRodPos = this.connectingRod.center;
            double connRodRadius = connRodPos.x - this.centerOfWheels.x;
            Vec3d connRodMovment = VecUtil.fromWrongYaw(connRodRadius, wheelAngle);
            double pistonDelta = connRodMovment.x - connRodRadius;
            if (crossHead.modelIDs.contains(group)) {
                return new Matrix4().translate(pistonDelta, 0.0, 0.0);
            }
            Vec3d returnCrankRotPoint = this.reverse ? returnCrank.min.add(returnCrank.height() / 2.0, returnCrank.height() / 2.0, 0.0) : returnCrank.max.add(-returnCrank.height() / 2.0, -returnCrank.height() / 2.0, 0.0);
            Vec3d wheelRotationOffset = this.reverse ? VecUtil.fromWrongYaw(returnCrankRotPoint.x - this.crankWheel.x, wheelAngle) : VecUtil.fromWrongYaw(returnCrankRotPoint.x - this.crankWheel.x, wheelAngle);
            Vec3d returnCrankOriginOffset = this.crankWheel.add(wheelRotationOffset.x, wheelRotationOffset.z, 0.0);
            double returnCrankAngle = wheelAngle + 90.0f + 30.0f;
            if (returnCrank.modelIDs.contains(group)) {
                Matrix4 matrix = new Matrix4();
                matrix.translate(returnCrankOriginOffset.x, returnCrankOriginOffset.y, 0.0);
                matrix.rotate(Math.toRadians(returnCrankAngle), 0.0, 0.0, 1.0);
                matrix.translate(-returnCrankRotPoint.x, -returnCrankRotPoint.y, 0.0);
                return matrix;
            }
            double returnCrankLength = -(returnCrank.length() - returnCrank.height() / 2.0 - returnCrankRod.height() / 2.0);
            Vec3d returnCrankRotationOffset = VecUtil.fromWrongYaw(returnCrankLength, (float)returnCrankAngle + (float)(this.reverse ? 90 : -90));
            Vec3d returnCrankRodOriginOffset = returnCrankOriginOffset.add(returnCrankRotationOffset.x, returnCrankRotationOffset.z, 0.0);
            Vec3d returnCrankRodRotPoint = this.reverse ? returnCrankRod.min.add(returnCrankRod.height() / 2.0, returnCrankRod.height() / 2.0, 0.0) : returnCrankRod.max.add(-returnCrankRod.height() / 2.0, -returnCrankRod.height() / 2.0, 0.0);
            double returnCrankRodLength = returnCrankRod.length() - returnCrankRod.height() / 2.0;
            double slottedLinkLowest = slottedLink.min.y + slottedLink.width() / 2.0;
            double returnCrankRodFudge = this.reverse ? Math.abs(slottedLink.center.x - (returnCrankRodOriginOffset.x + returnCrankRodLength)) / 3.0 : Math.abs(slottedLink.center.x - (returnCrankRodOriginOffset.x - returnCrankRodLength)) / 3.0;
            float f = returnCrankRodRot = this.reverse ? -VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.y + returnCrankRodFudge, 0.0, returnCrankRodLength)) : VecUtil.toWrongYaw(new Vec3d(slottedLinkLowest - returnCrankRodOriginOffset.y + returnCrankRodFudge, 0.0, returnCrankRodLength));
            if (returnCrankRod.modelIDs.contains(group)) {
                Matrix4 matrix = new Matrix4();
                matrix.translate(returnCrankRodOriginOffset.x, returnCrankRodOriginOffset.y, 0.0);
                matrix.rotate(Math.toRadians(returnCrankRodRot), 0.0, 0.0, 1.0);
                matrix.translate(-returnCrankRodRotPoint.x, -returnCrankRodRotPoint.y, 0.0);
                return matrix;
            }
            Vec3d returnCrankRodRotationOffset = VecUtil.fromWrongYaw(returnCrankRodLength, returnCrankRodRot + (float)(this.reverse ? -90 : 90));
            Vec3d returnCrankRodFarPoint = returnCrankRodOriginOffset.add(returnCrankRodRotationOffset.x, returnCrankRodRotationOffset.z, 0.0);
            Vec3d slottedLinkRotPoint = slottedLink.center;
            double slottedLinkRot = Math.toDegrees(Math.atan2(-slottedLinkRotPoint.x + returnCrankRodFarPoint.x, slottedLinkRotPoint.y - returnCrankRodFarPoint.y));
            if (slottedLink.modelIDs.contains(group)) {
                Matrix4 matrix = new Matrix4();
                matrix.translate(slottedLinkRotPoint.x, slottedLinkRotPoint.y, 0.0);
                matrix.rotate(Math.toRadians(slottedLinkRot), 0.0, 0.0, 1.0);
                matrix.translate(-slottedLinkRotPoint.x, -slottedLinkRotPoint.y, 0.0);
                return matrix;
            }
            double forwardMax = (slottedLink.min.y - slottedLinkRotPoint.y) * 0.4;
            double forwardMin = (slottedLink.max.y - slottedLinkRotPoint.y) * 0.65;
            double throttleSlotPos = 0.0;
            throttleSlotPos = reverser > 0.0f ? forwardMax * (double)reverser : forwardMin * (double)(-reverser);
            double radiusBarSliding = Math.sin(Math.toRadians(-slottedLinkRot)) * throttleSlotPos;
            Vec3d radiusBarClose = this.reverse ? radiusBar.min : radiusBar.max;
            float f2 = raidiusBarAngle = this.reverse ? -(VecUtil.toWrongYaw(new Vec3d(radiusBar.length(), 0.0, throttleSlotPos)) + 90.0f) : VecUtil.toWrongYaw(new Vec3d(radiusBar.length(), 0.0, throttleSlotPos += slottedLinkRotPoint.y - radiusBar.max.y)) + 90.0f;
            if (radiusBar.modelIDs.contains(group)) {
                Matrix4 matrix = new Matrix4();
                matrix.translate(0.0, throttleSlotPos, 0.0);
                matrix.translate(radiusBarSliding, 0.0, 0.0);
                matrix.translate(radiusBarClose.x, radiusBarClose.y, 0.0);
                matrix.rotate(Math.toRadians(raidiusBarAngle), 0.0, 0.0, 1.0);
                matrix.translate(-radiusBarClose.x, -radiusBarClose.y, 0.0);
                return matrix;
            }
            Vec3d radiusBarFar = this.reverse ? radiusBar.max : radiusBar.min;
            Vec3d radiusBarFarPoint = radiusBarFar.add(radiusBarSliding + combinationLever.width() / 2.0, 0.0, 0.0);
            Vec3d combinationLeverRotPos = combinationLever.min.add(combinationLever.width() / 2.0, combinationLever.width() / 2.0, 0.0);
            Vec3d delta = radiusBarFarPoint.subtract(combinationLeverRotPos.add(pistonDelta, 0.0, 0.0));
            float combinationLeverAngle = VecUtil.toWrongYaw(new Vec3d(delta.x, 0.0, delta.y));
            if (combinationLever.modelIDs.contains(group)) {
                Matrix4 matrix = new Matrix4();
                matrix.translate(pistonDelta, 0.0, 0.0);
                matrix.translate(combinationLeverRotPos.x, combinationLeverRotPos.y, 0.0);
                matrix.rotate(Math.toRadians(combinationLeverAngle), 0.0, 0.0, 1.0);
                matrix.translate(-combinationLeverRotPos.x, -combinationLeverRotPos.y, 0.0);
                return matrix;
            }
            return null;
        }));
        state.include(crossHead);
        state.include(combinationLever);
        state.include(returnCrank);
        state.include(returnCrankRod);
        state.include(slottedLink);
        state.include(radiusBar);
    }
}

