/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.model.components;

import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.model.StockModel;
import cam72cam.immersiverailroading.model.components.ModelComponent;
import cam72cam.immersiverailroading.util.DataBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class ComponentProvider {
    public final StockModel<?, ?> model;
    private final Set<String> groups;
    public Map<String, DataBlock> widgetConfig;
    private final List<ModelComponent> components;
    public double internal_model_scale;

    public ComponentProvider(StockModel<?, ?> model, double internal_model_scale, Map<String, DataBlock> widgetConfig) {
        this.model = model;
        this.groups = new HashSet<String>(model.groups());
        this.widgetConfig = widgetConfig;
        this.components = new ArrayList<ModelComponent>();
        this.internal_model_scale = internal_model_scale;
    }

    private Set<String> modelIDs(String pattern) {
        Pattern regex = Pattern.compile(pattern);
        Set<String> modelIDs = this.groups.stream().filter(group -> regex.matcher((CharSequence)group).matches()).collect(Collectors.toSet());
        this.groups.removeAll(modelIDs);
        return modelIDs;
    }

    private Map<String, Set<String>> modelIDMap(String pattern) {
        Pattern rgx = Pattern.compile(pattern);
        Map<String, Set<String>> modelIDs = this.groups.stream().map(rgx::matcher).filter(Matcher::matches).collect(Collectors.groupingBy(m -> m.group(m.groupCount()), Collectors.mapping(m -> m.group(0), Collectors.toSet())));
        modelIDs.forEach((k, v) -> this.groups.removeAll((Collection<?>)v));
        return modelIDs;
    }

    public ModelComponent parse(ModelComponentType type) {
        Set<String> ids = this.modelIDs(type.regex);
        if (!ids.isEmpty()) {
            ModelComponent component = new ModelComponent(type, null, null, this.model, ids);
            this.components.add(component);
            return component;
        }
        return null;
    }

    public List<ModelComponent> parse(ModelComponentType ... types) {
        return Arrays.stream(types).map(this::parse).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public ModelComponent parse(ModelComponentType type, ModelComponentType.ModelPosition pos) {
        Set<String> ids = this.modelIDs(type.regex.replace("#POS#", pos.toString()).replace("#SIDE#", pos.toString()));
        if (!ids.isEmpty()) {
            ModelComponent component = new ModelComponent(type, pos, null, this.model, ids);
            this.components.add(component);
            return component;
        }
        return null;
    }

    public List<ModelComponent> parse(ModelComponentType.ModelPosition pos, ModelComponentType ... types) {
        return Arrays.stream(types).map(type -> this.parse((ModelComponentType)((Object)type), pos)).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ModelComponent> parseAll(ModelComponentType type) {
        return this.modelIDMap(type.regex.replace("#ID#", "([\\d]+)")).entrySet().stream().map(e -> {
            ModelComponent component = new ModelComponent(type, null, Integer.parseInt((String)e.getKey()), this.model, (Set)e.getValue());
            this.components.add(component);
            return component;
        }).collect(Collectors.toList());
    }

    public List<ModelComponent> parseAll(ModelComponentType ... types) {
        return Arrays.stream(types).flatMap(type -> this.parseAll((ModelComponentType)((Object)type)).stream()).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<ModelComponent> parseAll(ModelComponentType type, ModelComponentType.ModelPosition pos) {
        String re = type.regex;
        re = !(re = re.replace("#POS#", pos.toString()).replace("#SIDE#", pos.toString())).equals(type.regex) ? re.replace("#ID#", "([\\d]+)") : re.replace("#ID#", pos + "_([\\d]+)");
        return this.modelIDMap(re).entrySet().stream().map(e -> {
            ModelComponent component = new ModelComponent(type, pos, Integer.parseInt((String)e.getKey()), this.model, (Set)e.getValue());
            this.components.add(component);
            return component;
        }).collect(Collectors.toList());
    }

    public List<ModelComponent> components() {
        return this.components;
    }
}

