/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.items.nbt;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.library.TrackPositionType;
import cam72cam.immersiverailroading.library.TrackSmoothing;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.serialization.SerializationException;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapped;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.serialization.TagSerializer;
import java.util.function.Consumer;

@TagMapped(value=Mapper.class)
public class RailSettings {
    public final Gauge gauge;
    public final TrackItems type;
    public final int length;
    public final float degrees;
    public final float curvosity;
    public final TrackPositionType posType;
    public final TrackSmoothing smoothing;
    public final TrackDirection direction;
    public final ItemStack railBed;
    public final ItemStack railBedFill;
    public final boolean isPreview;
    public final boolean isGradeCrossing;
    public final String track;

    public RailSettings(Gauge gauge, String track, TrackItems type, int length, float degrees, float curvosity, TrackPositionType posType, TrackSmoothing smoothing, TrackDirection direction, ItemStack railBed, ItemStack railBedFill, boolean isPreview, boolean isGradeCrossing) {
        this.gauge = gauge;
        this.track = track;
        this.type = type;
        this.length = length;
        this.degrees = degrees;
        this.posType = posType;
        this.smoothing = smoothing;
        this.direction = direction;
        this.railBed = railBed;
        this.railBedFill = railBedFill;
        this.isPreview = isPreview;
        this.isGradeCrossing = isGradeCrossing;
        this.curvosity = curvosity;
    }

    public void write(ItemStack stack) {
        TagCompound data = new TagCompound();
        try {
            TagSerializer.serialize((TagCompound)data, (Object)this.mutable(), (Class[])new Class[0]);
        }
        catch (SerializationException e) {
            ImmersiveRailroading.catching((Throwable)e);
        }
        stack.setTagCompound(data);
    }

    public static RailSettings from(ItemStack stack) {
        try {
            return new Mutable(stack.getTagCompound()).immutable();
        }
        catch (SerializationException e) {
            throw new RuntimeException(e);
        }
    }

    public Mutable mutable() {
        return new Mutable(this);
    }

    public RailSettings with(Consumer<Mutable> mod) {
        Mutable mutable = this.mutable();
        mod.accept(mutable);
        return mutable.immutable();
    }

    public static class Mapper
    implements TagMapper<RailSettings> {
        public TagMapper.TagAccessor<RailSettings> apply(Class<RailSettings> type, String fieldName, TagField tag) throws SerializationException {
            return new TagMapper.TagAccessor((d, o) -> {
                TagCompound target = new TagCompound();
                try {
                    TagSerializer.serialize((TagCompound)target, (Object)o.mutable(), (Class[])new Class[0]);
                }
                catch (SerializationException e) {
                    throw new RuntimeException(e);
                }
                d.set(fieldName, target);
            }, d -> {
                try {
                    return new Mutable(d.get(fieldName)).immutable();
                }
                catch (SerializationException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static class Mutable {
        @TagField(value="gauge")
        public Gauge gauge;
        @TagField(value="type")
        public TrackItems type;
        @TagField(value="length")
        public int length;
        @TagField(value="degrees", mapper=DegreesMapper.class)
        public float degrees;
        @TagField(value="curvosity")
        public float curvosity;
        @TagField(value="pos_type")
        public TrackPositionType posType;
        @TagField(value="smoothing", mapper=SmoothingMapper.class)
        public TrackSmoothing smoothing;
        @TagField(value="direction")
        public TrackDirection direction;
        @TagField(value="bedItem")
        public ItemStack railBed;
        @TagField(value="bedFill")
        public ItemStack railBedFill;
        @TagField(value="isPreview")
        public boolean isPreview;
        @TagField(value="isGradeCrossing")
        public boolean isGradeCrossing;
        @TagField(value="track")
        public String track;

        private Mutable(RailSettings settings) {
            this.gauge = settings.gauge;
            this.track = settings.track;
            this.type = settings.type;
            this.length = settings.length;
            this.degrees = settings.degrees;
            this.curvosity = settings.curvosity;
            this.posType = settings.posType;
            this.smoothing = settings.smoothing;
            this.direction = settings.direction;
            this.railBed = settings.railBed;
            this.railBedFill = settings.railBedFill;
            this.isPreview = settings.isPreview;
            this.isGradeCrossing = settings.isGradeCrossing;
        }

        private Mutable(TagCompound data) throws SerializationException {
            this.gauge = Gauge.from(1.435);
            this.type = TrackItems.STRAIGHT;
            this.track = "default";
            this.length = 10;
            this.degrees = 90.0f;
            this.posType = TrackPositionType.FIXED;
            this.smoothing = TrackSmoothing.BOTH;
            this.direction = TrackDirection.NONE;
            this.railBed = ItemStack.EMPTY;
            this.railBedFill = ItemStack.EMPTY;
            this.isPreview = false;
            this.isGradeCrossing = false;
            this.curvosity = 1.0f;
            TagSerializer.deserialize((TagCompound)data, (Object)this);
        }

        public RailSettings immutable() {
            return new RailSettings(this.gauge, this.track, this.type, this.length, this.degrees, this.curvosity, this.posType, this.smoothing, this.direction, this.railBed, this.railBedFill, this.isPreview, this.isGradeCrossing);
        }
    }

    private static class SmoothingMapper
    implements TagMapper<TrackSmoothing> {
        private SmoothingMapper() {
        }

        public TagMapper.TagAccessor<TrackSmoothing> apply(Class<TrackSmoothing> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor<TrackSmoothing>((d, o) -> d.setEnum(fieldName, (Enum)o), nbt -> {
                if (nbt.hasKey(fieldName)) {
                    return (TrackSmoothing)nbt.getEnum(fieldName, type);
                }
                return nbt.getEnum("type", TrackItems.class) == TrackItems.SLOPE ? TrackSmoothing.NEITHER : TrackSmoothing.BOTH;
            }){

                public boolean applyIfMissing() {
                    return true;
                }
            };
        }
    }

    private static class DegreesMapper
    implements TagMapper<Float> {
        private DegreesMapper() {
        }

        public TagMapper.TagAccessor<Float> apply(Class<Float> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor<Float>((d, o) -> d.setFloat(fieldName, o), d -> Float.valueOf(d.hasKey(fieldName) ? d.getFloat(fieldName).floatValue() : (d.hasKey("quarters") ? (float)d.getInteger("quarters").intValue() / 4.0f * 90.0f : 90.0f))){

                public boolean applyIfMissing() {
                    return true;
                }
            };
        }
    }
}

