/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.gui;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.gui.ClickListHelper;
import cam72cam.immersiverailroading.gui.components.GuiUtils;
import cam72cam.immersiverailroading.gui.components.ListSelector;
import cam72cam.immersiverailroading.items.nbt.RailSettings;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.GuiText;
import cam72cam.immersiverailroading.library.SwitchState;
import cam72cam.immersiverailroading.library.TrackDirection;
import cam72cam.immersiverailroading.library.TrackItems;
import cam72cam.immersiverailroading.net.ItemRailUpdatePacket;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.TrackDefinition;
import cam72cam.immersiverailroading.render.rail.RailRender;
import cam72cam.immersiverailroading.tile.TileRailPreview;
import cam72cam.immersiverailroading.track.BuilderTurnTable;
import cam72cam.immersiverailroading.track.TrackBase;
import cam72cam.immersiverailroading.util.IRFuzzy;
import cam72cam.immersiverailroading.util.PlacementInfo;
import cam72cam.immersiverailroading.util.RailInfo;
import cam72cam.mod.MinecraftClient;
import cam72cam.mod.entity.Player;
import cam72cam.mod.gui.helpers.GUIHelpers;
import cam72cam.mod.gui.screen.Button;
import cam72cam.mod.gui.screen.CheckBox;
import cam72cam.mod.gui.screen.IScreen;
import cam72cam.mod.gui.screen.IScreenBuilder;
import cam72cam.mod.gui.screen.Slider;
import cam72cam.mod.gui.screen.TextField;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.render.StandardModel;
import cam72cam.mod.render.opengl.RenderState;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import util.Matrix4;

public class TrackGui
implements IScreen {
    long frame;
    private TileRailPreview te;
    private Button typeButton;
    private TextField lengthInput;
    private Slider degreesSlider;
    private Slider curvositySlider;
    private CheckBox isPreviewCB;
    private CheckBox isGradeCrossingCB;
    private Button gaugeButton;
    private Button trackButton;
    private Button posTypeButton;
    private Button smoothingButton;
    private Button directionButton;
    private Button bedTypeButton;
    private Button bedFillButton;
    private final List<ItemStack> oreDict;
    private RailSettings.Mutable settings;
    private ListSelector<Gauge> gaugeSelector;
    private ListSelector<TrackItems> typeSelector;
    private ListSelector<TrackDefinition> trackSelector;
    private ListSelector<ItemStack> railBedSelector;
    private ListSelector<ItemStack> railBedFillSelector;
    private double zoom = 1.0;

    public TrackGui() {
        this(MinecraftClient.getPlayer().getHeldItem(Player.Hand.PRIMARY));
    }

    public TrackGui(TileRailPreview te) {
        this(te.getItem());
        this.te = te;
    }

    private TrackGui(ItemStack stack) {
        stack = stack.copy();
        this.settings = RailSettings.from(stack).mutable();
        this.oreDict = new ArrayList<ItemStack>();
        this.oreDict.add(ItemStack.EMPTY);
        this.oreDict.addAll(IRFuzzy.IR_RAIL_BED.enumerate());
    }

    public static String getStackName(ItemStack stack) {
        if (stack.isEmpty()) {
            return GuiText.NONE.toString();
        }
        return stack.getDisplayName();
    }

    public void init(IScreenBuilder screen) {
        int width = 200;
        int height = 20;
        int xtop = -GUIHelpers.getScreenWidth() / 2;
        int ytop = -GUIHelpers.getScreenHeight() / 4;
        this.lengthInput = new TextField(screen, xtop, ytop, width - 1, height);
        this.lengthInput.setText("" + this.settings.length);
        this.lengthInput.setValidator(s -> {
            int val;
            if (s == null || s.length() == 0) {
                return true;
            }
            try {
                val = Integer.parseInt(s);
            }
            catch (NumberFormatException e) {
                return false;
            }
            int max = 1000;
            if (this.settings.type == TrackItems.TURNTABLE) {
                max = BuilderTurnTable.maxLength(this.settings.gauge);
            }
            if (val > 0 && val <= max) {
                this.settings.length = val;
                return true;
            }
            return false;
        });
        this.lengthInput.setFocused(true);
        this.gaugeSelector = new ListSelector<Gauge>(screen, width, 100, height, this.settings.gauge, (Map)Gauge.values().stream().collect(Collectors.toMap(Gauge::toString, g -> g, (u, v) -> u, LinkedHashMap::new))){

            @Override
            public void onClick(Gauge gauge) {
                ((TrackGui)TrackGui.this).settings.gauge = gauge;
                TrackGui.this.gaugeButton.setText(GuiText.SELECTOR_GAUGE.toString(((TrackGui)TrackGui.this).settings.gauge));
                if (((TrackGui)TrackGui.this).settings.type == TrackItems.TURNTABLE) {
                    TrackGui.this.lengthInput.setText("" + Math.min(Integer.parseInt(TrackGui.this.lengthInput.getText()), BuilderTurnTable.maxLength(((TrackGui)TrackGui.this).settings.gauge)));
                }
            }
        };
        this.gaugeButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_GAUGE.toString(this.settings.gauge)){

            public void onClick(Player.Hand hand) {
                TrackGui.this.showSelector(TrackGui.this.gaugeSelector);
            }
        };
        this.typeSelector = new ListSelector<TrackItems>(screen, width, 100, height, this.settings.type, (Map)Arrays.stream(TrackItems.values()).filter(i -> i != TrackItems.CROSSING).collect(Collectors.toMap(TrackItems::toString, g -> g, (u, v) -> u, LinkedHashMap::new))){

            @Override
            public void onClick(TrackItems option) {
                ((TrackGui)TrackGui.this).settings.type = option;
                TrackGui.this.typeButton.setText(GuiText.SELECTOR_TYPE.toString(new Object[]{((TrackGui)TrackGui.this).settings.type}));
                TrackGui.this.degreesSlider.setVisible(((TrackGui)TrackGui.this).settings.type.hasQuarters());
                TrackGui.this.curvositySlider.setVisible(((TrackGui)TrackGui.this).settings.type.hasCurvosity());
                TrackGui.this.smoothingButton.setVisible(((TrackGui)TrackGui.this).settings.type.hasSmoothing());
                TrackGui.this.directionButton.setVisible(((TrackGui)TrackGui.this).settings.type.hasDirection());
                if (((TrackGui)TrackGui.this).settings.type == TrackItems.TURNTABLE) {
                    TrackGui.this.lengthInput.setText("" + Math.min(Integer.parseInt(TrackGui.this.lengthInput.getText()), BuilderTurnTable.maxLength(((TrackGui)TrackGui.this).settings.gauge)));
                }
            }
        };
        this.typeButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_TYPE.toString(new Object[]{this.settings.type})){

            public void onClick(Player.Hand hand) {
                TrackGui.this.showSelector(TrackGui.this.typeSelector);
            }
        };
        this.smoothingButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_SMOOTHING.toString(new Object[]{this.settings.smoothing})){

            public void onClick(Player.Hand hand) {
                ((TrackGui)TrackGui.this).settings.smoothing = ClickListHelper.next(((TrackGui)TrackGui.this).settings.smoothing, hand);
                TrackGui.this.smoothingButton.setText(GuiText.SELECTOR_SMOOTHING.toString(new Object[]{((TrackGui)TrackGui.this).settings.smoothing}));
            }
        };
        this.smoothingButton.setVisible(this.settings.type.hasSmoothing());
        this.directionButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_DIRECTION.toString(new Object[]{this.settings.direction})){

            public void onClick(Player.Hand hand) {
                ((TrackGui)TrackGui.this).settings.direction = ClickListHelper.next(((TrackGui)TrackGui.this).settings.direction, hand);
                TrackGui.this.directionButton.setText(GuiText.SELECTOR_DIRECTION.toString(new Object[]{((TrackGui)TrackGui.this).settings.direction}));
            }
        };
        this.directionButton.setVisible(this.settings.type.hasDirection());
        this.degreesSlider = new Slider(screen, 25 + xtop, ytop += height, "", 1.0, Config.ConfigBalance.AnglePlacementSegmentation, this.settings.degrees / 90.0f * (float)Config.ConfigBalance.AnglePlacementSegmentation, false){

            public void onSlider() {
                ((TrackGui)TrackGui.this).settings.degrees = (float)TrackGui.this.degreesSlider.getValueInt() * (90.0f / (float)Config.ConfigBalance.AnglePlacementSegmentation);
                TrackGui.this.degreesSlider.setText(GuiText.SELECTOR_QUARTERS.toString((double)this.getValueInt() * (90.0 / (double)Config.ConfigBalance.AnglePlacementSegmentation)));
            }
        };
        this.degreesSlider.onSlider();
        this.curvositySlider = new Slider(screen, 25 + xtop, ytop += height, "", 0.25, 1.5, this.settings.curvosity, true){

            public void onSlider() {
                ((TrackGui)TrackGui.this).settings.curvosity = (float)this.getValue();
                TrackGui.this.curvositySlider.setText(GuiText.SELECTOR_CURVOSITY.toString(String.format("%.2f", Float.valueOf(((TrackGui)TrackGui.this).settings.curvosity))));
            }
        };
        this.curvositySlider.onSlider();
        ytop += height;
        this.directionButton.setVisible(this.settings.type.hasDirection());
        this.degreesSlider.setVisible(this.settings.type.hasQuarters());
        this.curvositySlider.setVisible(this.settings.type.hasCurvosity());
        this.smoothingButton.setVisible(this.settings.type.hasSmoothing());
        ytop = (int)((double)GUIHelpers.getScreenHeight() * 0.75 - (double)(height * 6));
        this.trackSelector = new ListSelector<TrackDefinition>(screen, width, 250, height, DefinitionManager.getTrack(this.settings.track), (Map)DefinitionManager.getTracks().stream().collect(Collectors.toMap(t -> t.name, g -> g, (u, v) -> u, LinkedHashMap::new))){

            @Override
            public void onClick(TrackDefinition track) {
                ((TrackGui)TrackGui.this).settings.track = track.trackID;
                TrackGui.this.trackButton.setText(GuiText.SELECTOR_TRACK.toString(GuiUtils.fitString(DefinitionManager.getTrack((String)((TrackGui)TrackGui.this).settings.track).name, 24)));
            }
        };
        this.trackButton = new Button(screen, xtop, ytop, width, height, GuiText.SELECTOR_TRACK.toString(GuiUtils.fitString(DefinitionManager.getTrack((String)this.settings.track).name, 24))){

            public void onClick(Player.Hand hand) {
                TrackGui.this.showSelector(TrackGui.this.trackSelector);
            }
        };
        this.railBedSelector = new ListSelector<ItemStack>(screen, width, 250, height, this.settings.railBed, (Map)this.oreDict.stream().collect(Collectors.toMap(TrackGui::getStackName, g -> g, (u, v) -> u, LinkedHashMap::new))){

            @Override
            public void onClick(ItemStack option) {
                ((TrackGui)TrackGui.this).settings.railBed = option;
                TrackGui.this.bedTypeButton.setText(GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(((TrackGui)TrackGui.this).settings.railBed)));
            }
        };
        this.bedTypeButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(this.settings.railBed))){

            public void onClick(Player.Hand hand) {
                TrackGui.this.showSelector(TrackGui.this.railBedSelector);
            }
        };
        this.railBedFillSelector = new ListSelector<ItemStack>(screen, width, 250, height, this.settings.railBedFill, (Map)this.oreDict.stream().collect(Collectors.toMap(TrackGui::getStackName, g -> g, (u, v) -> u, LinkedHashMap::new))){

            @Override
            public void onClick(ItemStack option) {
                ((TrackGui)TrackGui.this).settings.railBedFill = option;
                TrackGui.this.bedFillButton.setText(GuiText.SELECTOR_RAIL_BED_FILL.toString(TrackGui.getStackName(((TrackGui)TrackGui.this).settings.railBedFill)));
            }
        };
        this.bedFillButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_RAIL_BED_FILL.toString(TrackGui.getStackName(this.settings.railBedFill))){

            public void onClick(Player.Hand hand) {
                TrackGui.this.showSelector(TrackGui.this.railBedFillSelector);
            }
        };
        this.posTypeButton = new Button(screen, xtop, ytop += height, width, height, GuiText.SELECTOR_POSITION.toString(new Object[]{this.settings.posType})){

            public void onClick(Player.Hand hand) {
                ((TrackGui)TrackGui.this).settings.posType = ClickListHelper.next(((TrackGui)TrackGui.this).settings.posType, hand);
                TrackGui.this.posTypeButton.setText(GuiText.SELECTOR_POSITION.toString(new Object[]{((TrackGui)TrackGui.this).settings.posType}));
            }
        };
        this.isPreviewCB = new CheckBox(screen, xtop + 2, (ytop += height) + 2, GuiText.SELECTOR_PLACE_BLUEPRINT.toString(), this.settings.isPreview){

            public void onClick(Player.Hand hand) {
                ((TrackGui)TrackGui.this).settings.isPreview = TrackGui.this.isPreviewCB.isChecked();
            }
        };
        this.isGradeCrossingCB = new CheckBox(screen, xtop + 2, (ytop += height) + 2, GuiText.SELECTOR_GRADE_CROSSING.toString(), this.settings.isGradeCrossing){

            public void onClick(Player.Hand hand) {
                ((TrackGui)TrackGui.this).settings.isGradeCrossing = TrackGui.this.isGradeCrossingCB.isChecked();
            }
        };
        ytop += height;
        Slider zoom_slider = new Slider(screen, GUIHelpers.getScreenWidth() / 2 - 150, (int)((double)GUIHelpers.getScreenHeight() * 0.75 - (double)height), "Zoom: ", 0.1, 2.0, 1.0, true){

            public void onSlider() {
                TrackGui.this.zoom = this.getValue();
            }
        };
    }

    private void showSelector(ListSelector<?> selector) {
        boolean isVisible = selector.isVisible();
        this.gaugeSelector.setVisible(false);
        this.typeSelector.setVisible(false);
        this.trackSelector.setVisible(false);
        this.railBedSelector.setVisible(false);
        this.railBedFillSelector.setVisible(false);
        selector.setVisible(!isVisible);
    }

    public void onEnterKey(IScreenBuilder builder) {
        builder.close();
    }

    public void onClose() {
        if (!this.lengthInput.getText().isEmpty()) {
            if (this.te != null) {
                new ItemRailUpdatePacket(this.te.getPos(), this.settings.immutable()).sendToServer();
            } else {
                new ItemRailUpdatePacket(this.settings.immutable()).sendToServer();
            }
        }
    }

    public void draw(IScreenBuilder builder, RenderState state) {
        ++this.frame;
        GUIHelpers.drawRect((int)200, (int)0, (int)(GUIHelpers.getScreenWidth() - 200), (int)GUIHelpers.getScreenHeight(), (int)-872415232);
        GUIHelpers.drawRect((int)0, (int)0, (int)200, (int)GUIHelpers.getScreenHeight(), (int)-301989888);
        if (this.gaugeSelector.isVisible()) {
            double textScale = 1.5;
            GUIHelpers.drawCenteredString((String)GuiText.SELECTOR_GAUGE.toString(this.settings.gauge.toString()), (int)((int)((double)(300 + (GUIHelpers.getScreenWidth() - 300) / 2) / textScale)), (int)((int)(10.0 / textScale)), (int)0xFFFFFF, (Matrix4)new Matrix4().scale(textScale, textScale, textScale));
            RailInfo info = new RailInfo(this.settings.immutable().with(rendered -> {
                rendered.length = 5;
                rendered.type = TrackItems.STRAIGHT;
            }), new PlacementInfo(new Vec3d(0.5, 0.0, 0.5), TrackDirection.NONE, 0.0f, null), null, SwitchState.NONE, SwitchState.NONE, 0.0, true);
            double scale = (double)GUIHelpers.getScreenWidth() / 12.0 * this.zoom;
            state.translate((double)(300 + (GUIHelpers.getScreenWidth() - 300) / 2), (double)builder.getHeight(), 100.0);
            state.rotate(90.0, 1.0, 0.0, 0.0);
            state.scale(-scale, scale, scale);
            state.translate(0.0, 0.0, 1.0);
            RailRender.get(info).renderRailModel(state);
            state.translate(-0.5, 0.0, -0.5);
            RailRender.get(info).renderRailBase(state);
            return;
        }
        if (this.trackSelector.isVisible() || this.railBedSelector.isVisible() || this.railBedFillSelector.isVisible()) {
            ListSelector.ButtonRenderer<ItemStack> icons = (button, x, y, value) -> {
                Matrix4 zMatrix = new Matrix4();
                zMatrix.translate(0.0, 0.0, 100.0);
                GUIHelpers.drawItem((ItemStack)value, (int)(x + 2), (int)(y + 2), (Matrix4)zMatrix);
            };
            this.railBedSelector.render(icons);
            this.railBedFillSelector.render(icons);
            double textScale = 1.5;
            String str = this.trackSelector.isVisible() ? GuiText.SELECTOR_TRACK.toString(DefinitionManager.getTrack((String)this.settings.track).name) : (this.railBedSelector.isVisible() ? GuiText.SELECTOR_RAIL_BED.toString(TrackGui.getStackName(this.settings.railBed)) : GuiText.SELECTOR_RAIL_BED_FILL.toString(TrackGui.getStackName(this.settings.railBedFill)));
            GUIHelpers.drawCenteredString((String)str, (int)((int)((double)(450 + (GUIHelpers.getScreenWidth() - 450) / 2) / textScale)), (int)((int)(10.0 / textScale)), (int)0xFFFFFF, (Matrix4)new Matrix4().scale(textScale, textScale, textScale));
            RailInfo info = new RailInfo(this.settings.immutable().with(rendered -> {
                rendered.length = 3;
                rendered.type = TrackItems.STRAIGHT;
            }), new PlacementInfo(new Vec3d(0.5, 0.0, 0.5), TrackDirection.NONE, 0.0f, null), null, SwitchState.NONE, SwitchState.NONE, 0.0, true);
            double scale = (double)GUIHelpers.getScreenWidth() / 15.0 * this.zoom;
            state.translate((double)(450 + (GUIHelpers.getScreenWidth() - 450) / 2), (double)(builder.getHeight() / 2), 500.0);
            state.rotate(90.0, 1.0, 0.0, 0.0);
            state.scale(-scale, scale, scale);
            state.translate(0.0, 0.0, -1.0);
            state.rotate(60.0, 1.0, 0.0, 0.0);
            state.translate(0.0, 0.0, 1.0);
            state.rotate((double)this.frame / 2.0, 0.0, 1.0, 0.0);
            state.translate(0.0, 0.0, -1.0);
            RailRender.get(info).renderRailModel(state);
            state.translate(-0.5, 0.0, -0.5);
            RailRender.get(info).renderRailBase(state);
            if (!info.settings.railBedFill.isEmpty()) {
                StandardModel model = new StandardModel();
                for (TrackBase base : info.getBuilder(MinecraftClient.getPlayer().getWorld()).getTracksForRender()) {
                    Vec3i basePos = base.getPos();
                    model.addItemBlock(info.settings.railBedFill, new Matrix4().translate((double)basePos.x, (double)(basePos.y - 1), (double)basePos.z));
                }
                model.render(state);
            }
            return;
        }
        if (this.lengthInput.getText().isEmpty()) {
            return;
        }
        RailInfo info = new RailInfo(this.settings.immutable().with(b -> {
            int length = b.length;
            if (length < 5) {
                length = 5;
            }
            if (this.settings.type == TrackItems.TURNTABLE) {
                length = Math.min(25, Math.max(10, length));
            }
            b.length = length;
        }), new PlacementInfo(new Vec3d(0.5, 0.0, 0.5), this.settings.direction, 0.0f, null), null, SwitchState.NONE, SwitchState.NONE, this.settings.type == TrackItems.TURNTABLE ? (double)this.frame / 2.0 % 360.0 : 0.0, true);
        int length = info.settings.length;
        double scale = (double)GUIHelpers.getScreenWidth() / ((double)length * 2.25) * this.zoom;
        if (this.settings.type == TrackItems.TURNTABLE) {
            scale /= 2.0;
        }
        state.translate((double)(200 + (GUIHelpers.getScreenWidth() - 200) / 2), (double)(builder.getHeight() - 30), 100.0);
        state.rotate(90.0, 1.0, 0.0, 0.0);
        state.scale(-scale, scale, scale);
        state.translate(0.0, 0.0, 1.0);
        if (this.settings.type.hasDirection()) {
            switch (this.settings.direction) {
                case LEFT: {
                    state.translate((double)length / 2.0, 0.0, 0.0);
                    break;
                }
                case NONE: 
                case RIGHT: {
                    state.translate((double)(-length) / 2.0, 0.0, 0.0);
                }
            }
        }
        if (this.settings.type == TrackItems.CUSTOM) {
            state.translate((double)(-length) / 2.0, 0.0, 0.0);
        }
        RailRender.get(info).renderRailModel(state);
        state.translate(-0.5, 0.0, -0.5);
        RailRender.get(info).renderRailBase(state);
        if (!info.settings.railBedFill.isEmpty()) {
            StandardModel model = new StandardModel();
            for (TrackBase base : info.getBuilder(MinecraftClient.getPlayer().getWorld()).getTracksForRender()) {
                Vec3i basePos = base.getPos();
                model.addItemBlock(info.settings.railBedFill, new Matrix4().translate((double)basePos.x, (double)(basePos.y - 1), (double)basePos.z));
            }
            model.render(state);
        }
    }
}

