/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity.physics;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.entity.physics.Consist;
import cam72cam.immersiverailroading.entity.physics.SimulationState;
import cam72cam.immersiverailroading.entity.physics.chrono.ChronoState;
import cam72cam.immersiverailroading.entity.physics.chrono.ServerChronoState;
import cam72cam.immersiverailroading.net.MRSSyncPacket;
import cam72cam.immersiverailroading.physics.TickPos;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.math.Vec3i;
import cam72cam.mod.world.World;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;

public class Simulation {
    public static boolean forceQuickUpdates = false;
    public static int calculatedStates;
    public static int restStates;
    public static int keptStates;
    double maxCouplerDist = 4.0;
    private final World world;
    private final int startTickID;
    List<Map<UUID, SimulationState>> stateMaps;
    private final List<Vec3i> blocksAlreadyBroken;
    List<EntityCoupleableRollingStock> loaded;

    public Simulation(World world) {
        int i;
        restStates = 0;
        keptStates = 0;
        calculatedStates = 0;
        long startTimeMs = System.currentTimeMillis();
        this.world = world;
        this.startTickID = ((ServerChronoState)ChronoState.getState(world)).getServerTickID();
        this.stateMaps = new ArrayList<Map<UUID, SimulationState>>();
        this.blocksAlreadyBroken = new ArrayList<Vec3i>();
        for (i = 0; i < Config.ConfigDebug.physicsFutureTicks; ++i) {
            this.stateMaps.add(new HashMap());
        }
        for (i = 0; i < this.stateMaps.size() - 1; ++i) {
            this.simulateTick(i);
        }
        boolean sendPackets = world.getTicks() % (long)(Config.ConfigDebug.physicsFutureTicks / 2) == 0L;
        double syncDistanceSq = 262144.0;
        List players = sendPackets ? world.getEntities(Player.class) : null;
        for (EntityCoupleableRollingStock stock : this.loaded) {
            stock.states = this.stateMaps.stream().map(m -> (SimulationState)m.get(stock.getUUID())).filter(Objects::nonNull).collect(Collectors.toList());
            for (SimulationState state : stock.states) {
                state.dirty = false;
            }
            stock.positions = stock.states.stream().map(TickPos::new).collect(Collectors.toList());
            if (!sendPackets || !players.stream().anyMatch(player -> player.getPosition().distanceToSquared(stock.getPosition()) < syncDistanceSq)) continue;
            new MRSSyncPacket(stock, stock.positions).sendToObserving((Entity)stock);
        }
        long totalTimeMs = System.currentTimeMillis() - startTimeMs;
        if (totalTimeMs > (long)Config.ConfigDebug.physicsWarnTotalThresholdMs) {
            ImmersiveRailroading.warn((String)"Calculating Immersive Railroading Physics took %sms (%s, %s, %s)", (Object[])new Object[]{totalTimeMs, calculatedStates, restStates, keptStates});
        }
    }

    public void simulateTick(int iteration) {
        long startTimeMs = System.currentTimeMillis();
        int tickID = this.startTickID + iteration;
        Map<UUID, SimulationState> stateMap = this.stateMaps.get(iteration);
        Map<UUID, SimulationState> nextStateMap = this.stateMaps.get(iteration + 1);
        for (int tryLoad = 0; tryLoad < 10; ++tryLoad) {
            int lastCount = this.loaded == null ? 0 : this.loaded.size();
            this.loaded = this.world.getEntities(EntityCoupleableRollingStock.class);
            boolean newChunksLoaded = lastCount != this.loaded.size();
            for (EntityCoupleableRollingStock stock : this.loaded) {
                SimulationState state;
                Object state22;
                if (!stateMap.containsKey(stock.getUUID())) {
                    for (Object state22 : stock.states) {
                        int stateIteration = ((SimulationState)state22).tickID - tickID;
                        if (stateIteration < 0) continue;
                        ((SimulationState)state22).update(stock);
                        this.stateMaps.get(stateIteration).put(stock.getUUID(), (SimulationState)state22);
                    }
                    if (!stateMap.containsKey(stock.getUUID())) {
                        state = new SimulationState(stock);
                        state.tickID = tickID;
                        stateMap.put(stock.getUUID(), state);
                    }
                }
                state = stateMap.get(stock.getUUID());
                if (state.atRest && !state.dirty) continue;
                this.world.keepLoaded(new Vec3i(state.position));
                if (state.consist.positions == null) continue;
                state22 = state.consist.positions.iterator();
                while (state22.hasNext()) {
                    Vec3i pos = (Vec3i)state22.next();
                    if (this.world.isBlockLoaded(pos)) continue;
                    ImmersiveRailroading.debug((String)"Loading chunk at position %s", (Object[])new Object[]{pos});
                    this.world.getBlock(pos);
                    newChunksLoaded = true;
                }
            }
            if (!newChunksLoaded) break;
        }
        ArrayList<SimulationState> states = new ArrayList<SimulationState>(stateMap.values());
        HashSet<UUID> dirty = new HashSet<UUID>();
        for (SimulationState state : nextStateMap.values()) {
            if (!state.dirty) continue;
            dirty.addAll(state.consist.ids);
        }
        for (UUID uuid : dirty) {
            SimulationState state = stateMap.get(uuid);
            if (state == null) continue;
            state.dirty = true;
        }
        for (SimulationState state : states) {
            for (Object isMyCouplerFront : (SimulationState)new boolean[]{true, false}) {
                boolean isOtherCouplerFront;
                String myCouplerLabel;
                UUID myID = state.config.id;
                UUID otherID = isMyCouplerFront != false ? state.interactingFront : state.interactingRear;
                Vec3d myCouplerPos = isMyCouplerFront != false ? state.couplerPositionFront : state.couplerPositionRear;
                String string = myCouplerLabel = isMyCouplerFront != false ? "Front" : "Rear";
                if (otherID == null) continue;
                SimulationState other = stateMap.get(otherID);
                if (other == null) {
                    Vec3i otherPos = this.loaded.stream().filter(x -> x.getUUID().equals(myID)).findFirst().map(arg_0 -> Simulation.lambda$simulateTick$3((boolean)isMyCouplerFront, arg_0)).orElse(null);
                    if (otherPos != null && !this.world.isBlockLoaded(otherPos)) continue;
                    ImmersiveRailroading.debug((String)"%s-%s: Stock not found %s (%s) -> %s!", (Object[])new Object[]{this.startTickID, state.tickID, myID, myCouplerLabel, otherID});
                    if (isMyCouplerFront != false) {
                        state.interactingFront = null;
                    } else {
                        state.interactingRear = null;
                    }
                    state.dirty = true;
                    continue;
                }
                if (myID.equals(other.interactingFront)) {
                    isOtherCouplerFront = true;
                } else if (myID.equals(other.interactingRear)) {
                    isOtherCouplerFront = false;
                } else {
                    ImmersiveRailroading.warn((String)"%s-%s: Mismatched coupler states: %s (%s) -> %s (%s, %s)", (Object[])new Object[]{this.startTickID, state.tickID, myID, myCouplerLabel, otherID, other.interactingFront, other.interactingRear});
                    if (isMyCouplerFront != false) {
                        state.interactingFront = null;
                    } else {
                        state.interactingRear = null;
                    }
                    state.dirty = true;
                    other.dirty = true;
                    continue;
                }
                Vec3d otherCouplerPos = isOtherCouplerFront ? other.couplerPositionFront : other.couplerPositionRear;
                String otherCouplerLabel = isOtherCouplerFront ? "Front" : "Rear";
                double maxCouplerDistScaled = this.maxCouplerDist * state.config.gauge.scale();
                if (!(myCouplerPos.distanceToSquared(otherCouplerPos) > maxCouplerDistScaled * maxCouplerDistScaled)) continue;
                ImmersiveRailroading.debug((String)"%s-%s: Coupler snapping due to distance: %s (%s) -> %s (%s)", (Object[])new Object[]{this.startTickID, state.tickID, myID, myCouplerLabel, otherID, otherCouplerLabel});
                state.dirty = true;
                other.dirty = true;
                if (isMyCouplerFront != false) {
                    state.interactingFront = null;
                } else {
                    state.interactingRear = null;
                }
                if (isOtherCouplerFront) {
                    other.interactingFront = null;
                    continue;
                }
                other.interactingRear = null;
            }
        }
        for (int sai = 0; sai < states.size() - 1; ++sai) {
            SimulationState stateA = (SimulationState)states.get(sai);
            if (stateA.interactingFront != null && stateA.interactingRear != null) continue;
            for (int sbi = sai + 1; sbi < states.size(); ++sbi) {
                SimulationState stateB = (SimulationState)states.get(sbi);
                if (stateA.atRest && stateB.atRest && !stateA.dirty && !stateB.dirty || stateB.interactingFront != null && stateB.interactingRear != null || stateA.config.gauge != stateB.config.gauge) continue;
                double centerDist = stateA.config.length + stateB.config.length;
                if (stateA.position.distanceToSquared(stateB.position) > centerDist * centerDist || !stateA.bounds.intersects(stateB.bounds) || stateB.config.id.equals(stateA.interactingFront) || stateB.config.id.equals(stateA.interactingRear) || stateA.config.id.equals(stateB.interactingFront) || stateA.config.id.equals(stateB.interactingRear)) continue;
                boolean targetACouplerFront = stateA.couplerPositionFront.distanceToSquared(stateB.position) < stateA.couplerPositionRear.distanceToSquared(stateB.position);
                boolean targetBCouplerFront = stateB.couplerPositionFront.distanceToSquared(stateA.position) < stateB.couplerPositionRear.distanceToSquared(stateA.position);
                if ((targetACouplerFront ? stateA.interactingFront : stateA.interactingRear) != null || (targetBCouplerFront ? stateB.interactingFront : stateB.interactingRear) != null) continue;
                Vec3d couplerPosA = targetACouplerFront ? stateA.couplerPositionFront : stateA.couplerPositionRear;
                Vec3d couplerPosB = targetBCouplerFront ? stateB.couplerPositionFront : stateB.couplerPositionRear;
                couplerPosA = couplerPosA.add(0.0, stateB.bounds.max().subtract((Vec3d)stateB.bounds.min()).y / 2.0, 0.0);
                couplerPosB = couplerPosB.add(0.0, stateA.bounds.max().subtract((Vec3d)stateA.bounds.min()).y / 2.0, 0.0);
                if (!stateB.bounds.contains(couplerPosA) || !stateA.bounds.contains(couplerPosB)) continue;
                stateA.dirty = true;
                stateB.dirty = true;
                ImmersiveRailroading.debug((String)"%s-%s: Coupling %s (%s) to %s (%s)", (Object[])new Object[]{this.startTickID, stateA.tickID, stateA.config.id, targetACouplerFront ? "Front" : "Rear", stateB.config.id, targetBCouplerFront ? "Front" : "Rear"});
                if (targetACouplerFront) {
                    stateA.interactingFront = stateB.config.id;
                } else {
                    stateA.interactingRear = stateB.config.id;
                }
                if (targetBCouplerFront) {
                    stateB.interactingFront = stateA.config.id;
                    continue;
                }
                stateB.interactingRear = stateA.config.id;
            }
        }
        Consist.iterate(stateMap, nextStateMap, this.blocksAlreadyBroken);
        long totalTimeMs = System.currentTimeMillis() - startTimeMs;
        if (totalTimeMs > (long)Config.ConfigDebug.physicsWarnThresholdMs) {
            ImmersiveRailroading.warn((String)"Calculating Immersive Railroading Physics Iteration took %sms (%s, %s, %s)", (Object[])new Object[]{totalTimeMs, calculatedStates, restStates, keptStates});
        }
    }

    public static void simulate(World world) {
        if (world.getTicks() % 5L != 0L) {
            if (!forceQuickUpdates) {
                return;
            }
        } else {
            forceQuickUpdates = false;
        }
        new Simulation(world);
    }

    private static /* synthetic */ Vec3i lambda$simulateTick$3(boolean isMyCouplerFront, EntityCoupleableRollingStock x) {
        return isMyCouplerFront ? x.lastKnownFront : x.lastKnownRear;
    }
}

