/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ConfigSound;
import cam72cam.immersiverailroading.IRItems;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.items.ItemPaintBrush;
import cam72cam.immersiverailroading.library.Gauge;
import cam72cam.immersiverailroading.library.KeyTypes;
import cam72cam.immersiverailroading.library.ModelComponentType;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.model.part.Control;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.immersiverailroading.registry.EntityRollingStockDefinition;
import cam72cam.mod.entity.CustomEntity;
import cam72cam.mod.entity.DamageType;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.custom.IClickable;
import cam72cam.mod.entity.custom.IKillable;
import cam72cam.mod.entity.custom.ITickable;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.CustomItem;
import cam72cam.mod.item.Fuzzy;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.resource.Identifier;
import cam72cam.mod.serialization.SerializationException;
import cam72cam.mod.serialization.StrictTagMapper;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import cam72cam.mod.sound.Audio;
import cam72cam.mod.sound.ISound;
import cam72cam.mod.sound.SoundCategory;
import cam72cam.mod.text.PlayerMessage;
import cam72cam.mod.util.SingleCache;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import util.Matrix4;

public class EntityRollingStock
extends CustomEntity
implements ITickable,
IClickable,
IKillable {
    @TagField(value="defID")
    protected String defID;
    @TagField(value="gauge")
    public Gauge gauge;
    @TagField(value="tag")
    @TagSync
    public String tag = "";
    @TagSync
    @TagField(value="texture", mapper=StrictTagMapper.class)
    private String texture = null;
    private SingleCache<Vec3d, Matrix4> modelMatrix = new SingleCache(v -> new Matrix4().translate(this.getPosition().x, this.getPosition().y, this.getPosition().z).rotate(Math.toRadians(180.0f - this.getRotationYaw()), 0.0, 1.0, 0.0).rotate(Math.toRadians(this.getRotationPitch()), 1.0, 0.0, 0.0).rotate(Math.toRadians(-90.0), 0.0, 1.0, 0.0).scale(this.gauge.scale(), this.gauge.scale(), this.gauge.scale()));
    @TagSync
    @TagField(value="controlPositions", mapper=ControlPositionMapper.class)
    protected Map<String, Pair<Boolean, Float>> controlPositions = new HashMap<String, Pair<Boolean, Float>>();

    public void setup(EntityRollingStockDefinition def, Gauge gauge, String texture) {
        this.defID = def.defID;
        this.gauge = gauge;
        this.texture = texture;
        def.cgDefaults.forEach(this::setControlPosition);
    }

    public boolean isImmuneToFire() {
        return true;
    }

    public float getCollisionReduction() {
        return 1.0f;
    }

    public boolean canBePushed() {
        return false;
    }

    public boolean allowsDefaultMovement() {
        return false;
    }

    public String tryJoinWorld() {
        if (DefinitionManager.getDefinition(this.defID) == null) {
            String error = String.format("Missing definition %s, do you have all of the required resource packs?", this.defID);
            ImmersiveRailroading.error((String)error, (Object[])new Object[0]);
            return error;
        }
        return null;
    }

    public EntityRollingStockDefinition getDefinition() {
        return this.getDefinition(EntityRollingStockDefinition.class);
    }

    public <T extends EntityRollingStockDefinition> T getDefinition(Class<T> type) {
        EntityRollingStockDefinition def = DefinitionManager.getDefinition(this.defID);
        if (def == null) {
            throw new RuntimeException(String.format("Definition %s has been removed!  This stock will not function!", this.defID));
        }
        return (T)def;
    }

    public String getDefinitionID() {
        return this.defID;
    }

    public void onTick() {
        EntityRollingStockDefinition def;
        if (this.getWorld().isServer && this.getTickCount() % 5 == 0 && (def = DefinitionManager.getDefinition(this.defID)) == null) {
            this.kill();
        }
    }

    public ClickResult onClick(Player player, Player.Hand hand) {
        if (player.getHeldItem(hand).is((CustomItem)IRItems.ITEM_PAINT_BRUSH) && player.hasPermission(Permissions.PAINT_BRUSH)) {
            ItemPaintBrush.onStockInteract(this, player, hand);
            return ClickResult.ACCEPTED;
        }
        if (player.getHeldItem(hand).is(Fuzzy.NAME_TAG) && player.hasPermission(Permissions.STOCK_ASSEMBLY)) {
            if (this.getWorld().isClient) {
                return ClickResult.ACCEPTED;
            }
            this.tag = player.getHeldItem(hand).getDisplayName();
            player.sendMessage(PlayerMessage.direct((String)this.tag));
            return ClickResult.ACCEPTED;
        }
        return ClickResult.PASS;
    }

    public void setTexture(String variant) {
        if (this.getDefinition().textureNames.containsKey(variant)) {
            this.texture = variant;
        }
    }

    public void onDamage(DamageType type, Entity source, float amount, boolean bypassesArmor) {
        Player player;
        if (this.getWorld().isClient) {
            return;
        }
        if (type == DamageType.EXPLOSION && (source == null || !source.isMob()) && amount > 5.0f && Config.ConfigDamage.trainMobExplosionDamage) {
            this.kill();
        }
        if (type == DamageType.OTHER && source != null && source.isPlayer() && (player = source.asPlayer()).isCrouching()) {
            this.kill();
        }
    }

    public void onRemoved() {
    }

    protected boolean shouldDropItems(DamageType type, float amount) {
        return type != DamageType.EXPLOSION || amount < 20.0f;
    }

    public void handleKeyPress(Player source, KeyTypes key, boolean disableIndependentThrottle) {
    }

    public double getWeight() {
        return this.getDefinition().getWeight(this.gauge);
    }

    public double getMaxWeight() {
        return this.getDefinition().getWeight(this.gauge);
    }

    public float soundScale() {
        if (this.getDefinition().shouldScalePitch()) {
            double scale = this.gauge.scale() * this.getDefinition().internal_model_scale;
            return (float)Math.sqrt(Math.sqrt(scale));
        }
        return 1.0f;
    }

    public ISound createSound(Identifier oggLocation, boolean repeats, double attenuationDistance, final Supplier<Float> category) {
        final ISound snd = Audio.newSound((Identifier)oggLocation, (SoundCategory)SoundCategory.MASTER, (boolean)repeats, (float)((float)(attenuationDistance * ConfigSound.soundDistanceScale * this.gauge.scale())), (float)this.soundScale());
        return new ISound(){

            public void play(Vec3d pos) {
                snd.play(pos);
            }

            public void stop() {
                snd.stop();
            }

            public void setPosition(Vec3d pos) {
                snd.setPosition(pos);
            }

            public void setPitch(float f) {
                snd.setPitch(f);
            }

            public void setVelocity(Vec3d vel) {
                snd.setVelocity(vel);
            }

            public void setVolume(float f) {
                snd.setVolume(f * ((Float)category.get()).floatValue());
            }

            public boolean isPlaying() {
                return snd.isPlaying();
            }
        };
    }

    public String getTexture() {
        return this.texture;
    }

    public Matrix4 getModelMatrix() {
        return ((Matrix4)this.modelMatrix.get((Object)this.getPosition())).copy();
    }

    public boolean hasElectricalPower() {
        return false;
    }

    public void onDragStart(Control<?> control) {
        this.setControlPressed(control, true);
    }

    public void onDrag(Control<?> control, double newValue) {
        this.setControlPressed(control, true);
        this.setControlPosition(control, (float)newValue);
    }

    public void onDragRelease(Control<?> control) {
        this.setControlPressed(control, false);
        if (control.toggle) {
            this.setControlPosition(control, Math.abs(this.getControlPosition(control) - 1.0f));
        }
        if (control.press) {
            this.setControlPosition(control, 0.0f);
        }
    }

    protected float defaultControlPosition(Control<?> control) {
        return 0.0f;
    }

    public Pair<Boolean, Float> getControlData(String control) {
        return this.controlPositions.getOrDefault(control, (Pair<Boolean, Float>)Pair.of((Object)false, (Object)Float.valueOf(0.0f)));
    }

    public Pair<Boolean, Float> getControlData(Control<?> control) {
        return this.controlPositions.getOrDefault(control.controlGroup, (Pair<Boolean, Float>)Pair.of((Object)false, (Object)Float.valueOf(this.defaultControlPosition(control))));
    }

    public boolean getControlPressed(Control<?> control) {
        return (Boolean)this.getControlData(control).getLeft();
    }

    public void setControlPressed(Control<?> control, boolean pressed) {
        this.controlPositions.put(control.controlGroup, (Pair<Boolean, Float>)Pair.of((Object)pressed, (Object)Float.valueOf(this.getControlPosition(control))));
    }

    public float getControlPosition(Control<?> control) {
        return ((Float)this.getControlData(control).getRight()).floatValue();
    }

    public float getControlPosition(String control) {
        return ((Float)this.getControlData(control).getRight()).floatValue();
    }

    public void setControlPosition(Control<?> control, float val) {
        val = Math.min(1.0f, Math.max(0.0f, val));
        this.controlPositions.put(control.controlGroup, (Pair<Boolean, Float>)Pair.of((Object)this.getControlPressed(control), (Object)Float.valueOf(val)));
    }

    public void setControlPosition(String control, float val) {
        val = Math.min(1.0f, Math.max(0.0f, val));
        this.controlPositions.put(control, (Pair<Boolean, Float>)Pair.of((Object)false, (Object)Float.valueOf(val)));
    }

    public void setControlPositions(ModelComponentType type, float val) {
        this.getDefinition().getModel().getControls().stream().filter(x -> x.part.type == type).forEach(c -> this.setControlPosition((Control<?>)c, val));
    }

    public boolean playerCanDrag(Player player, Control<?> control) {
        return control.part.type != ModelComponentType.INDEPENDENT_BRAKE_X || player.hasPermission(Permissions.BRAKE_CONTROL);
    }

    private static class ControlPositionMapper
    implements TagMapper<Map<String, Pair<Boolean, Float>>> {
        private ControlPositionMapper() {
        }

        public TagMapper.TagAccessor<Map<String, Pair<Boolean, Float>>> apply(Class<Map<String, Pair<Boolean, Float>>> type, String fieldName, TagField tag) throws SerializationException {
            return new TagMapper.TagAccessor((d, o) -> d.setMap(fieldName, o, Function.identity(), x -> new TagCompound().setBoolean("pressed", (Boolean)x.getLeft()).setFloat("pos", (Float)x.getRight())), d -> d.getMap(fieldName, Function.identity(), x -> Pair.of((Object)(x.hasKey("pressed") && x.getBoolean("pressed") != false ? 1 : 0), (Object)x.getFloat("pos"))));
        }
    }
}

