/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading.entity;

import cam72cam.immersiverailroading.Config;
import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityBuildableRollingStock;
import cam72cam.immersiverailroading.entity.EntityCoupleableRollingStock;
import cam72cam.immersiverailroading.library.Permissions;
import cam72cam.immersiverailroading.model.part.Door;
import cam72cam.immersiverailroading.model.part.Seat;
import cam72cam.mod.entity.Entity;
import cam72cam.mod.entity.Player;
import cam72cam.mod.entity.custom.IRidable;
import cam72cam.mod.entity.sync.TagSync;
import cam72cam.mod.item.ClickResult;
import cam72cam.mod.item.ItemStack;
import cam72cam.mod.math.Vec3d;
import cam72cam.mod.serialization.SerializationException;
import cam72cam.mod.serialization.TagCompound;
import cam72cam.mod.serialization.TagField;
import cam72cam.mod.serialization.TagMapper;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;

public abstract class EntityRidableRollingStock
extends EntityBuildableRollingStock
implements IRidable {
    @TagField(value="payingPassengerPositions", mapper=PassengerMapper.class)
    private Map<UUID, Vec3d> payingPassengerPositions = new HashMap<UUID, Vec3d>();
    @TagField(value="seatedPassengers", mapper=SeatedMapper.class)
    @TagSync
    private Map<String, UUID> seatedPassengers = new HashMap<String, UUID>();
    private Map<UUID, Vec3d> remount = new HashMap<UUID, Vec3d>();

    public float getRidingSoundModifier() {
        return this.getDefinition().dampeningAmount;
    }

    @Override
    public ClickResult onClick(Player player, Player.Hand hand) {
        ClickResult clickRes = super.onClick(player, hand);
        if (clickRes != ClickResult.PASS) {
            return clickRes;
        }
        if (player.isCrouching()) {
            return ClickResult.PASS;
        }
        if (this.isPassenger((Entity)player)) {
            return ClickResult.PASS;
        }
        if (this.getWorld().isServer) {
            player.startRiding((Entity)this);
        }
        return ClickResult.ACCEPTED;
    }

    private Vec3d getSeatPosition(UUID passenger) {
        String seat = this.seatedPassengers.entrySet().stream().filter(x -> ((UUID)x.getValue()).equals(passenger)).map(Map.Entry::getKey).findFirst().orElse(null);
        return this.getDefinition().getModel().getSeats().stream().filter(s -> s.part.key.equals(seat)).map(s -> new Vec3d(s.part.center.z, s.part.min.y, -s.part.center.x).scale(this.gauge.scale()).subtract(0.0, 0.6, 0.0)).findFirst().orElse(null);
    }

    public Vec3d getMountOffset(Entity passenger, Vec3d off) {
        Vec3d seat;
        if (passenger.isVillager() && !this.payingPassengerPositions.containsKey(passenger.getUUID())) {
            this.payingPassengerPositions.put(passenger.getUUID(), passenger.getPosition());
        }
        if (passenger.isVillager() && !this.seatedPassengers.containsValue(passenger.getUUID())) {
            for (Seat<?> seat2 : this.getDefinition().getModel().getSeats()) {
                if (this.seatedPassengers.containsKey(seat2.part.key)) continue;
                this.seatedPassengers.put(seat2.part.key, passenger.getUUID());
                break;
            }
        }
        if ((seat = this.getSeatPosition(passenger.getUUID())) != null) {
            return seat;
        }
        int wiggle = passenger.isVillager() ? 10 : 0;
        off = off.add((Math.random() - 0.5) * (double)wiggle, 0.0, (Math.random() - 0.5) * (double)wiggle);
        off = this.getDefinition().correctPassengerBounds(this.gauge, off, this.shouldRiderSit(passenger));
        return off;
    }

    public boolean canFitPassenger(Entity passenger) {
        if (passenger instanceof Player && !((Player)passenger).hasPermission(Permissions.BOARD_STOCK)) {
            return false;
        }
        return this.getPassengerCount() < this.getDefinition().getMaxPassengers();
    }

    public boolean shouldRiderSit(Entity passenger) {
        boolean nonSeated = this.getDefinition().shouldSit != null ? this.getDefinition().shouldSit.booleanValue() : this.gauge.shouldSit();
        return nonSeated || this.seatedPassengers.containsValue(passenger.getUUID());
    }

    public Vec3d onPassengerUpdate(Entity passenger, Vec3d offset) {
        Vec3d seat;
        if (passenger.isPlayer()) {
            offset = this.playerMovement(passenger.asPlayer(), offset);
        }
        offset = (seat = this.getSeatPosition(passenger.getUUID())) != null ? seat : this.getDefinition().correctPassengerBounds(this.gauge, offset, this.shouldRiderSit(passenger));
        offset = offset.add(0.0, Math.sin(Math.toRadians(this.getRotationPitch())) * offset.z, 0.0);
        return offset;
    }

    private boolean isNearestDoorOpen(Player source) {
        return !this.getDefinition().getModel().getDoors().stream().filter(d -> d.type == Door.Types.CONNECTING).filter(d -> d.center(this).distanceTo(source.getPosition()) < this.getDefinition().getLength(this.gauge) / 3.0).min(Comparator.comparingDouble(d -> d.center(this).distanceTo(source.getPosition()))).filter(x -> !x.isOpen(this)).isPresent();
    }

    private Vec3d playerMovement(Player source, Vec3d offset) {
        Vec3d movement = source.getMovementInput();
        if (movement.length() < 0.1) {
            return offset;
        }
        movement = new Vec3d(movement.x, 0.0, movement.z).rotateYaw(this.getRotationYaw() - source.getRotationYawHead());
        offset = offset.add(movement);
        if (this instanceof EntityCoupleableRollingStock) {
            EntityCoupleableRollingStock couplable = (EntityCoupleableRollingStock)this;
            boolean atFront = this.getDefinition().isAtFront(this.gauge, offset);
            boolean atBack = this.getDefinition().isAtRear(this.gauge, offset);
            boolean atDoor = this.isNearestDoorOpen(source);
            atFront &= atDoor;
            atBack &= atDoor;
            for (EntityCoupleableRollingStock.CouplerType coupler : EntityCoupleableRollingStock.CouplerType.values()) {
                boolean atCoupler;
                boolean bl = atCoupler = coupler == EntityCoupleableRollingStock.CouplerType.FRONT ? atFront : atBack;
                if (!atCoupler || !couplable.isCoupled(coupler)) continue;
                EntityCoupleableRollingStock coupled = ((EntityCoupleableRollingStock)this).getCoupled(coupler);
                if (coupled != null) {
                    if (super.isNearestDoorOpen(source)) {
                        coupled.addPassenger((Entity)source);
                    }
                } else if (this.getTickCount() > 20) {
                    ImmersiveRailroading.info((String)"Tried to move between cars (%s, %s), but %s was not found", (Object[])new Object[]{this.getUUID(), couplable.getCoupledUUID(coupler), couplable.getCoupledUUID(coupler)});
                }
                return offset;
            }
        }
        if (this.getDefinition().getModel().getDoors().stream().anyMatch(x -> x.isAtOpenDoor(source, this, Door.Types.EXTERNAL)) && this.getWorld().isServer && !this.getDefinition().correctPassengerBounds(this.gauge, offset, this.shouldRiderSit((Entity)source)).equals((Object)offset)) {
            this.removePassenger((Entity)source);
        }
        return offset;
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.getWorld().isServer) {
            this.remount.forEach((uuid, pos) -> {
                Player player = (Player)this.getWorld().getEntity(uuid, Player.class);
                if (player != null) {
                    player.setPosition(pos);
                    player.startRiding((Entity)this);
                }
            });
            this.remount.clear();
            for (Player source : this.getWorld().getEntities(Player.class)) {
                if (source.getRiding() != null || !this.getDefinition().getModel().getDoors().stream().anyMatch(x -> x.isAtOpenDoor(source, this, Door.Types.EXTERNAL))) continue;
                this.addPassenger((Entity)source);
            }
        }
    }

    public Vec3d onDismountPassenger(Entity passenger, Vec3d offset) {
        List<String> seats = this.seatedPassengers.entrySet().stream().filter(x -> ((UUID)x.getValue()).equals(passenger.getUUID())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!seats.isEmpty()) {
            seats.forEach(this.seatedPassengers::remove);
            if (this.getWorld().isServer && passenger.isPlayer()) {
                this.remount.put(passenger.getUUID(), passenger.getPosition());
            }
        }
        offset = new Vec3d(Math.copySign(this.getDefinition().getWidth(this.gauge) / 2.0 + 1.0, offset.x), 0.0, offset.z);
        if (this.getWorld().isServer && passenger.isVillager() && this.payingPassengerPositions.containsKey(passenger.getUUID())) {
            double distanceMoved = passenger.getPosition().distanceTo(this.payingPassengerPositions.get(passenger.getUUID()));
            int payout = (int)Math.floor(distanceMoved * Config.ConfigBalance.villagerPayoutPerMeter);
            List<ItemStack> payouts = Config.ConfigBalance.getVillagerPayout();
            if (payouts.size() != 0) {
                int type = (int)(Math.random() * 100.0) % payouts.size();
                ItemStack stack = payouts.get(type).copy();
                stack.setCount(payout);
                this.getWorld().dropItem(stack, this.getBlockPosition());
            }
            this.payingPassengerPositions.remove(passenger.getUUID());
        }
        return offset;
    }

    public void onSeatClick(String seat, Player player) {
        List<String> seats = this.seatedPassengers.entrySet().stream().filter(x -> ((UUID)x.getValue()).equals(player.getUUID())).map(Map.Entry::getKey).collect(Collectors.toList());
        if (!seats.isEmpty()) {
            seats.forEach(this.seatedPassengers::remove);
            return;
        }
        this.seatedPassengers.put(seat, player.getUUID());
    }

    private static class SeatedMapper
    implements TagMapper<Map<String, UUID>> {
        private SeatedMapper() {
        }

        public TagMapper.TagAccessor<Map<String, UUID>> apply(Class<Map<String, UUID>> type, String fieldName, TagField tag) throws SerializationException {
            return new TagMapper.TagAccessor((d, o) -> d.setMap(fieldName, o, i -> i, u -> new TagCompound().setUUID("uuid", u)), d -> d.getMap(fieldName, i -> i, t -> t.getUUID("uuid")));
        }
    }

    private static class PassengerMapper
    implements TagMapper<Map<UUID, Vec3d>> {
        private PassengerMapper() {
        }

        public TagMapper.TagAccessor<Map<UUID, Vec3d>> apply(Class<Map<UUID, Vec3d>> type, String fieldName, TagField tag) {
            return new TagMapper.TagAccessor((d, o) -> d.setMap(fieldName, o, UUID::toString, pos -> new TagCompound().setVec3d("pos", pos)), d -> d.getMap(fieldName, UUID::fromString, t -> t.getVec3d("pos")));
        }
    }
}

