/*
 * Decompiled with CFR 0.152.
 */
package cam72cam.immersiverailroading;

import cam72cam.immersiverailroading.ImmersiveRailroading;
import cam72cam.immersiverailroading.entity.EntityRollingStock;
import cam72cam.immersiverailroading.registry.DefinitionManager;
import cam72cam.mod.entity.Player;
import cam72cam.mod.text.Command;
import cam72cam.mod.text.PlayerMessage;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class IRCommand
extends Command {
    public String getPrefix() {
        return "immersiverailroading";
    }

    public String getUsage() {
        return "Usage: immersiverailroading (reload|debug)";
    }

    public int getRequiredPermissionLevel() {
        return 4;
    }

    public boolean execute(Consumer<PlayerMessage> sender, Optional<Player> player, String[] args) {
        if (args.length != 1) {
            return false;
        }
        if (args[0].equals("reload")) {
            ImmersiveRailroading.warn((String)"Reloading Immersive Railroading definitions", (Object[])new Object[0]);
            DefinitionManager.initDefinitions();
            ImmersiveRailroading.info((String)"Done reloading Immersive Railroading definitions", (Object[])new Object[0]);
            return true;
        }
        if (args[0].equals("debug")) {
            if (player.isPresent()) {
                List ents = player.get().getWorld().getEntities(EntityRollingStock.class);
                ents.sort(Comparator.comparing(a -> a.getUUID().toString()));
                for (EntityRollingStock ent : ents) {
                    sender.accept(PlayerMessage.direct((String)String.format("%s : %s - %s : %s", ent.getUUID(), ent.getId(), ent.getDefinitionID(), ent.getPosition())));
                }
            } else {
                sender.accept(PlayerMessage.direct((String)"This command is not supported for non-players (yet)"));
            }
            return true;
        }
        return false;
    }
}

