/*
 * Decompiled with CFR 0.152.
 */
package appeng.tile.qnb;

import appeng.api.AEApi;
import appeng.api.definitions.ITileDefinition;
import appeng.api.networking.GridFlags;
import appeng.api.networking.events.MENetworkEventSubscribe;
import appeng.api.networking.events.MENetworkPowerStatusChange;
import appeng.api.util.AECableType;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.me.GridAccessException;
import appeng.me.cluster.IAECluster;
import appeng.me.cluster.IAEMultiBlock;
import appeng.me.cluster.implementations.QuantumCalculator;
import appeng.me.cluster.implementations.QuantumCluster;
import appeng.tile.grid.AENetworkInvTile;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.Platform;
import appeng.util.inv.InvOperation;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class TileQuantumBridge
extends AENetworkInvTile
implements IAEMultiBlock,
ITickable {
    private final byte corner = (byte)16;
    private final AppEngInternalInventory internalInventory = new AppEngInternalInventory(this, 1, 1);
    private final byte hasSingularity = (byte)32;
    private final byte powered = (byte)64;
    private final QuantumCalculator calc = new QuantumCalculator(this);
    private byte constructed = (byte)-1;
    private QuantumCluster cluster;
    private boolean updateStatus = false;

    public TileQuantumBridge() {
        this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        this.getProxy().setFlags(GridFlags.DENSE_CAPACITY);
        this.getProxy().setIdlePowerUsage(22.0);
    }

    public void func_73660_a() {
        if (this.updateStatus) {
            this.updateStatus = false;
            if (this.cluster != null) {
                this.cluster.updateStatus(true);
            }
            this.markForUpdate();
        }
    }

    @Override
    protected void writeToStream(ByteBuf data) throws IOException {
        super.writeToStream(data);
        int out = this.constructed;
        if (!this.internalInventory.getStackInSlot(0).func_190926_b() && this.constructed != -1) {
            out |= this.hasSingularity;
        }
        if (this.getProxy().isActive() && this.constructed != -1) {
            out |= this.powered;
        }
        data.writeByte((int)((byte)out));
    }

    @Override
    protected boolean readFromStream(ByteBuf data) throws IOException {
        boolean c = super.readFromStream(data);
        byte oldValue = this.constructed;
        this.constructed = data.readByte();
        return this.constructed != oldValue || c;
    }

    @Override
    public IItemHandler getInternalInventory() {
        return this.internalInventory;
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removed, ItemStack added) {
        if (this.cluster != null) {
            this.cluster.updateStatus(true);
        }
    }

    @Override
    protected IItemHandler getItemHandlerForSide(EnumFacing side) {
        if (this.isCenter()) {
            return this.internalInventory;
        }
        return EmptyHandler.INSTANCE;
    }

    private boolean isCenter() {
        return AEApi.instance().definitions().blocks().quantumLink().maybeBlock().map(link -> this.func_145838_q() == link).orElse(false);
    }

    @MENetworkEventSubscribe
    public void onPowerStatusChange(MENetworkPowerStatusChange c) {
        this.updateStatus = true;
    }

    @Override
    public void onChunkUnload() {
        this.disconnect(false);
        super.onChunkUnload();
    }

    @Override
    public void onReady() {
        boolean isPresent;
        super.onReady();
        ITileDefinition quantumRing = AEApi.instance().definitions().blocks().quantumRing();
        Optional<Block> maybeLinkBlock = quantumRing.maybeBlock();
        Optional<ItemStack> maybeLinkStack = quantumRing.maybeStack(1);
        boolean bl = isPresent = maybeLinkBlock.isPresent() && maybeLinkStack.isPresent();
        if (isPresent && this.func_145838_q() == maybeLinkBlock.get()) {
            ItemStack linkStack = maybeLinkStack.get();
            this.getProxy().setVisualRepresentation(linkStack);
        }
    }

    @Override
    public void func_145843_s() {
        this.disconnect(false);
        super.func_145843_s();
    }

    @Override
    public void disconnect(boolean affectWorld) {
        if (this.cluster != null) {
            if (!affectWorld) {
                this.cluster.setUpdateStatus(false);
            }
            this.cluster.destroy();
        }
        this.cluster = null;
        if (affectWorld) {
            this.getProxy().setValidSides(EnumSet.noneOf(EnumFacing.class));
        }
    }

    @Override
    public IAECluster getCluster() {
        return this.cluster;
    }

    @Override
    public boolean isValid() {
        return !this.func_145837_r();
    }

    public void updateStatus(QuantumCluster c, byte flags, boolean affectWorld) {
        this.cluster = c;
        if (affectWorld) {
            if (this.constructed != flags) {
                this.constructed = flags;
                this.markForUpdate();
            }
            if (this.isCorner() || this.isCenter()) {
                EnumSet<EnumFacing> sides = EnumSet.noneOf(EnumFacing.class);
                for (EnumFacing dir : this.getAdjacentQuantumBridges()) {
                    sides.add(dir);
                }
                this.getProxy().setValidSides(sides);
            } else {
                this.getProxy().setValidSides(EnumSet.allOf(EnumFacing.class));
            }
        }
    }

    public boolean isCorner() {
        return (this.constructed & this.getCorner()) == this.getCorner() && this.constructed != -1;
    }

    public EnumSet<EnumFacing> getAdjacentQuantumBridges() {
        EnumSet<EnumFacing> set = EnumSet.noneOf(EnumFacing.class);
        for (EnumFacing d : EnumFacing.values()) {
            TileEntity te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(d));
            if (!(te instanceof TileQuantumBridge)) continue;
            set.add(d);
        }
        return set;
    }

    public long getQEFrequency() {
        NBTTagCompound c;
        ItemStack is = this.internalInventory.getStackInSlot(0);
        if (!is.func_190926_b() && (c = is.func_77978_p()) != null) {
            return c.func_74763_f("freq");
        }
        return 0L;
    }

    public boolean isPowered() {
        if (Platform.isClient()) {
            return (this.constructed & this.powered) == this.powered && this.constructed != -1;
        }
        try {
            return this.getProxy().getEnergy().isNetworkPowered();
        }
        catch (GridAccessException gridAccessException) {
            return false;
        }
    }

    public boolean isFormed() {
        return this.constructed != -1;
    }

    @Override
    public AECableType getCableConnectionType(AEPartLocation dir) {
        return AECableType.DENSE_SMART;
    }

    public void neighborUpdate() {
        this.calc.calculateMultiblock(this.field_145850_b, this.getLocation());
    }

    @Override
    public DimensionalCoord getLocation() {
        return new DimensionalCoord(this);
    }

    public boolean hasQES() {
        if (this.constructed == -1) {
            return false;
        }
        return (this.constructed & this.hasSingularity) == this.hasSingularity;
    }

    public void breakCluster() {
        if (this.cluster != null) {
            this.cluster.destroy();
        }
    }

    public byte getCorner() {
        return this.corner;
    }
}

