/*
 * Decompiled with CFR 0.152.
 */
package appeng.thirdparty.codechicken.lib.model.pipeline.transformers;

import appeng.thirdparty.codechicken.lib.model.Quad;
import appeng.thirdparty.codechicken.lib.model.pipeline.IPipelineElementFactory;
import appeng.thirdparty.codechicken.lib.model.pipeline.QuadTransformer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3i;

public class QuadCornerKicker
extends QuadTransformer {
    public static final IPipelineElementFactory<QuadCornerKicker> FACTORY = QuadCornerKicker::new;
    public static int[][] horizonals = new int[][]{{2, 3, 4, 5}, {2, 3, 4, 5}, {0, 1, 4, 5}, {0, 1, 4, 5}, {0, 1, 2, 3}, {0, 1, 2, 3}};
    private int mySide;
    private int facadeMask;
    private AxisAlignedBB box;
    private double thickness;

    QuadCornerKicker() {
    }

    public void setSide(int side) {
        this.mySide = side;
    }

    public void setFacadeMask(int mask) {
        this.facadeMask = mask;
    }

    public void setBox(AxisAlignedBB box) {
        this.box = box;
    }

    public void setThickness(double thickness) {
        this.thickness = thickness;
    }

    @Override
    public boolean transform() {
        int side = this.quad.orientation.ordinal();
        if (side != this.mySide && side != (this.mySide ^ 1)) {
            for (int hoz : horizonals[this.mySide]) {
                if (side == hoz || side == (hoz ^ 1) || (this.facadeMask & 1 << hoz) == 0) continue;
                Corner corner = Corner.fromSides(this.mySide ^ 1, side, hoz);
                for (Quad.Vertex vertex : this.quad.vertices) {
                    float x = vertex.vec[0];
                    float y = vertex.vec[1];
                    float z = vertex.vec[2];
                    if (!QuadCornerKicker.epsComp(x, corner.pX(this.box)) || !QuadCornerKicker.epsComp(y, corner.pY(this.box)) || !QuadCornerKicker.epsComp(z, corner.pZ(this.box))) continue;
                    Vec3i vec = EnumFacing.field_82609_l[hoz].func_176730_m();
                    x = (float)((double)x - (double)vec.func_177958_n() * this.thickness);
                    y = (float)((double)y - (double)vec.func_177956_o() * this.thickness);
                    z = (float)((double)z - (double)vec.func_177952_p() * this.thickness);
                    vertex.vec[0] = x;
                    vertex.vec[1] = y;
                    vertex.vec[2] = z;
                }
            }
        }
        return true;
    }

    public static enum Corner {
        MIN_X_MIN_Y_MIN_Z(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE),
        MIN_X_MIN_Y_MAX_Z(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE),
        MIN_X_MAX_Y_MIN_Z(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE),
        MIN_X_MAX_Y_MAX_Z(EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE),
        MAX_X_MIN_Y_MIN_Z(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.NEGATIVE),
        MAX_X_MIN_Y_MAX_Z(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE, EnumFacing.AxisDirection.POSITIVE),
        MAX_X_MAX_Y_MIN_Z(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.NEGATIVE),
        MAX_X_MAX_Y_MAX_Z(EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE, EnumFacing.AxisDirection.POSITIVE);

        private EnumFacing.AxisDirection xAxis;
        private EnumFacing.AxisDirection yAxis;
        private EnumFacing.AxisDirection zAxis;
        private static final int[] sideMask;

        private Corner(EnumFacing.AxisDirection xAxis, EnumFacing.AxisDirection yAxis, EnumFacing.AxisDirection zAxis) {
            this.xAxis = xAxis;
            this.yAxis = yAxis;
            this.zAxis = zAxis;
        }

        public static Corner fromSides(int sideA, int sideB, int sideC) {
            return Corner.values()[sideMask[sideA] | sideMask[sideB] | sideMask[sideC]];
        }

        public float pX(AxisAlignedBB box) {
            return (float)(this.xAxis == EnumFacing.AxisDirection.NEGATIVE ? box.field_72340_a : box.field_72336_d);
        }

        public float pY(AxisAlignedBB box) {
            return (float)(this.yAxis == EnumFacing.AxisDirection.NEGATIVE ? box.field_72338_b : box.field_72337_e);
        }

        public float pZ(AxisAlignedBB box) {
            return (float)(this.zAxis == EnumFacing.AxisDirection.NEGATIVE ? box.field_72339_c : box.field_72334_f);
        }

        static {
            sideMask = new int[]{0, 2, 0, 1, 0, 4};
        }
    }
}

