/*
 * Decompiled with CFR 0.152.
 */
package appeng.services.compass;

import appeng.services.compass.CompassRegion;
import com.google.common.base.Preconditions;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nonnull;

public final class CompassReader {
    private final Map<Long, CompassRegion> regions = new HashMap<Long, CompassRegion>(100);
    private final int dimensionId;
    private final File worldCompassFolder;

    public CompassReader(int dimensionId, @Nonnull File worldCompassFolder) {
        Preconditions.checkNotNull((Object)worldCompassFolder);
        Preconditions.checkArgument((boolean)worldCompassFolder.isDirectory());
        this.dimensionId = dimensionId;
        this.worldCompassFolder = worldCompassFolder;
    }

    public void close() {
        for (CompassRegion r : this.regions.values()) {
            r.close();
        }
        this.regions.clear();
    }

    public void setHasBeacon(int cx, int cz, int cdy, boolean hasBeacon) {
        CompassRegion r = this.getRegion(cx, cz);
        r.setHasBeacon(cx, cz, cdy, hasBeacon);
    }

    public boolean hasBeacon(int cx, int cz) {
        CompassRegion r = this.getRegion(cx, cz);
        return r.hasBeacon(cx, cz);
    }

    private CompassRegion getRegion(int cx, int cz) {
        long pos = cx >> 10;
        pos <<= 32;
        CompassRegion cr = this.regions.get(pos |= (long)(cz >> 10));
        if (cr == null) {
            cr = new CompassRegion(cx, cz, this.dimensionId, this.worldCompassFolder);
            this.regions.put(pos, cr);
        }
        return cr;
    }
}

