/*
 * Decompiled with CFR 0.152.
 */
package appeng.fluids.util;

import appeng.api.config.SortDir;
import appeng.api.storage.data.IAEFluidStack;
import appeng.fluids.util.AEFluidStack;
import appeng.util.Platform;
import java.util.Comparator;

public class FluidSorters {
    private static SortDir Direction = SortDir.ASCENDING;
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_NAME = (o1, o2) -> {
        if (FluidSorters.getDirection() == SortDir.ASCENDING) {
            return Platform.getFluidDisplayName(o1).compareToIgnoreCase(Platform.getFluidDisplayName(o2));
        }
        return Platform.getFluidDisplayName(o2).compareToIgnoreCase(Platform.getFluidDisplayName(o1));
    };
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_MOD = new Comparator<IAEFluidStack>(){

        @Override
        public int compare(IAEFluidStack o1, IAEFluidStack o2) {
            AEFluidStack op1 = (AEFluidStack)o1;
            AEFluidStack op2 = (AEFluidStack)o2;
            if (FluidSorters.getDirection() == SortDir.ASCENDING) {
                return this.secondarySort(Platform.getModId(op1).compareToIgnoreCase(Platform.getModId(op2)), o2, o1);
            }
            return this.secondarySort(Platform.getModId(op2).compareToIgnoreCase(Platform.getModId(op1)), o1, o2);
        }

        private int secondarySort(int compareToIgnoreCase, IAEFluidStack o1, IAEFluidStack o2) {
            if (compareToIgnoreCase == 0) {
                return Platform.getFluidDisplayName(o2).compareToIgnoreCase(Platform.getFluidDisplayName(o1));
            }
            return compareToIgnoreCase;
        }
    };
    public static final Comparator<IAEFluidStack> CONFIG_BASED_SORT_BY_SIZE = (o1, o2) -> {
        if (FluidSorters.getDirection() == SortDir.ASCENDING) {
            return Long.compare(o2.getStackSize(), o1.getStackSize());
        }
        return Long.compare(o1.getStackSize(), o2.getStackSize());
    };

    private static SortDir getDirection() {
        return Direction;
    }

    public static void setDirection(SortDir direction) {
        Direction = direction;
    }
}

