/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.helpers;

import ic2.core.RotationList;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.MathHelper;

public final class ConnectionState {
    static final ConnectionState[] STATES = ConnectionState.createArray();
    int code;
    int size;
    Connection[] array;

    private ConnectionState() {
        throw new RuntimeException("NOT ALLOWED!");
    }

    private ConnectionState(int code) {
        this.code = MathHelper.func_76125_a((int)code, (int)0, (int)15);
        ObjectArrayList list = new ObjectArrayList();
        for (int i = 0; i < 4; ++i) {
            if ((code & 1 << i) == 0) continue;
            list.add((Object)Connection.byIndex(i));
        }
        this.size = list.size();
        this.array = (Connection[])list.toArray((Object[])new Connection[list.size()]);
    }

    public static ConnectionState fromList(RotationList list, EnumFacing dir) {
        return ConnectionState.fromList(list, dir.func_176740_k());
    }

    public static ConnectionState fromList(RotationList list, EnumFacing.Axis axis) {
        int index = 0;
        for (EnumFacing dir : list.remove(RotationList.ofAxis(axis))) {
            index |= 1 << Connection.byFacing(dir, axis).getIndex();
        }
        return STATES[index];
    }

    public int size() {
        return this.size;
    }

    public int getCode() {
        return this.code;
    }

    public int getIndex() {
        switch (this.size) {
            case 0: {
                return 0;
            }
            case 1: {
                return this.array[0].getIndex();
            }
            case 2: {
                return this.array[0].getOpposite() == this.array[1] ? (this.array[0].isVertical() ? 0 : 1) : this.array[0].getCornerIndex(this.array[1]);
            }
            case 3: {
                return ConnectionState.STATES[15 - this.code].array[0].getIndex();
            }
        }
        return 0;
    }

    public static ConnectionState fromIndex(int index) {
        return STATES[index];
    }

    static ConnectionState[] createArray() {
        ConnectionState[] states = new ConnectionState[16];
        for (int i = 0; i < 16; ++i) {
            states[i] = new ConnectionState(i);
        }
        return states;
    }

    public static enum Connection {
        UP(0, 2),
        EAST(1, 3),
        DOWN(2, 0),
        WEST(3, 1);

        static final Connection[] MAPPED;
        int index;
        int opposite;

        private Connection(int index, int opposite) {
            this.index = index;
            this.opposite = opposite;
        }

        public Connection getOpposite() {
            return MAPPED[this.opposite];
        }

        public int getCornerIndex(Connection other) {
            if (other.getIndex() == this.index || other.getIndex() == this.opposite) {
                throw new IllegalStateException("Illegal State");
            }
            if (this.isVertical()) {
                return other == WEST ? (this == UP ? 3 : 2) : (this == UP ? 0 : 1);
            }
            return this == WEST ? (other == UP ? 3 : 2) : (other == UP ? 0 : 1);
        }

        public boolean isVertical() {
            return this.index < 2;
        }

        public int getIndex() {
            return this.index;
        }

        protected int convert(EnumFacing side, EnumFacing index) {
            switch (side.func_176740_k()) {
                case X: {
                    switch (index) {
                        case DOWN: {
                            return 0;
                        }
                        case UP: {
                            return 1;
                        }
                        case NORTH: {
                            return 2;
                        }
                        case SOUTH: {
                            return 3;
                        }
                    }
                    return -1;
                }
                case Y: {
                    switch (index) {
                        case WEST: {
                            return 0;
                        }
                        case EAST: {
                            return 1;
                        }
                        case NORTH: {
                            return 2;
                        }
                        case SOUTH: {
                            return 3;
                        }
                    }
                    return -1;
                }
                case Z: {
                    switch (index) {
                        case DOWN: {
                            return 0;
                        }
                        case UP: {
                            return 1;
                        }
                        case WEST: {
                            return 2;
                        }
                        case EAST: {
                            return 3;
                        }
                    }
                    return -1;
                }
            }
            return 0;
        }

        public static Connection byFacing(EnumFacing dir, EnumFacing.Axis axis) {
            switch (axis) {
                case X: {
                    switch (dir) {
                        case DOWN: {
                            return DOWN;
                        }
                        case UP: {
                            return UP;
                        }
                        case NORTH: {
                            return WEST;
                        }
                        case SOUTH: {
                            return EAST;
                        }
                    }
                    throw new IllegalStateException("Not a Valid Facing");
                }
                case Y: {
                    return MAPPED[dir.func_176736_b()];
                }
                case Z: {
                    switch (dir) {
                        case DOWN: {
                            return DOWN;
                        }
                        case UP: {
                            return UP;
                        }
                        case WEST: {
                            return WEST;
                        }
                        case EAST: {
                            return EAST;
                        }
                    }
                    throw new IllegalStateException("Not a Valid Facing");
                }
            }
            throw new IllegalStateException("Not a Valid Axis");
        }

        public static Connection byIndex(int index) {
            return MAPPED[index & 3];
        }

        static {
            Connection[] array = Connection.values();
            MAPPED = new Connection[array.length];
            for (Connection Connection.MAPPED[array[i].getIndex()] : array) {
            }
        }
    }
}

