/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.util.events;

import ic2.api.classic.energy.tile.IEnergyConductorColored;
import ic2.api.classic.event.FoamEvent;
import ic2.api.classic.event.RetextureEventClassic;
import ic2.core.block.misc.BlockScaffoldBase;
import ic2.core.block.misc.tile.TileEntityTexturedWall;
import ic2.core.block.wiring.tile.TileEntityCable;
import ic2.core.platform.registry.Ic2States;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class IC2Events {
    @SubscribeEvent
    public void foamCheckEvent(FoamEvent.Check event) {
        TileEntity tile;
        if (event.hasCustomTarget()) {
            return;
        }
        Block block = event.getBlock();
        if (block instanceof BlockScaffoldBase) {
            event.setResult(FoamEvent.FoamResult.Scaffold);
            return;
        }
        if (block == Ic2States.copperCable.func_177230_c() && (tile = event.getTileEntity()) instanceof TileEntityCable) {
            TileEntityCable cable = (TileEntityCable)tile;
            if (cable.foamed == 0) {
                event.setResult(FoamEvent.FoamResult.Cable);
                return;
            }
        }
    }

    @SubscribeEvent
    public void foamPlaceEvent(FoamEvent.Place event) {
        TileEntityCable cable;
        TileEntity tile;
        Block block = event.getBlock();
        if (block == Ic2States.woodenScaffold.func_177230_c()) {
            block.func_176226_b(event.getWorld(), event.getPos(), event.getBlockState(), 0);
            event.requestFoamPlacement();
            event.setCanceled(true);
            return;
        }
        if (block == Ic2States.ironScaffold.func_177230_c()) {
            event.getWorld().func_175656_a(event.getPos(), Ic2States.constructionFoamReinforced);
            event.setCanceled(true);
            return;
        }
        if (block == Ic2States.copperCable.func_177230_c() && (tile = event.getTileEntity()) instanceof TileEntityCable && (cable = (TileEntityCable)tile).changeFoam((byte)1)) {
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void retextureEvent(RetextureEventClassic event) {
        IBlockState state;
        if (event.isApplied() || event.isCanceled()) {
            return;
        }
        EntityPlayer player = event.getApplingPlayer();
        TileEntity tile = event.getTargetTile();
        if (tile != null) {
            if (tile instanceof TileEntityCable) {
                TileEntityCable cable = (TileEntityCable)tile;
                if (cable.add(event.getTargetSide(), event.getModelState(), event.getRenderState(), event.getColorMultipliers(), event.getRotations(), event.getRefSide())) {
                    event.setApplied(true);
                }
                return;
            }
            if (tile instanceof TileEntityTexturedWall) {
                TileEntityTexturedWall tex = (TileEntityTexturedWall)tile;
                if (tex.add(event.getTargetSide(), event.getModelState(), event.getRenderState(), event.getColorMultipliers(), event.getRotations(), event.getRefSide())) {
                    event.setApplied(true);
                }
                return;
            }
        }
        if ((state = event.getTargetState()).func_177230_c() == Ic2States.cfWallBlack.func_177230_c() && event.getWorld().func_175656_a(event.getTargetPos(), Ic2States.texturedWall) && (tile = event.getTargetTile()) instanceof TileEntityTexturedWall) {
            TileEntityTexturedWall tex = (TileEntityTexturedWall)tile;
            tex.getStorage().setAll(IEnergyConductorColored.WireColor.values()[1 + state.func_177230_c().func_176201_c(state)]);
            if (tex.add(event.getTargetSide(), event.getModelState(), event.getRenderState(), event.getColorMultipliers(), event.getRotations(), event.getRefSide())) {
                event.setApplied(true);
                return;
            }
        }
    }
}

