/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades.subtypes.machine;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.core.IC2;
import ic2.core.item.upgrades.subtypes.machine.BaseMetaUpgrade;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Formatters;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Enchantments;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ExpCollectorUpgrade
extends BaseMetaUpgrade {
    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        return 5;
    }

    @Override
    public void onProcessEndPre(ItemStack upgrade, IMachine machine, MachineOutput output) {
        float exp = output.getExperienceOutput();
        if (exp > 0.0f) {
            this.addExp(upgrade, exp /= 2.0f);
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType() {
        return IMachineUpgradeItem.UpgradeType.Processing;
    }

    @Override
    public LocaleComp getName() {
        return Ic2ItemLang.expCollectorUpgrade;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture() {
        return Ic2Icons.getTextures("i0")[140];
    }

    @Override
    public int getMaxStackSize(ItemStack stack) {
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInfo(ItemStack par1, EntityPlayer par2, List<String> par3, Map<ToolTipType, List<String>> sortedTooltip) {
        par3.add(Ic2InfoLang.upgradeXPStored.getLocalizedFormatted(Ic2Formatters.floatFormat.format(this.getStoredExp(par1))));
    }

    @Override
    public boolean usesExtraRightClick(ItemStack item) {
        return true;
    }

    @Override
    public void onRightClick(ItemStack item, World world, EntityPlayer player, EnumHand hand) {
        int exp = (int)this.getExp(item);
        if (exp > 0) {
            int left;
            world.func_184148_a((EntityPlayer)null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, 0.5f * ((IC2.random.nextFloat() - IC2.random.nextFloat()) * 0.7f + 1.8f));
            ItemStack itemstack = EnchantmentHelper.func_92099_a((Enchantment)Enchantments.field_185296_A, (EntityLivingBase)player);
            int used = 0;
            if (!itemstack.func_190926_b() && itemstack.func_77951_h()) {
                int i = Math.min(exp * 2, itemstack.func_77952_i());
                used += i * 2;
                itemstack.func_77964_b(itemstack.func_77952_i() - i);
            }
            if ((left = exp - used) > 0) {
                player.func_71023_q(left);
            }
            this.removeExp(item, exp);
        }
    }

    public void addExp(ItemStack item, float exp) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        float stuff = nbt.func_74760_g("Exp");
        if ((stuff += exp) > 5000.0f) {
            stuff = 5000.0f;
        }
        nbt.func_74776_a("Exp", stuff);
    }

    public void removeExp(ItemStack par1, float exp) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        float amount = nbt.func_74760_g("Exp");
        if ((amount -= exp) < 0.0f) {
            amount = 0.0f;
        }
        nbt.func_74776_a("Exp", amount);
    }

    public float getExp(ItemStack item) {
        return StackUtil.getNbtData(item).func_74760_g("Exp");
    }

    public double getStoredExp(ItemStack par1) {
        return this.getExp(par1);
    }
}

