/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.upgrades;

import ic2.api.classic.item.IMachineUpgradeItem;
import ic2.api.classic.recipe.machine.MachineOutput;
import ic2.api.classic.tile.IMachine;
import ic2.api.classic.tile.IStackOutput;
import ic2.api.recipe.IRecipeInput;
import ic2.core.IC2;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.item.base.ItemIC2;
import ic2.core.item.inv.inventories.InventoryUpgradeContainer;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import ic2.core.util.obj.ToolTipType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemUpgradeContainer
extends ItemIC2
implements IMachineUpgradeItem,
IHandHeldInventory {
    public ItemUpgradeContainer() {
        this.setTranslationKey(Ic2ItemLang.inventoryContainer);
        this.func_77625_d(1);
    }

    @Override
    public void onSortedItemToolTip(ItemStack stack, EntityPlayer player, boolean debugTooltip, List<String> tooltip, Map<ToolTipType, List<String>> sortedTooltip) {
        super.onSortedItemToolTip(stack, player, debugTooltip, tooltip, sortedTooltip);
        List<String> ctrlTip = sortedTooltip.get((Object)ToolTipType.Ctrl);
        ctrlTip.add(Ic2Lang.onItemRightClick.getLocalized());
        ctrlTip.add(TextFormatting.UNDERLINE + Ic2Lang.openTheItemInventory.getLocalized());
        List<String> shiftTip = sortedTooltip.get((Object)ToolTipType.Shift);
        ItemStack[] items = this.getItems(stack);
        for (int i = 0; i < items.length; ++i) {
            ItemStack item = items[i];
            if (item == null) continue;
            shiftTip.add(item.func_190916_E() + "x " + item.func_82833_r());
        }
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    public IHasGui getInventory(EntityPlayer player, EnumHand hand, ItemStack stack) {
        return new InventoryUpgradeContainer(player, this, stack);
    }

    @Override
    public int getGuiId(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        if (nbt.func_74764_b("GuiID")) {
            return nbt.func_74762_e("GuiID");
        }
        return -1;
    }

    @Override
    public void setGuiID(ItemStack stack, int id) {
        if (id == -1) {
            StackUtil.getOrCreateNbtData(stack).func_82580_o("GuiID");
            return;
        }
        StackUtil.getOrCreateNbtData(stack).func_74768_a("GuiID", id);
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (IC2.platform.isSimulating()) {
            IC2.platform.launchGui(playerIn, this.getInventory(playerIn, handIn, stack), handIn);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)stack);
    }

    @Override
    public int getExtraProcessSpeed(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraProcessSpeed(stack, machine) * stack.func_190916_E();
        }
        return result;
    }

    @Override
    public double getProcessSpeedMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getProcessSpeedMultiplier(stack, machine), stack.func_190916_E());
        }
        return result;
    }

    @Override
    public int getExtraProcessTime(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraProcessTime(stack, machine) * stack.func_190916_E();
        }
        return result;
    }

    @Override
    public double getProcessTimeMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getProcessTimeMultiplier(stack, machine), stack.func_190916_E());
        }
        return result;
    }

    @Override
    public int getExtraEnergyDemand(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraEnergyDemand(stack, machine) * stack.func_190916_E();
        }
        return result;
    }

    @Override
    public double getEnergyDemandMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getEnergyDemandMultiplier(stack, machine), stack.func_190916_E());
        }
        return result;
    }

    @Override
    public int getExtraEnergyStorage(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraEnergyStorage(stack, machine) * stack.func_190916_E();
        }
        return result;
    }

    @Override
    public double getEnergyStorageMultiplier(ItemStack upgrade, IMachine machine) {
        double result = 1.0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result *= Math.pow(item.getEnergyStorageMultiplier(stack, machine), stack.func_190916_E());
        }
        return result;
    }

    @Override
    public int getExtraTier(ItemStack upgrade, IMachine machine) {
        int result = 0;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result += item.getExtraTier(stack, machine) * stack.func_190916_E();
        }
        return result;
    }

    @Override
    public float getSoundVolumeMultiplier(ItemStack upgrade, IMachine machine) {
        float result = 1.0f;
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            result = (float)((double)result * Math.pow(item.getEnergyStorageMultiplier(stack, machine), stack.func_190916_E()));
        }
        return result;
    }

    @Override
    public boolean useRedstoneInverter(ItemStack upgrade, IMachine machine) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null || !item.useRedstoneInverter(stack, machine)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void onInstalling(ItemStack upgrade, IMachine machine) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        ItemStack[] items = this.getItems(upgrade);
        for (int i = 0; i < items.length; ++i) {
            IMachineUpgradeItem item = this.getItem(items[i]);
            if (item == null) continue;
            IMachineUpgradeItem.UpgradeType type = item.getType(items[i]);
            if (!machine.getSupportedTypes().contains((Object)type)) continue;
            ints.add(i);
        }
        for (Integer slot : ints) {
            IMachineUpgradeItem item = this.getItem(items[slot]);
            item.onInstalling(items[slot], machine);
        }
        int[] data = new int[ints.size()];
        for (int i = 0; i < ints.size(); ++i) {
            data[i] = (Integer)ints.get(i);
        }
        this.setValidSlots(upgrade, data);
    }

    @Override
    public void onTick(ItemStack upgrade, IMachine machine) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            item.onTick(stack, machine);
        }
    }

    @Override
    public void onProcessFinished(ItemStack upgrade, IMachine machine) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            item.onProcessFinished(stack, machine);
        }
    }

    @Override
    public void onProcessEndPre(ItemStack upgrade, IMachine machine, MachineOutput output) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            item.onProcessEndPre(stack, machine, output);
        }
    }

    @Override
    public void onProcessEndPost(ItemStack upgrade, IMachine machine, IRecipeInput input, MachineOutput output, List<IStackOutput> results) {
        for (ItemStack stack : this.getValidItems(upgrade)) {
            IMachineUpgradeItem item = this.getItem(stack);
            if (item == null) continue;
            item.onProcessEndPost(stack, machine, input, output, results);
        }
    }

    @Override
    public IMachineUpgradeItem.UpgradeType getType(ItemStack par1) {
        return IMachineUpgradeItem.UpgradeType.Custom;
    }

    @Override
    public int getTextureEntry(int meta) {
        return 143;
    }

    @Override
    public String getSheet(int meta) {
        return "i0";
    }

    public void setValidSlots(ItemStack item, int[] par1) {
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(item);
        nbt.func_74783_a("ValidSlots", par1);
    }

    public int[] getValidSlots(ItemStack item) {
        return StackUtil.getNbtData(item).func_74759_k("ValidSlots");
    }

    public ItemStack[] getValidItems(ItemStack par1) {
        int[] validSlots = this.getValidSlots(par1);
        ItemStack[] items = new ItemStack[validSlots.length];
        ItemStack[] possible = this.getItems(par1);
        for (int i = 0; i < validSlots.length; ++i) {
            items[i] = possible[validSlots[i]];
        }
        return items;
    }

    public ItemStack[] getItems(ItemStack par1) {
        if (par1.func_77978_p() == null) {
            return new ItemStack[0];
        }
        NBTTagCompound nbt = StackUtil.getOrCreateNbtData(par1);
        NBTTagList list = nbt.func_150295_c("Items", 10);
        ItemStack[] items = new ItemStack[3];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound slotNBT = list.func_150305_b(i);
            byte slot = slotNBT.func_74771_c("Slot");
            if (slot < 0 || slot >= 3) continue;
            items[slot] = new ItemStack(slotNBT);
        }
        return items;
    }

    public IMachineUpgradeItem getItem(ItemStack par1) {
        if (!(par1.func_77973_b() instanceof IMachineUpgradeItem)) {
            return null;
        }
        return (IMachineUpgradeItem)par1.func_77973_b();
    }
}

