/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.recipe;

import ic2.api.classic.recipe.custom.IOreRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;

public class OreRegistry
implements IOreRegistry {
    public Map<Block, Map<Integer, Integer>> registry = new HashMap<Block, Map<Integer, Integer>>();
    public Map<Integer, List<IBlockState>> reverse = new HashMap<Integer, List<IBlockState>>();
    public int highestValue = 0;

    @Override
    public void registerValueableOre(Block block, int value) {
        if (block == null || value <= 0) {
            return;
        }
        Map<Integer, Integer> map = this.registry.get(block);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this.registry.put(block, map);
        }
        map.clear();
        map.put((Integer)Short.MAX_VALUE, value);
        List<IBlockState> states = this.reverse.get(value);
        if (states == null) {
            states = new ArrayList<IBlockState>();
            this.reverse.put(value, states);
        }
        states.addAll((Collection<IBlockState>)block.func_176194_O().func_177619_a());
        if (value > this.highestValue) {
            this.highestValue = value;
        }
    }

    @Override
    public void registerValueableOre(IBlockState state, int value) {
        if (state == null || state.func_177230_c() == null) {
            return;
        }
        Block block = state.func_177230_c();
        Map<Integer, Integer> map = this.registry.get(block);
        if (map == null) {
            map = new HashMap<Integer, Integer>();
            this.registry.put(block, map);
        }
        if (map.containsKey(Short.MAX_VALUE)) {
            return;
        }
        map.put(block.func_176201_c(state), value);
        List<IBlockState> states = this.reverse.get(value);
        if (states == null) {
            states = new ArrayList<IBlockState>();
            this.reverse.put(value, states);
        }
        states.add(state);
        if (value > this.highestValue) {
            this.highestValue = value;
        }
    }

    @Override
    public int getOreValue(IBlockState state) {
        if (state == null || state.func_177230_c() == null) {
            return 0;
        }
        Block block = state.func_177230_c();
        Map<Integer, Integer> map = this.registry.get(block);
        if (map == null) {
            return 0;
        }
        if (map.containsKey(Short.MAX_VALUE)) {
            return map.get(Short.MAX_VALUE);
        }
        int meta = block.func_176201_c(state);
        if (map.containsKey(meta)) {
            return map.get(meta);
        }
        return 0;
    }

    @Override
    public int getOreValue(Block block) {
        if (block == null) {
            return 0;
        }
        Map<Integer, Integer> map = this.registry.get(block);
        if (map == null || !map.containsKey(Short.MAX_VALUE)) {
            return 0;
        }
        return map.get(Short.MAX_VALUE);
    }

    @Override
    public int getHighestOreValue() {
        return this.highestValue;
    }

    @Override
    public Map<Block, Map<Integer, Integer>> getOreValueMap() {
        return this.registry;
    }

    @Override
    public Map<Integer, List<IBlockState>> getValueToOresMap() {
        return this.reverse;
    }

    @Override
    public void removeOreEntry(IBlockState state) {
        if (state == null || state.func_177230_c() == null) {
            return;
        }
        Block block = state.func_177230_c();
        int meta = block.func_176201_c(state);
        Map<Integer, Integer> map = this.registry.get(block);
        if (map.containsKey(meta)) {
            map.remove(meta);
            if (map.isEmpty()) {
                this.registry.remove(block);
            }
        }
        Iterator<Map.Entry<Integer, List<IBlockState>>> iter = this.reverse.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, List<IBlockState>> entry = iter.next();
            List<IBlockState> states = entry.getValue();
            states.remove(state);
            if (!states.isEmpty()) continue;
            iter.remove();
        }
    }

    @Override
    public void removeOre(Block block) {
        if (block == null) {
            return;
        }
        this.registry.remove(block);
        Iterator<Map.Entry<Integer, List<IBlockState>>> iter = this.reverse.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<Integer, List<IBlockState>> entry = iter.next();
            List<IBlockState> states = entry.getValue();
            states.removeAll((Collection<?>)block.func_176194_O().func_177619_a());
            if (!states.isEmpty()) continue;
            iter.remove();
        }
    }
}

