/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.reactor.uranTypes;

import ic2.core.item.reactor.uranTypes.IUranium;
import ic2.core.item.reactor.uranTypes.UranBaseType;
import ic2.core.platform.lang.components.base.LocaleComp;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2Lang;
import ic2.core.util.misc.StackUtil;
import java.awt.Color;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CharcoalUranium
extends UranBaseType {
    public CharcoalUranium() {
        this.loadDefaults();
    }

    @Override
    public int getMaxDurability() {
        return 15000;
    }

    @Override
    public float getEUPerPulse() {
        return 0.6f;
    }

    @Override
    public int getPulsesPerTick() {
        return 1;
    }

    @Override
    public int getPulsesForConnection() {
        return 1;
    }

    @Override
    public float getHeatModifier() {
        return 1.0f;
    }

    @Override
    public float getExplosionEffectModifier() {
        return 2.0f;
    }

    @Override
    public ItemStack getUraniumIngot() {
        return Ic2Items.charcoalUraniumIngot.func_77946_l();
    }

    @Override
    public ItemStack getRodType(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2Items.reactorCharcoalUraniumRodSingle.func_77946_l();
            }
            case DualRod: {
                return Ic2Items.reactorCharcoalUraniumRodDual.func_77946_l();
            }
            case QuadRod: {
                return Ic2Items.reactorCharcoalUraniumRodQuad.func_77946_l();
            }
            case NearDepletedRod: {
                return Ic2Items.reactorNearDepletedCharcoalUraniumRod.func_77946_l();
            }
            case IsotopicRod: {
                return Ic2Items.reactorCharcoalUraniumIsotopicRod.func_77946_l();
            }
            case ReEnrichedRod: {
                return Ic2Items.reactorReEnrichedCharcoalUraniumRod.func_77946_l();
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public ItemStack getNewIsotopicRod() {
        return StackUtil.copyWithDamage(this.getRodType(IUranium.RodType.IsotopicRod), this.getMaxDurability() - 1);
    }

    @Override
    public short getRodID(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return 40;
            }
            case DualRod: {
                return 41;
            }
            case QuadRod: {
                return 42;
            }
            case IsotopicRod: {
                return 47;
            }
        }
        return 0;
    }

    @Override
    public LocaleComp getName(IUranium.RodType type) {
        switch (type) {
            case SingleRod: {
                return Ic2ItemLang.uranRodCharcoalSingle;
            }
            case DualRod: {
                return Ic2ItemLang.uranRodCharcoalDouble;
            }
            case QuadRod: {
                return Ic2ItemLang.uranRodCharcoalQuad;
            }
            case NearDepletedRod: {
                return Ic2ItemLang.uranRodCharcoalNearDeplete;
            }
            case IsotopicRod: {
                return Ic2ItemLang.uranRodCharcoalIsotopic;
            }
            case ReEnrichedRod: {
                return Ic2ItemLang.uranRodCharcoalReEnriched;
            }
        }
        return Ic2Lang.nullKey;
    }

    @Override
    public boolean isReEnrichedUran() {
        return true;
    }

    @Override
    public Color getReEnrichedColor() {
        return new Color(0x363636);
    }

    @Override
    public ItemStack getIngridient() {
        return new ItemStack(Items.field_151044_h, 1, 1);
    }

    @Override
    public int getIngrientPoints() {
        return 25;
    }

    @Override
    public int getRow() {
        return 5;
    }

    @Override
    public int getIngridientCost() {
        return 5;
    }
}

