/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.block.personal.base.misc.PersonalInventory;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.base.IHasInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.inventory.management.IHasHandler;
import ic2.core.inventory.management.InventoryHandler;
import ic2.core.item.inv.container.ContainerMachineTool;
import ic2.core.util.misc.StackUtil;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;

public class InventoryMachineTool
implements IHasGui {
    public IHasInventory inv;
    public InventoryHandler handler;
    boolean allowSlot;

    public InventoryMachineTool(EntityPlayer player, ItemStack stack) {
        BlockPos pos = this.getPos(stack);
        if (pos == null) {
            this.inv = new PersonalInventory(5);
            this.allowSlot = false;
            this.handler = null;
        } else {
            InventoryHandler invHandler;
            TileEntity tile = player.field_70170_p.func_175625_s(pos);
            if (tile instanceof IHasHandler && (invHandler = ((IHasHandler)tile).getHandler()) != null) {
                this.inv = invHandler.getUpgradeSlots();
                this.allowSlot = invHandler.canModifySlots();
                this.handler = invHandler;
            }
            if (this.inv == null) {
                this.inv = new PersonalInventory(5);
                this.allowSlot = false;
                this.handler = null;
            }
        }
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerMachineTool(player.field_71071_by, this.handler, this.inv, this.allowSlot, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return this.handler != null && !player.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    private BlockPos getPos(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        int[] array = nbt.func_74759_k("Pos");
        if (array.length != 3) {
            return null;
        }
        return new BlockPos(array[0], array[1], array[2]);
    }
}

