/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.block.base.util.comparator.ComparatorManager;
import ic2.core.block.base.util.comparator.IComparator;
import ic2.core.block.base.util.comparator.IHasComparator;
import ic2.core.inventory.base.IHasGui;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.inv.container.ContainerComparatorTool;
import ic2.core.util.misc.StackUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;

public class InventoryComparatorTool
implements IHasGui {
    public BlockPos pos;
    public EntityPlayer player;
    public EnumHand hand;
    public ItemStack stack;
    public int currentSelected = 6;
    public String[] selected;
    public boolean[] isInverted;
    public boolean[] isByte;
    public boolean[] isStatic;
    public List<String> ids = new ArrayList<String>();
    public Map<String, IComparator> comparators = new HashMap<String, IComparator>();
    public boolean valid;

    public InventoryComparatorTool(EntityPlayer player, EnumHand hand, ItemStack stack) {
        IHasComparator comp;
        ComparatorManager manager;
        TileEntity tile;
        this.player = player;
        this.hand = hand;
        this.stack = stack;
        this.pos = this.getPos(stack);
        if (this.pos != null && (tile = player.field_70170_p.func_175625_s(this.pos)) instanceof IHasComparator && (manager = (comp = (IHasComparator)tile).getManager()) != null) {
            this.valid = true;
            this.selected = manager.sides;
            this.isInverted = manager.inverted;
            this.isByte = manager.byteSide;
            this.isStatic = manager.staticSides;
            this.ids.addAll(manager.comparators.keySet());
            this.comparators.putAll(manager.comparators);
            return;
        }
        this.valid = false;
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerComparatorTool(player.field_71071_by, this);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public void onGuiClosed(EntityPlayer player) {
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !player.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    private BlockPos getPos(ItemStack stack) {
        NBTTagCompound nbt = StackUtil.getNbtData(stack);
        int[] array = nbt.func_74759_k("Pos");
        if (array.length != 3) {
            return null;
        }
        return new BlockPos(array[0], array[1], array[2]);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.selected = new String[7];
        this.isStatic = new boolean[7];
        this.isByte = new boolean[7];
        this.isInverted = new boolean[7];
        NBTTagList list = nbt.func_150295_c("Data", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            String id = data.func_74779_i("ID");
            if (!this.comparators.containsKey(id)) continue;
            int side = data.func_74762_e("Slot");
            this.selected[side] = id;
            this.isStatic[side] = data.func_74767_n("Static");
            this.isByte[side] = data.func_74767_n("ByteValue");
            this.isInverted[side] = data.func_74767_n("Inverted");
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 7; ++i) {
            if (this.selected[i] == null) continue;
            NBTTagCompound data = new NBTTagCompound();
            data.func_74774_a("Slot", (byte)i);
            data.func_74778_a("ID", this.selected[i]);
            data.func_74757_a("Static", this.isStatic[i]);
            data.func_74757_a("ByteValue", this.isByte[i]);
            data.func_74757_a("Inverted", this.isInverted[i]);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("Data", (NBTBase)list);
    }
}

