/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.inv.inventories;

import ic2.core.inventory.base.IC2ItemInventory;
import ic2.core.inventory.base.IHandHeldInventory;
import ic2.core.inventory.container.ContainerIC2;
import ic2.core.inventory.gui.GuiComponentContainer;
import ic2.core.item.inv.container.ContainerFluidScanner;
import ic2.core.item.misc.ItemDisplayIcon;
import ic2.core.util.misc.FluidHelper;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fluids.FluidStack;

public class FluidScannerInv
extends IC2ItemInventory {
    public FluidScannerInv(EntityPlayer player, IHandHeldInventory inv, ItemStack item) {
        super(player, inv, item);
    }

    @Override
    public ContainerIC2 getGuiContainer(EntityPlayer player) {
        return new ContainerFluidScanner(this, this.getID(), player.field_71071_by);
    }

    @Override
    public Class<? extends GuiScreen> getGuiClass(EntityPlayer player) {
        return GuiComponentContainer.class;
    }

    @Override
    public boolean canInteractWith(EntityPlayer player) {
        return !player.field_70128_L;
    }

    @Override
    public boolean hasGui(EntityPlayer player) {
        return true;
    }

    @Override
    public int getInventorySize() {
        return 9;
    }

    public void setFluid(int slot, FluidStack fluid) {
        if (slot >= 0 && slot < this.inventory.size()) {
            if (fluid == null) {
                this.inventory.set(1, (Object)ItemStack.field_190927_a);
                return;
            }
            this.inventory.set(slot, (Object)ItemDisplayIcon.createWithFluidStack(FluidHelper.copyWithSize(fluid, 1)));
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.inventory = NonNullList.func_191197_a((int)this.getInventorySize(), (Object)ItemStack.field_190927_a);
        NBTTagList list = nbt.func_150295_c("FluidData", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound data = list.func_150305_b(i);
            byte slot = data.func_74771_c("SlotID");
            FluidStack fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)data);
            if (fluid == null || slot < 0 || slot >= this.inventory.size()) continue;
            this.inventory.set((int)slot, (Object)ItemDisplayIcon.createWithFluidStack(fluid));
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)this.inventory.get(i);
            FluidStack fluid = ItemDisplayIcon.getFluidStack(stack);
            if (fluid == null) continue;
            NBTTagCompound data = fluid.writeToNBT(new NBTTagCompound());
            data.func_74774_a("SlotID", (byte)i);
            list.func_74742_a((NBTBase)data);
        }
        nbt.func_74782_a("FluidData", (NBTBase)list);
    }
}

