/*
 * Decompiled with CFR 0.152.
 */
package ic2.core.item.crop;

import ic2.api.classic.crops.ClassicCrops;
import ic2.api.classic.crops.ICropSoil;
import ic2.api.classic.crops.IFarmland;
import ic2.core.IC2;
import ic2.core.block.crop.TileEntityCrop;
import ic2.core.item.base.ItemIC2;
import ic2.core.platform.lang.storage.Ic2InfoLang;
import ic2.core.platform.lang.storage.Ic2ItemLang;
import ic2.core.platform.registry.Ic2Items;
import ic2.core.platform.registry.Ic2States;
import ic2.core.platform.textures.Ic2Icons;
import ic2.core.util.obj.IBootable;
import ic2.core.util.obj.IMetaSoundBlock;
import java.util.Arrays;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemCropStick
extends ItemIC2
implements IBootable {
    public static final IFarmland defaultLand = new NullFarmland();

    public ItemCropStick() {
        this.setTranslationKey(Ic2ItemLang.cropStick);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (flagIn.func_194127_a() && GuiScreen.func_146271_m()) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            BlockPos pos = player.func_180425_c();
            World world = player.func_130014_f_();
            tooltip.add(Ic2InfoLang.cropNutrientPoints.getLocalizedFormatted(this.getNutriens(world, pos), TextFormatting.DARK_GREEN));
            tooltip.add(Ic2InfoLang.cropHumidityPoints.getLocalizedFormatted(this.getHumidity(world, pos), TextFormatting.GREEN));
            tooltip.add(Ic2InfoLang.cropAirPoints.getLocalizedFormatted(this.getAirQuality(world, pos), TextFormatting.BLUE));
        }
    }

    public byte getNutriens(World world, BlockPos pos) {
        BlockPos target;
        ICropSoil soil;
        int value = ClassicCrops.instance.getNutrientBiomeBonus(world.func_180494_b(pos));
        value += this.getFarmland(world, pos).getNutrients(world, pos.func_177977_b());
        for (int i = 2; i < 5 && (soil = ClassicCrops.instance.getSoil(world.func_180495_p(target = pos.func_177979_c(i)))) != null; ++i) {
            value += soil.getNutrientEffect(world, target);
        }
        return (byte)value;
    }

    public IFarmland getFarmland(World world, BlockPos pos) {
        IFarmland land = ClassicCrops.instance.getFarmland(world.func_180495_p(pos.func_177977_b()));
        if (land == null) {
            land = defaultLand;
        }
        return land;
    }

    public byte getHumidity(World world, BlockPos pos) {
        BlockPos target;
        ICropSoil soil;
        int value = ClassicCrops.instance.getHumidityBiomeBonus(world.func_180494_b(pos));
        value += this.getFarmland(world, pos).getHumidity(world, pos.func_177977_b());
        for (int i = 2; i < 5 && (soil = ClassicCrops.instance.getSoil(world.func_180495_p(target = pos.func_177979_c(i)))) != null; ++i) {
            value += soil.getHumidityEffect(world, target);
        }
        return (byte)value;
    }

    public byte getAirQuality(World world, BlockPos pos) {
        int value = 0;
        int height = (pos.func_177956_o() - 64) / 15;
        if (height > 4) {
            height = 4;
        }
        if (height < 0) {
            height = 0;
        }
        value += height;
        int fresh = 9;
        for (int x = pos.func_177958_n() - 1; x < pos.func_177958_n() + 1 && fresh > 0; ++x) {
            for (int z = pos.func_177952_p() - 1; z < pos.func_177952_p() + 1 && fresh > 0; ++z) {
                BlockPos target = new BlockPos(x, pos.func_177956_o(), z);
                if (!world.func_175677_d(target, false) && !(world.func_175625_s(target) instanceof TileEntityCrop)) continue;
                --fresh;
            }
        }
        value += fresh / 2;
        if (world.func_175710_j(pos.func_177984_a())) {
            value += 2;
        }
        return (byte)value;
    }

    @Override
    public void onLoad() {
        Ic2Items.cropStick = new ItemStack((Item)this);
    }

    @Override
    public List<Integer> getValidVariants() {
        return Arrays.asList(0);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public TextureAtlasSprite getTexture(int meta) {
        return Ic2Icons.getTextures("bc")[0];
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.add((Object)new ItemStack((Item)this));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack;
        IBlockState iblockstate = worldIn.func_180495_p(pos);
        Block block = iblockstate.func_177230_c();
        if (!block.func_176200_f((IBlockAccess)worldIn, pos)) {
            pos = pos.func_177972_a(facing);
        }
        if (!(stack = player.func_184586_b(hand)).func_190926_b() && player.func_175151_a(pos, facing, stack) && worldIn.func_190527_a(this.getBlock(), pos, false, facing, (Entity)null)) {
            int i = this.func_77647_b(stack.func_77960_j());
            IBlockState iblockstate1 = this.getBlock().getStateForPlacement(worldIn, pos, facing, hitX, hitY, hitZ, i, (EntityLivingBase)player, hand);
            if (this.placeBlockAt(stack, player, worldIn, pos, facing, hitX, hitY, hitZ, iblockstate1)) {
                if (IC2.platform.isRendering()) {
                    SoundType soundtype = this.getSound(iblockstate1);
                    worldIn.func_184133_a(player, pos, soundtype.func_185841_e(), SoundCategory.BLOCKS, (soundtype.func_185843_a() + 1.0f) / 2.0f, soundtype.func_185847_b() * 0.8f);
                }
                stack.func_190918_g(1);
            }
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!world.func_180501_a(pos, newState, 3)) {
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == this.getBlock()) {
            this.getBlock().func_180633_a(world, pos, state, (EntityLivingBase)player, stack);
            return true;
        }
        return false;
    }

    public SoundType getSound(IBlockState state) {
        SoundType type;
        if (state.func_177230_c() instanceof IMetaSoundBlock && (type = ((IMetaSoundBlock)state.func_177230_c()).getSoundFromState(state)) != null) {
            return type;
        }
        return this.getBlock().func_185467_w();
    }

    public Block getBlock() {
        return Ic2States.cropStick.func_177230_c();
    }

    @Override
    public int getTextureEntry(int meta) {
        return 0;
    }

    public static class NullFarmland
    implements IFarmland {
        @Override
        public int getHumidity(World world, BlockPos pos) {
            return 0;
        }

        @Override
        public int getNutrients(World world, BlockPos pos) {
            return 0;
        }

        @Override
        public int getHumidity(IBlockState state) {
            return 0;
        }

        @Override
        public int getNutrients(IBlockState state) {
            return 0;
        }
    }
}

